/*
 * Copyright (C) 2022 Berner Fachhochschule https://e-voting.bfh.ch
 *
 *  - This program is free software: you can redistribute it and/or modify                           -
 *  - it under the terms of the GNU Affero General Public License as published by                    -
 *  - the Free Software Foundation, either version 3 of the License, or                              -
 *  - (at your option) any later version.                                                            -
 *  -                                                                                                -
 *  - This program is distributed in the hope that it will be useful,                                -
 *  - but WITHOUT ANY WARRANTY; without even the implied warranty of                                 -
 *  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                   -
 *  - GNU General Public License for more details.                                                   -
 *  -                                                                                                -
 *  - You should have received a copy of the GNU Affero General Public License                       -
 *  - along with this program. If not, see <http://www.gnu.org/licenses/>.                           -
 */
package ch.openchvote.printingauthority.plain.tasks;

import ch.openchvote.algorithms.common.GetVotingCards;
import ch.openchvote.parameters.Parameters;
import ch.openchvote.printingauthority.plain.EventData;

public class T1 {

    public static void run(EventData eventData, Parameters params) {

        // perform task
        var bold_D = eventData.bold_D.build();
        var bold_vc = GetVotingCards.run(bold_D, params);

        // update event data
        eventData.bold_vc.set(bold_vc);
    }

}
