/*
 * Decompiled with CFR 0.152.
 */
package ch.openchvote.printingauthority.plain.states;

import ch.openchvote.algorithms.AlgorithmException;
import ch.openchvote.framework.Message;
import ch.openchvote.framework.State;
import ch.openchvote.framework.context.EventMessages;
import ch.openchvote.framework.context.EventSetup;
import ch.openchvote.model.common.VotingCard;
import ch.openchvote.model.plain.ElectionParameters;
import ch.openchvote.parameters.Parameters;
import ch.openchvote.printingauthority.PrintingAuthority;
import ch.openchvote.printingauthority.plain.EventData;
import ch.openchvote.printingauthority.plain.states.E1;
import ch.openchvote.printingauthority.plain.states.S2;
import ch.openchvote.printingauthority.plain.tasks.T1;
import ch.openchvote.protocol.message.MessageType;
import ch.openchvote.protocol.message.plain.MAP1;
import ch.openchvote.protocol.message.plain.MEP1;
import ch.openchvote.protocol.message.plain.MPV1;
import ch.openchvote.util.Vector;

public final class S1
extends State<PrintingAuthority, EventData> {
    public S1() {
        super(State.Type.START);
        this.registerMessageHandler((Message.Type)MessageType.MAP1, S1::handleMAP1);
        this.registerMessageHandler((Message.Type)MessageType.MEP1, S1::handleMEP1);
        this.registerMessageHandler(S1::handleINT);
    }

    private static void handleMAP1(PrintingAuthority printingAuthority, Message message, EventSetup eventSetup, EventData eventData) {
        MAP1 messageContent = (MAP1)printingAuthority.checkAndGetContent(MAP1.class, message, eventSetup);
        ElectionParameters EP = messageContent.get_EP();
        eventData.EP.set((Object)EP);
        printingAuthority.sendInternalMessage(eventSetup);
    }

    private static void handleMEP1(PrintingAuthority printingAuthority, Message message, EventSetup eventSetup, EventData eventData) {
        ElectionParameters EP = (ElectionParameters)eventData.EP.get();
        MEP1 messageContent = (MEP1)printingAuthority.checkAndGetContent(MEP1.class, message, EP, eventSetup);
        Vector bold_d_j = messageContent.get_bold_d();
        int j = eventSetup.getParticipantIndex(message.getSenderId());
        eventData.bold_D.set(j, (Object)bold_d_j);
        printingAuthority.sendInternalMessage(eventSetup);
    }

    private static void handleINT(PrintingAuthority printingAuthority, EventSetup eventSetup, EventData eventData, EventMessages eventMessages) {
        Parameters params = new Parameters(eventSetup.getSecurityLevel());
        if (eventMessages.hasAllMessages(eventSetup, (Message.Type)MessageType.MAP1) && eventMessages.hasAllMessages(eventSetup, (Message.Type)MessageType.MEP1)) {
            try {
                T1.run(eventData, params);
                int N_E = ((ElectionParameters)eventData.EP.get()).get_bold_d().getLength();
                Vector bold_vc = (Vector)eventData.bold_vc.get();
                for (int i = 1; i <= N_E; ++i) {
                    VotingCard VC_i = (VotingCard)bold_vc.getValue(i);
                    printingAuthority.sendMessage(i, (Message.Content)new MPV1(VC_i), eventSetup);
                }
                eventData.setCurrentState(S2.class);
            }
            catch (AlgorithmException exception) {
                eventData.setCurrentState(E1.class);
            }
        }
    }
}

