/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.complexity.LabeledExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LabeledExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoredLabels", "", "", "getIgnoredLabels$annotations", "()V", "getIgnoredLabels", "()Ljava/util/List;", "ignoredLabels$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getClassHierarchy", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "classes", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "isAllowedToReferenceContainingClass", "", "klass", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "isNotReferencingOuterClass", "visitExpressionWithLabel", "detekt-rules-complexity"})
public final class LabeledExpression
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoredLabels$delegate;

    public LabeledExpression(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("LabeledExpression", Severity.Maintainability, "Expression with labels increase complexity and affect maintainability.", Debt.Companion.getTWENTY_MINS());
        this.ignoredLabels$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)ignoredLabels.2.INSTANCE);
    }

    public /* synthetic */ LabeledExpression(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getIgnoredLabels() {
        return (List)this.ignoredLabels$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="allows to provide a list of label names which should be ignored by this rule")
    private static /* synthetic */ void getIgnoredLabels$annotations() {
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitExpressionWithLabel(expression);
            if (expression instanceof KtThisExpression && !this.isNotReferencingOuterClass(expression)) break block6;
            String string = expression.getLabelName();
            if (string != null) {
                boolean bl;
                block5: {
                    String labelName = string;
                    boolean bl2 = false;
                    Iterable $this$none$iv = this.getIgnoredLabels();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.contains((CharSequence)labelName, (CharSequence)it, (boolean)true)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
                }
            }
        }
    }

    private final boolean isNotReferencingOuterClass(KtExpressionWithLabel expression) {
        boolean bl;
        block5: {
            List containingClasses = new ArrayList();
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)expression));
            if (ktClass == null) {
                return false;
            }
            KtClass containingClass = ktClass;
            if (this.isAllowedToReferenceContainingClass(containingClass, expression)) {
                containingClasses.add(containingClass);
            }
            this.getClassHierarchy((KtElement)containingClass, containingClasses);
            Iterable $this$any$iv = containingClasses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtClass it = (KtClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expression.getLabelName())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllowedToReferenceContainingClass(KtClass klass, KtExpressionWithLabel expression) {
        if (!klass.isInner()) return true;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) return false;
        if (!KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)ktNamedFunction))) return false;
        return true;
    }

    private final void getClassHierarchy(KtElement element, List<KtClass> classes) {
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)element);
        if (ktClass == null) {
            return;
        }
        KtClass containingClass = ktClass;
        classes.add(containingClass);
        this.getClassHierarchy((KtElement)containingClass, classes);
    }

    public LabeledExpression() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LabeledExpression.class, "ignoredLabels", "getIgnoredLabels()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

