/*
 * Decompiled with CFR 0.152.
 */
package com.appunite.firebasetestlabplugin.cloud;

import com.appunite.firebasetestlabplugin.FirebaseTestLabPlugin;
import com.appunite.firebasetestlabplugin.model.ResultTypes;
import com.appunite.firebasetestlabplugin.utils.CloudUtilsKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/appunite/firebasetestlabplugin/cloud/CloudTestResultDownloader;", "", "sdk", "Lcom/appunite/firebasetestlabplugin/FirebaseTestLabPlugin$Sdk;", "resultsTypes", "Lcom/appunite/firebasetestlabplugin/model/ResultTypes;", "gCloudDirectory", "Ljava/io/File;", "resultsPath", "gCloudBucketName", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/appunite/firebasetestlabplugin/FirebaseTestLabPlugin$Sdk;Lcom/appunite/firebasetestlabplugin/model/ResultTypes;Ljava/io/File;Ljava/io/File;Ljava/lang/String;Lorg/gradle/api/logging/Logger;)V", "clearResultsDir", "", "downloadTestResults", "getResults", "prepareDownloadDirectory", "plugin"})
public final class CloudTestResultDownloader {
    private final FirebaseTestLabPlugin.Sdk sdk;
    private final ResultTypes resultsTypes;
    private final File gCloudDirectory;
    private final File resultsPath;
    private final String gCloudBucketName;
    private final Logger logger;

    public final void getResults() {
        if (!(this.resultsTypes.getJunit() || this.resultsTypes.getLogcat() || this.resultsTypes.getVideo() || this.resultsTypes.getXml())) {
            return;
        }
        String gCloudFullPath = this.gCloudBucketName + '/' + this.gCloudDirectory;
        this.logger.lifecycle("DOWNLOAD: Downloading results from " + gCloudFullPath);
        this.prepareDownloadDirectory();
        this.downloadTestResults();
    }

    private final void prepareDownloadDirectory() {
        this.resultsPath.mkdirs();
        if (!this.resultsPath.exists()) {
            throw (Throwable)new GradleException("Issue when creating destination dir " + this.gCloudDirectory);
        }
    }

    private final void downloadTestResults() {
        Process process;
        StringBuilder excludeQuery = new StringBuilder().append("-x \".*\\.txt$|.*\\.apk$");
        if (!this.resultsTypes.getXml()) {
            excludeQuery.append("|.*\\.xml$");
        }
        if (!this.resultsTypes.getXml()) {
            excludeQuery.append("|.*\\.results$");
        }
        if (!this.resultsTypes.getLogcat()) {
            excludeQuery.append("|.*logcat$");
        }
        if (!this.resultsTypes.getVideo()) {
            excludeQuery.append("|.*\\.mp4$");
        }
        excludeQuery.append("|.*\\.txt$\"").toString();
        ProcessBuilder processCreator = new ProcessBuilder(CloudUtilsKt.asCommand(this.sdk.getGsutil().getAbsolutePath() + " -m rsync " + excludeQuery + " -r gs://" + this.gCloudBucketName + '/' + this.gCloudDirectory + ' ' + this.resultsPath));
        Process process2 = process = processCreator.start();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
        InputStream inputStream = process2.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CloudTestResultDownloader this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CloudTestResultDownloader.access$getLogger$p(this.this$0).lifecycle(it);
            }
            {
                this.this$0 = cloudTestResultDownloader;
                super(1);
            }
        }));
        InputStream inputStream3 = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"process.inputStream");
        inputStream2 = inputStream3;
        charset = Charsets.UTF_8;
        reader = new InputStreamReader(inputStream2, charset);
        n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CloudTestResultDownloader this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CloudTestResultDownloader.access$getLogger$p(this.this$0).lifecycle(it);
            }
            {
                this.this$0 = cloudTestResultDownloader;
                super(1);
            }
        }));
        process.waitFor();
    }

    public final void clearResultsDir() {
        Process process;
        ProcessBuilder processCreator = new ProcessBuilder(CloudUtilsKt.asCommand(this.sdk.getGsutil().getAbsolutePath() + " rm gs://" + this.gCloudBucketName + '/' + this.gCloudDirectory + "/**"));
        Process process2 = process = processCreator.start();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
        InputStream inputStream = process2.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CloudTestResultDownloader this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CloudTestResultDownloader.access$getLogger$p(this.this$0).lifecycle(it);
            }
            {
                this.this$0 = cloudTestResultDownloader;
                super(1);
            }
        }));
        InputStream inputStream3 = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"process.inputStream");
        inputStream2 = inputStream3;
        charset = Charsets.UTF_8;
        reader = new InputStreamReader(inputStream2, charset);
        n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CloudTestResultDownloader this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CloudTestResultDownloader.access$getLogger$p(this.this$0).lifecycle(it);
            }
            {
                this.this$0 = cloudTestResultDownloader;
                super(1);
            }
        }));
        process.waitFor();
    }

    public CloudTestResultDownloader(@NotNull FirebaseTestLabPlugin.Sdk sdk, @NotNull ResultTypes resultsTypes, @NotNull File gCloudDirectory, @NotNull File resultsPath, @NotNull String gCloudBucketName, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)resultsTypes, (String)"resultsTypes");
        Intrinsics.checkNotNullParameter((Object)gCloudDirectory, (String)"gCloudDirectory");
        Intrinsics.checkNotNullParameter((Object)resultsPath, (String)"resultsPath");
        Intrinsics.checkNotNullParameter((Object)gCloudBucketName, (String)"gCloudBucketName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.sdk = sdk;
        this.resultsTypes = resultsTypes;
        this.gCloudDirectory = gCloudDirectory;
        this.resultsPath = resultsPath;
        this.gCloudBucketName = gCloudBucketName;
        this.logger = logger;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CloudTestResultDownloader $this) {
        return $this.logger;
    }
}

