/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.searchbar.adapter.SearchBarAdapter;
import com.xm.ui.widget.searchbar.adapter.SearchResultAdapter;
import com.xm.ui.widget.searchbar.view.LetterView;
import com.xm.uilibrary.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@RequiresApi(api=21)
public class SearchBar
extends LinearLayout {
    private SearchBarAdapter searchBarAdapter;
    private RecyclerView rvListView;
    private ViewGroup rootLayout;
    private RelativeLayout rlInput;
    private EditText etInput;
    private ImageView ivBack;
    private ImageView ivInput;
    private OnLeftClickListener mOnLeftClick;
    private LetterView letterView;
    private HashMap<String, Integer> letterPosMap;
    private List<String> contentList;
    private SearchResultAdapter searchResultAdapter;
    private RecyclerView rvSearchResult;
    private TextView tvSearchResultCount;
    private LinearLayout llSearchResultLayout;
    private FrameLayout flSearchBarLayout;
    private ImageView ivClear;
    private int colorId;
    private int searchIcon;
    private int clearIcon;
    private int editTextBg;
    private String startColorStr;
    private String endColorStr;

    public SearchBar(Context context) {
        this(context, null);
    }

    public SearchBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SearchBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SearchBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SearchBar);
        if (typedArray == null) {
            return;
        }
        this.colorId = typedArray.getColor(R.styleable.SearchBar_colorId, -65536);
        this.editTextBg = typedArray.getResourceId(R.styleable.SearchBar_editTextBg, R.drawable.bg_edit);
        this.searchIcon = typedArray.getResourceId(R.styleable.SearchBar_searchIcon, R.mipmap.ic_xm_ui_search);
        this.clearIcon = typedArray.getResourceId(R.styleable.SearchBar_clearIcon, R.mipmap.ic_xm_ui_close);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
        this.initData();
    }

    private void initView() {
        this.rootLayout = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xm_ui_layout_search_bar, (ViewGroup)this);
        this.rvListView = (RecyclerView)this.rootLayout.findViewById(R.id.rv_pet_variety);
        this.ivBack = (ImageView)this.rootLayout.findViewById(R.id.iv_back);
        this.rvListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.rlInput = (RelativeLayout)this.rootLayout.findViewById(R.id.rl_search_bar_input);
        this.rlInput.setBackgroundResource(this.editTextBg);
        this.etInput = (EditText)this.rootLayout.findViewById(R.id.et_search_bar_input);
        this.ivInput = (ImageView)this.rootLayout.findViewById(R.id.iv_search_bar_input);
        this.ivInput.setImageResource(this.searchIcon);
        this.letterView = (LetterView)this.rootLayout.findViewById(R.id.letter_view);
        this.letterView.setColorId(this.colorId);
        this.letterView.setOnLetterSelectListener(new LetterView.OnLetterSelectListener(){

            @Override
            public void onSelected(String letter) {
                System.out.println("letter:" + letter);
                if (SearchBar.this.letterPosMap.containsKey(letter)) {
                    int pos = (Integer)SearchBar.this.letterPosMap.get(letter);
                    SearchBar.this.rvListView.scrollToPosition(pos);
                    ((LinearLayoutManager)SearchBar.this.rvListView.getLayoutManager()).scrollToPositionWithOffset(pos, 0);
                }
            }
        });
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchBar.this.mOnLeftClick != null) {
                    SearchBar.this.mOnLeftClick.onLeftclick();
                }
            }
        });
        this.etInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    InputMethodManager inputMethodManager = (InputMethodManager)SearchBar.this.getContext().getSystemService("input_method");
                    if (inputMethodManager != null && inputMethodManager.isActive((View)v)) {
                        inputMethodManager.hideSoftInputFromWindow(SearchBar.this.getWindowToken(), 0);
                        v.clearFocus();
                    }
                    return true;
                }
                return false;
            }
        });
        this.etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (TextUtils.isEmpty((CharSequence)s.toString()) || TextUtils.isEmpty((CharSequence)s.toString().replace(" ", ""))) {
                    SearchBar.this.hideSearchResult();
                    return;
                }
                SearchBar.this.showSearchResult();
                ArrayList<String> resSb = new ArrayList<String>();
                SearchBar.this.addChild(new ArrayList(SearchBar.this.contentList), s.toString().trim(), resSb);
                SearchBar.this.searchResultAdapter.setData(resSb, SearchBar.this.startColorStr, SearchBar.this.endColorStr);
                SearchBar.this.tvSearchResultCount.setText((CharSequence)String.format(SearchBar.this.getContext().getString(R.string.search_result), resSb.size()));
            }
        });
        this.llSearchResultLayout = (LinearLayout)this.rootLayout.findViewById(R.id.ll_search_result_layout);
        this.tvSearchResultCount = (TextView)this.rootLayout.findViewById(R.id.tv_search_result_count);
        this.flSearchBarLayout = (FrameLayout)this.rootLayout.findViewById(R.id.fl_search_bar_layout);
        this.rvSearchResult = (RecyclerView)this.rootLayout.findViewById(R.id.rv_search_result);
        this.ivClear = (ImageView)this.rootLayout.findViewById(R.id.iv_search_bar_clear);
        this.ivClear.setImageResource(this.clearIcon);
        this.ivClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchBar.this.etInput.setText((CharSequence)"");
            }
        });
        this.rvSearchResult.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    private void initData() {
        this.contentList = new ArrayList<String>();
        this.letterPosMap = new HashMap();
        this.searchBarAdapter = new SearchBarAdapter();
        this.searchBarAdapter.setColorId(this.colorId);
        this.rvListView.setAdapter((RecyclerView.Adapter)this.searchBarAdapter);
        this.searchResultAdapter = new SearchResultAdapter();
        this.rvSearchResult.setAdapter((RecyclerView.Adapter)this.searchResultAdapter);
        String hexColor = String.format("#%06X", 0xFFFFFF & this.colorId);
        this.startColorStr = "<font color='" + hexColor + "'>";
        this.endColorStr = "</font>";
    }

    public void setData(ArrayList<Bundle> dataList) {
        if (dataList == null) {
            return;
        }
        String curTitle = "";
        for (int i = 0; i < dataList.size(); ++i) {
            Bundle bundle = dataList.get(i);
            if (bundle == null) continue;
            String title = bundle.getString("title");
            if (!TextUtils.isEmpty((CharSequence)title) && !curTitle.equals(title)) {
                this.letterPosMap.put(title, i);
            } else {
                bundle.putString("title", "");
            }
            curTitle = title;
            String content = bundle.getString("content");
            this.contentList.add(content);
        }
        this.searchBarAdapter.setDataList(dataList);
    }

    private List<String> addChild(List<String> srcList, String key, List<String> resStr) {
        if (srcList != null && !srcList.isEmpty()) {
            String str = srcList.get(0);
            if (str == null) {
                return resStr;
            }
            int index = str.length();
            int theIndex = str.toUpperCase().indexOf(key.toUpperCase());
            if (theIndex < index) {
                index = theIndex;
            }
            if (index != str.length()) {
                if (index >= 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(str.substring(0, index));
                    sb.append(this.startColorStr).append(str.substring(index, index + key.length())).append(this.endColorStr);
                    sb.append(str.substring(index + key.length()));
                    if (!resStr.contains(sb.toString())) {
                        resStr.add(sb.toString());
                    }
                }
                srcList.remove(0);
                if (!srcList.isEmpty()) {
                    this.addChild(srcList, key, resStr);
                }
            }
            return resStr;
        }
        return resStr;
    }

    private void showSearchResult() {
        this.llSearchResultLayout.setVisibility(0);
        this.flSearchBarLayout.setVisibility(8);
        this.ivClear.setVisibility(0);
    }

    private void hideSearchResult() {
        this.llSearchResultLayout.setVisibility(8);
        this.flSearchBarLayout.setVisibility(0);
        this.ivClear.setVisibility(8);
    }

    public void setCurrentIndex(String content) {
        if (this.searchBarAdapter != null) {
            this.searchBarAdapter.setCurrentContent(content);
        }
        if (this.searchResultAdapter != null) {
            this.searchResultAdapter.setCurrentContent(content);
        }
    }

    public void setOnSearchBarClickListener(SearchBarAdapter.OnSearchBarClickListener listener) {
        if (this.searchBarAdapter != null) {
            this.searchBarAdapter.setOnSearchBarClickListener(listener);
        }
    }

    public void setOnSearchResultClickListener(SearchResultAdapter.OnSearchResultClickListener listener) {
        if (this.searchResultAdapter != null) {
            this.searchResultAdapter.setOnSearchResultClickListener(listener);
        }
    }

    public void setLeftClick(OnLeftClickListener mOnClick) {
        this.mOnLeftClick = mOnClick;
    }

    public static interface OnLeftClickListener {
        public void onLeftclick();
    }
}

