/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.searchbar.adapter.AreaCodeSearchBarAdapter;
import com.xm.ui.widget.searchbar.adapter.AreaCodeSearchResultAdapter;
import com.xm.ui.widget.searchbar.bean.AreaBean;
import com.xm.ui.widget.searchbar.view.LetterView;
import com.xm.uilibrary.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RequiresApi(api=21)
public class AreaCodeSearchBar
extends LinearLayout {
    private AreaCodeSearchBarAdapter areaCodeSearchBarAdapter;
    private RecyclerView rvListView;
    private ViewGroup rootLayout;
    private RelativeLayout rlInput;
    private EditText etInput;
    private ImageView ivBack;
    private ImageView ivInput;
    private RelativeLayout rlRecommend;
    private TextView tvRecommendArea;
    private TextView tvRecommend;
    private TextView tvRecommendCode;
    private OnLeftClickListener mOnLeftClick;
    private AreaCodeSearchResultAdapter.OnSearchResultClickListener listener;
    private LetterView letterView;
    private HashMap<String, Integer> letterPosMap;
    private List<AreaBean> contentList;
    private AreaCodeSearchResultAdapter areaCodeSearchResultAdapter;
    private RecyclerView rvSearchResult;
    private TextView tvSearchResultCount;
    private LinearLayout llSearchResultLayout;
    private FrameLayout flSearchBarLayout;
    private ImageView ivClear;
    private int colorId;
    private int searchIcon;
    private int clearIcon;
    private int editTextBg;
    private String startColorStr;
    private String endColorStr;

    public AreaCodeSearchBar(Context context) {
        this(context, null);
    }

    public AreaCodeSearchBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AreaCodeSearchBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AreaCodeSearchBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SearchBar);
        if (typedArray == null) {
            return;
        }
        this.colorId = typedArray.getColor(R.styleable.SearchBar_colorId, -65536);
        this.editTextBg = typedArray.getResourceId(R.styleable.SearchBar_editTextBg, R.drawable.bg_edit);
        this.searchIcon = typedArray.getResourceId(R.styleable.SearchBar_searchIcon, R.mipmap.ic_xm_ui_search);
        this.clearIcon = typedArray.getResourceId(R.styleable.SearchBar_clearIcon, R.mipmap.ic_xm_ui_close);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
        this.initData();
    }

    private void initView() {
        this.rootLayout = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xm_ui_layout_area_code_search_bar, (ViewGroup)this);
        this.rvListView = (RecyclerView)this.rootLayout.findViewById(R.id.rv_pet_variety);
        this.ivBack = (ImageView)this.rootLayout.findViewById(R.id.iv_back);
        this.rvListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.rlInput = (RelativeLayout)this.rootLayout.findViewById(R.id.rl_search_bar_input);
        this.rlInput.setBackgroundResource(this.editTextBg);
        this.rlRecommend = (RelativeLayout)this.rootLayout.findViewById(R.id.rl_recommend_area);
        this.tvRecommendArea = (TextView)this.rootLayout.findViewById(R.id.tv_area);
        this.tvRecommendCode = (TextView)this.rootLayout.findViewById(R.id.tv_area_code);
        this.tvRecommend = (TextView)this.rootLayout.findViewById(R.id.tv_recommend);
        this.etInput = (EditText)this.rootLayout.findViewById(R.id.et_search_bar_input);
        this.ivInput = (ImageView)this.rootLayout.findViewById(R.id.iv_search_bar_input);
        this.ivInput.setImageResource(this.searchIcon);
        this.letterView = (LetterView)this.rootLayout.findViewById(R.id.letter_view);
        this.letterView.setColorId(this.colorId);
        this.letterView.setOnLetterSelectListener(new LetterView.OnLetterSelectListener(){

            @Override
            public void onSelected(String letter) {
                System.out.println("letter:" + letter);
                if (AreaCodeSearchBar.this.letterPosMap.containsKey(letter)) {
                    int pos = (Integer)AreaCodeSearchBar.this.letterPosMap.get(letter);
                    AreaCodeSearchBar.this.rvListView.scrollToPosition(pos);
                    ((LinearLayoutManager)AreaCodeSearchBar.this.rvListView.getLayoutManager()).scrollToPositionWithOffset(pos, 0);
                }
            }
        });
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AreaCodeSearchBar.this.mOnLeftClick != null) {
                    AreaCodeSearchBar.this.mOnLeftClick.onLeftclick();
                }
            }
        });
        this.etInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    InputMethodManager inputMethodManager = (InputMethodManager)AreaCodeSearchBar.this.getContext().getSystemService("input_method");
                    if (inputMethodManager != null && inputMethodManager.isActive((View)v)) {
                        inputMethodManager.hideSoftInputFromWindow(AreaCodeSearchBar.this.getWindowToken(), 0);
                        v.clearFocus();
                    }
                    return true;
                }
                return false;
            }
        });
        this.etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (TextUtils.isEmpty((CharSequence)s.toString()) || TextUtils.isEmpty((CharSequence)s.toString().replace(" ", ""))) {
                    AreaCodeSearchBar.this.hideSearchResult();
                    return;
                }
                AreaCodeSearchBar.this.showSearchResult();
                ArrayList<AreaBean> resSb = new ArrayList<AreaBean>();
                AreaCodeSearchBar.this.addChild(new ArrayList(AreaCodeSearchBar.this.contentList), s.toString().trim(), resSb);
                AreaCodeSearchBar.this.areaCodeSearchResultAdapter.setData(resSb, AreaCodeSearchBar.this.startColorStr, AreaCodeSearchBar.this.endColorStr);
                AreaCodeSearchBar.this.tvSearchResultCount.setText((CharSequence)String.format(AreaCodeSearchBar.this.getContext().getString(R.string.search_result), resSb.size()));
            }
        });
        this.llSearchResultLayout = (LinearLayout)this.rootLayout.findViewById(R.id.ll_search_result_layout);
        this.tvSearchResultCount = (TextView)this.rootLayout.findViewById(R.id.tv_search_result_count);
        this.flSearchBarLayout = (FrameLayout)this.rootLayout.findViewById(R.id.fl_search_bar_layout);
        this.rvSearchResult = (RecyclerView)this.rootLayout.findViewById(R.id.rv_search_result);
        this.ivClear = (ImageView)this.rootLayout.findViewById(R.id.iv_search_bar_clear);
        this.ivClear.setImageResource(this.clearIcon);
        this.ivClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AreaCodeSearchBar.this.etInput.setText((CharSequence)"");
            }
        });
        this.rlRecommend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AreaCodeSearchBar.this.listener != null) {
                    AreaBean areaBean = new AreaBean();
                    areaBean.setAreaContent(AreaCodeSearchBar.this.tvRecommendArea.getText().toString());
                    areaBean.setAreaCode(AreaCodeSearchBar.this.tvRecommendCode.getText().toString());
                    AreaCodeSearchBar.this.listener.onResultClick(areaBean);
                }
            }
        });
        this.rvSearchResult.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    private void initData() {
        this.contentList = new ArrayList<AreaBean>();
        this.letterPosMap = new HashMap();
        this.areaCodeSearchBarAdapter = new AreaCodeSearchBarAdapter(true);
        this.areaCodeSearchBarAdapter.setColorId(this.colorId);
        this.rvListView.setAdapter((RecyclerView.Adapter)this.areaCodeSearchBarAdapter);
        this.areaCodeSearchResultAdapter = new AreaCodeSearchResultAdapter(true, this.colorId);
        this.rvSearchResult.setAdapter((RecyclerView.Adapter)this.areaCodeSearchResultAdapter);
        String hexColor = String.format("#%06X", 0xFFFFFF & this.colorId);
        this.startColorStr = "<font color='" + hexColor + "'>";
        this.endColorStr = "</font>";
    }

    public void setData(ArrayList<Bundle> dataList) {
        if (dataList == null) {
            return;
        }
        String curTitle = "";
        for (int i = 0; i < dataList.size(); ++i) {
            Bundle bundle = dataList.get(i);
            if (bundle == null) continue;
            String title = bundle.getString("title");
            if (!TextUtils.isEmpty((CharSequence)title) && !curTitle.equals(title)) {
                this.letterPosMap.put(title, i);
            } else {
                bundle.putString("title", "");
            }
            curTitle = title;
            String content = bundle.getString("content");
            String areaCode = bundle.getString("areaCode");
            AreaBean areaBean = new AreaBean();
            areaBean.setAreaContent(content);
            areaBean.setAreaCode(areaCode);
            this.contentList.add(areaBean);
        }
        this.areaCodeSearchBarAdapter.setDataList(dataList);
    }

    private List<AreaBean> addChild(List<AreaBean> srcList, String key, List<AreaBean> resStr) {
        if (srcList == null || srcList.isEmpty()) {
            return resStr;
        }
        String str = srcList.get(0).getAreaContent();
        String code = srcList.get(0).getAreaCode();
        AreaBean areaBean = new AreaBean();
        if (str == null || code == null) {
            return resStr;
        }
        if (AreaCodeSearchBar.isContainsNum(key)) {
            int index = code.length();
            int theIndex = code.toUpperCase().indexOf(key.toUpperCase());
            if (theIndex < index) {
                index = theIndex;
            }
            if (index != code.length() && index >= 0) {
                StringBuffer codeSb = new StringBuffer();
                codeSb.append(code.substring(0, index));
                codeSb.append(this.startColorStr).append(code.substring(index, index + key.length())).append(this.endColorStr);
                codeSb.append(code.substring(index + key.length()));
                areaBean.setAreaContent(str);
                areaBean.setAreaCode(codeSb.toString());
                if (!resStr.contains(areaBean)) {
                    resStr.add(areaBean);
                }
            }
        } else {
            int index = str.length();
            int theIndex = str.toUpperCase().indexOf(key.toUpperCase());
            if (theIndex < index) {
                index = theIndex;
            }
            if (index != str.length() && index >= 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(str.substring(0, index));
                sb.append(this.startColorStr).append(str.substring(index, index + key.length())).append(this.endColorStr);
                sb.append(str.substring(index + key.length()));
                areaBean.setAreaContent(sb.toString());
                areaBean.setAreaCode(code);
                if (!resStr.contains(areaBean)) {
                    resStr.add(areaBean);
                }
            }
        }
        srcList.remove(0);
        if (!srcList.isEmpty()) {
            this.addChild(srcList, key, resStr);
        }
        return resStr;
    }

    private void showSearchResult() {
        this.llSearchResultLayout.setVisibility(0);
        this.flSearchBarLayout.setVisibility(8);
        this.ivClear.setVisibility(0);
    }

    public static boolean isContainsNum(String str) {
        Pattern pattern = Pattern.compile("\\d");
        Matcher isNum = pattern.matcher(str);
        return isNum.find();
    }

    private void hideSearchResult() {
        this.llSearchResultLayout.setVisibility(8);
        this.flSearchBarLayout.setVisibility(0);
        this.ivClear.setVisibility(8);
    }

    public void setCurrentIndex(String content) {
        if (this.areaCodeSearchBarAdapter != null) {
            this.areaCodeSearchBarAdapter.setCurrentContent(content);
        }
        if (this.areaCodeSearchResultAdapter != null) {
            this.areaCodeSearchResultAdapter.setCurrentContent(content);
        }
        if (this.tvRecommendArea != null && this.tvRecommendArea.getText().toString().equals(content)) {
            this.tvRecommendArea.setTextColor(this.colorId);
            this.tvRecommend.setTextColor(this.colorId);
            this.tvRecommendCode.setTextColor(this.colorId);
        }
    }

    public void setOnSearchBarClickListener(AreaCodeSearchBarAdapter.OnSearchBarClickListener listener) {
        if (this.areaCodeSearchBarAdapter != null) {
            this.areaCodeSearchBarAdapter.setOnSearchBarClickListener(listener);
        }
    }

    public void setOnSearchResultClickListener(AreaCodeSearchResultAdapter.OnSearchResultClickListener listener) {
        if (this.areaCodeSearchResultAdapter != null) {
            this.listener = listener;
            this.areaCodeSearchResultAdapter.setOnSearchResultClickListener(listener);
        }
    }

    public void setLeftClick(OnLeftClickListener mOnClick) {
        this.mOnLeftClick = mOnClick;
    }

    public void setRecommendArea(Bundle bundle) {
        String area = bundle.getString("area");
        String code = bundle.getString("areaCode");
        if (area != null && this.tvRecommendArea != null) {
            this.tvRecommendArea.setText((CharSequence)area);
        }
        if (code != null && this.tvRecommendCode != null) {
            this.tvRecommendCode.setText((CharSequence)code);
        }
    }

    public void setRecommendAreaShow(boolean isShow) {
        this.rlRecommend.setVisibility(isShow ? 0 : 8);
    }

    public static interface OnLeftClickListener {
        public void onLeftclick();
    }
}

