/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.uilibrary.R;
import java.util.List;

public class SearchBarAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Bundle> dataList;
    private String currentContent;
    private int colorId = R.color.theme_color;
    private OnSearchBarClickListener listener;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xm_ui_adapter_search_bar, null));
    }

    @SuppressLint(value={"ResourceAsColor"})
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Bundle bundle = this.dataList.get(position);
        if (bundle != null) {
            String title = bundle.getString("title");
            String content = bundle.getString("content");
            if (TextUtils.isEmpty((CharSequence)title)) {
                holder.tvTitle.setText((CharSequence)"");
                holder.tvTitle.setVisibility(8);
            } else {
                holder.tvTitle.setText((CharSequence)title);
                holder.tvTitle.setVisibility(0);
            }
            if (content != null) {
                if (content.equals(this.currentContent)) {
                    holder.tvContent.setTextColor(this.colorId);
                    holder.ivCheck.setVisibility(0);
                } else {
                    holder.tvContent.setTextColor(R.color.black);
                    holder.ivCheck.setVisibility(8);
                }
                holder.tvContent.setText((CharSequence)content);
            }
        }
    }

    public int getItemCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public void setDataList(List<Bundle> dataList) {
        this.dataList = dataList;
        this.notifyDataSetChanged();
    }

    public void setCurrentContent(String content) {
        this.currentContent = content;
    }

    public void setOnSearchBarClickListener(OnSearchBarClickListener listener) {
        this.listener = listener;
    }

    public void setColorId(int colorId) {
        this.colorId = colorId;
    }

    public static interface OnSearchBarClickListener {
        public void onClick(String var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvTitle;
        TextView tvContent;
        ImageView ivCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_title);
            this.tvContent = (TextView)itemView.findViewById(R.id.tv_content);
            this.ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
            this.tvContent.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.getAdapterPosition() < SearchBarAdapter.this.dataList.size()) {
                        Bundle bundle = (Bundle)SearchBarAdapter.this.dataList.get(ViewHolder.this.getAdapterPosition());
                        if (SearchBarAdapter.this.listener != null) {
                            SearchBarAdapter.this.listener.onClick(bundle.getString("content"));
                        }
                    }
                }
            });
        }
    }
}

