/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.adapter;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.searchbar.bean.AreaBean;
import com.xm.uilibrary.R;
import java.util.List;

public class AreaCodeSearchResultAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<AreaBean> resultList;
    private String startColorStr;
    private String endColorStr;
    private boolean isAreaCode = false;
    private int selectColorId;
    private String currentContent;
    private OnSearchResultClickListener listener;

    public AreaCodeSearchResultAdapter(boolean isAreaCodeSearch, int colorId) {
        this.isAreaCode = isAreaCodeSearch;
        this.selectColorId = colorId;
    }

    public AreaCodeSearchResultAdapter() {
    }

    public void setCurrentContent(String content) {
        this.currentContent = content;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xm_ui_area_code_adapter_search_result, null));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.tvResult.setText((CharSequence)Html.fromHtml((String)this.resultList.get(position).getAreaContent()));
        if (this.isAreaCode) {
            holder.tvAreaCode.setVisibility(0);
            holder.ivCheck.setVisibility(8);
            holder.tvAreaCode.setText((CharSequence)Html.fromHtml((String)this.resultList.get(position).getAreaCode()));
            if (holder.tvResult.getText().toString().equals(this.currentContent)) {
                holder.tvResult.setTextColor(this.selectColorId);
                holder.tvAreaCode.setTextColor(this.selectColorId);
            } else {
                holder.tvResult.setTextColor(-16777216);
                holder.tvResult.setTextColor(-16777216);
            }
        } else {
            holder.tvAreaCode.setVisibility(8);
            if (holder.tvResult.getText().toString().equals(this.currentContent)) {
                holder.ivCheck.setVisibility(0);
            } else {
                holder.ivCheck.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.resultList == null ? 0 : this.resultList.size();
    }

    public void setData(List<AreaBean> dataList, String startColorStr, String endColorStr) {
        this.resultList = dataList;
        this.startColorStr = startColorStr;
        this.endColorStr = endColorStr;
        this.notifyDataSetChanged();
    }

    public void setOnSearchResultClickListener(OnSearchResultClickListener listener) {
        this.listener = listener;
    }

    public static interface OnSearchResultClickListener {
        public void onResultClick(AreaBean var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvResult;
        TextView tvAreaCode;
        ImageView ivCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvResult = (TextView)itemView.findViewById(R.id.tv_result);
            this.ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
            this.tvAreaCode = (TextView)itemView.findViewById(R.id.tv_area_code);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String content;
                    if (ViewHolder.this.getAdapterPosition() < AreaCodeSearchResultAdapter.this.resultList.size() && AreaCodeSearchResultAdapter.this.listener != null && (content = ((AreaBean)AreaCodeSearchResultAdapter.this.resultList.get(ViewHolder.this.getAdapterPosition())).getAreaContent()) != null) {
                        content = content.replace(AreaCodeSearchResultAdapter.this.startColorStr, "");
                        content = content.replace(AreaCodeSearchResultAdapter.this.endColorStr, "");
                        AreaCodeSearchResultAdapter.this.listener.onResultClick((AreaBean)AreaCodeSearchResultAdapter.this.resultList.get(ViewHolder.this.getAdapterPosition()));
                    }
                }
            });
        }
    }
}

