/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rotateloadingview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.xm.uilibrary.R;

public class LoadingView
extends View {
    public static final int SHAPE_TYPE_SQUARE = 0;
    public static final int SHAPE_TYPE_ROUND = 1;
    private Paint mPaint;
    private Path path;
    private Shape mShape = Shape.SHAPE_ONE;
    private int mTextAppearance;
    private DisplayMetrics dm;
    private int mShapeType = 0;
    private boolean mIsAuto;
    private String mLoadText;
    private int mOneColor;
    private int mTwoColor;
    private int mThreeColor;
    private int mFourColor;

    public LoadingView(Context context) {
        this(context, null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
            this.mLoadText = typedArray.getString(R.styleable.LoadingView_loadingText);
            this.mTextAppearance = typedArray.getResourceId(R.styleable.LoadingView_loadingTextAppearance, -1);
            this.mShapeType = typedArray.getInteger(R.styleable.LoadingView_loadingType, 0);
            this.mIsAuto = typedArray.getBoolean(R.styleable.LoadingView_loadingAuto, false);
            typedArray.recycle();
        }
        this.init();
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(R.color.one));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mOneColor = this.getResources().getColor(R.color.one);
        this.mTwoColor = this.getResources().getColor(R.color.two);
        this.mThreeColor = this.getResources().getColor(R.color.three);
        this.mFourColor = this.getResources().getColor(R.color.four);
        this.path = new Path();
        this.dm = new DisplayMetrics();
    }

    private float relativeXFromView(float percent) {
        return (float)this.getWidth() * percent;
    }

    private float relativeYFromView(float percent) {
        return (float)this.getHeight() * percent;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.mShapeType) {
            case 0: {
                this.dealWithSquare(canvas);
                break;
            }
            case 1: {
                this.dealWithRound(canvas);
                break;
            }
            default: {
                this.dealWithSquare(canvas);
            }
        }
        if (this.mIsAuto) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    LoadingView.this.postInvalidate();
                }
            }, 300L);
        }
    }

    private void dealWithSquare(Canvas canvas) {
        switch (this.mShape) {
            case SHAPE_ONE: {
                this.mShape = Shape.SHAPE_TWO;
                this.mPaint.setColor(this.mOneColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                break;
            }
            case SHAPE_TWO: {
                this.mShape = Shape.SHAPE_THREE;
                this.mPaint.setColor(this.mOneColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.mPaint);
                break;
            }
            case SHAPE_THREE: {
                this.mShape = Shape.SHAPE_FOUR;
                this.mPaint.setColor(this.mOneColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.mPaint);
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.mPaint);
                break;
            }
            case SHAPE_FOUR: {
                this.mShape = Shape.SHAPE_FIVE;
                this.mPaint.setColor(this.mOneColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeXFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.mPaint);
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f), this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f + this.relativeXFromView(0.01f) + this.relativeXFromView(0.1f), this.mPaint);
                this.mPaint.setColor(this.mFourColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                break;
            }
            case SHAPE_FIVE: {
                this.mShape = Shape.SHAPE_ONE;
                this.mPaint.setColor(this.mFourColor);
                canvas.drawRect(this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f) - this.relativeXFromView(0.1f), this.relativeXFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.relativeYFromView(1.0f) / 2.0f - this.relativeXFromView(0.01f), this.mPaint);
                break;
            }
        }
    }

    private void dealWithRound(Canvas canvas) {
        switch (this.mShape) {
            case SHAPE_ONE: {
                this.mShape = Shape.SHAPE_TWO;
                this.mPaint.setColor(this.mFourColor);
                canvas.drawCircle(this.relativeXFromView(0.17f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mOneColor);
                canvas.drawCircle(this.relativeXFromView(0.39f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawCircle(this.relativeXFromView(0.61f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawCircle(this.relativeXFromView(0.83f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                break;
            }
            case SHAPE_TWO: {
                this.mShape = Shape.SHAPE_THREE;
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawCircle(this.relativeXFromView(0.17f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mFourColor);
                canvas.drawCircle(this.relativeXFromView(0.39f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mOneColor);
                canvas.drawCircle(this.relativeXFromView(0.61f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawCircle(this.relativeXFromView(0.83f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                break;
            }
            case SHAPE_THREE: {
                this.mShape = Shape.SHAPE_FOUR;
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawCircle(this.relativeXFromView(0.17f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawCircle(this.relativeXFromView(0.39f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mFourColor);
                canvas.drawCircle(this.relativeXFromView(0.61f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mOneColor);
                canvas.drawCircle(this.relativeXFromView(0.83f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                break;
            }
            case SHAPE_FOUR: {
                this.mShape = Shape.SHAPE_ONE;
                this.mPaint.setColor(this.mOneColor);
                canvas.drawCircle(this.relativeXFromView(0.17f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mTwoColor);
                canvas.drawCircle(this.relativeXFromView(0.39f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mThreeColor);
                canvas.drawCircle(this.relativeXFromView(0.61f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                this.mPaint.setColor(this.mFourColor);
                canvas.drawCircle(this.relativeXFromView(0.83f), this.relativeYFromView(0.5f), this.relativeXFromView(0.11f) / 2.0f, this.mPaint);
                break;
            }
        }
    }

    public void changeShape() {
        this.invalidate();
    }

    public Shape getShape() {
        return this.mShape;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAuto = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public static enum ShapeType {
        SQUARE,
        ROUND;

    }

    public static enum Shape {
        SHAPE_ONE,
        SHAPE_TWO,
        SHAPE_THREE,
        SHAPE_FOUR,
        SHAPE_FIVE;

    }
}

