/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rollerradiogroup;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.xm.uilibrary.R;
import java.util.ArrayList;
import java.util.List;

public class RollerRadioGroup
extends View {
    private static final int NORMAL_COLOR = -16777216;
    private static final int SELECTED_COLOR = -16777216;
    private final float NORMAL_SIZE = this.sp2px(14.0f);
    private final float DEFAULT_PADDING = this.dp2pxf(10.0f);
    private final float DEFAULT_LINE_STROKE_WIDTH = this.dp2px(1.0f);
    private int normalColor;
    private int selectedColor;
    private float normalSize;
    private float selectedSize;
    private float textPadding;
    private int shaderColor;
    private boolean showEdgeLine;
    private boolean autoSelected;
    private boolean backgroundUuseSelectedColor;
    private List<String> texts = new ArrayList<String>();
    private int selectedId = -1;
    private List<Rect> textsRects = new ArrayList<Rect>();
    private List<Float> textsCenterX = new ArrayList<Float>();
    private float contentWidth;
    private OnRollerListener listener;
    private Scroller scroller;
    private VelocityTracker velocityTracker;
    private ViewConfiguration viewConfiguration;
    private Paint norPaint;
    private Paint selPaint;
    private Paint shaderPaint;
    private Paint.FontMetrics norFont;
    private Paint.FontMetrics selFont;
    private boolean isTouching;
    private float lastX = 0.0f;
    private float x = 0.0f;
    private float beginScrollX = 0.0f;
    private boolean isClickEvent = true;

    public RollerRadioGroup(Context context) {
        this(context, null);
    }

    public RollerRadioGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RollerRadioGroup(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.scroller = new Scroller(context);
        this.viewConfiguration = ViewConfiguration.get((Context)context);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RollerRadioGroup);
        this.normalColor = ta.getColor(R.styleable.RollerRadioGroup_normal_color, -16777216);
        this.selectedColor = ta.getColor(R.styleable.RollerRadioGroup_selected_color, -16777216);
        this.normalSize = ta.getDimension(R.styleable.RollerRadioGroup_normal_size, this.NORMAL_SIZE);
        this.selectedSize = ta.getDimension(R.styleable.RollerRadioGroup_selected_size, 1.3f * this.normalSize);
        this.textPadding = ta.getDimension(R.styleable.RollerRadioGroup_text_padding, this.DEFAULT_PADDING);
        this.shaderColor = ta.getColor(R.styleable.RollerRadioGroup_shader_color, this.getBackgroundColor());
        this.showEdgeLine = ta.getBoolean(R.styleable.RollerRadioGroup_show_edge_line, true);
        this.autoSelected = ta.getBoolean(R.styleable.RollerRadioGroup_auto_selected, true);
        this.backgroundUuseSelectedColor = ta.getBoolean(R.styleable.RollerRadioGroup_background_use_selected_color, false);
        ta.recycle();
        this.initPaint();
    }

    private void initPaint() {
        this.norPaint = new Paint(1);
        this.norPaint.setColor(this.normalColor);
        this.norPaint.setTextSize(this.normalSize);
        this.norPaint.setTextAlign(Paint.Align.CENTER);
        this.norFont = this.norPaint.getFontMetrics();
        this.selPaint = new Paint(1);
        this.selPaint.setColor(this.selectedColor);
        this.selPaint.setTextSize(this.selectedSize);
        this.selPaint.setTextAlign(Paint.Align.CENTER);
        this.selPaint.setStrokeWidth(this.DEFAULT_LINE_STROKE_WIDTH);
        this.selFont = this.selPaint.getFontMetrics();
        this.shaderPaint = new Paint(1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int ws = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int wm = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int hs = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int hm = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (wm != 0x40000000) {
            ws = this.dp2px(150.0f);
        }
        if (hm != 0x40000000) {
            hs = (int)(Math.max(this.selectedSize, this.normalSize) + 2.0f * this.textPadding);
        }
        this.setMeasuredDimension(ws, hs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTexts(canvas);
        if (this.showEdgeLine) {
            this.drawEdgeLine(canvas);
        }
        this.drawShader(canvas);
    }

    private void drawEdgeLine(Canvas canvas) {
        canvas.save();
        canvas.drawLine((float)(-this.getMeasuredWidth()), 0.0f + this.selPaint.getStrokeWidth() / 2.0f, this.contentWidth + (float)this.getMeasuredWidth(), 0.0f + this.selPaint.getStrokeWidth() / 2.0f, this.selPaint);
        canvas.drawLine((float)(-this.getMeasuredWidth()), (float)this.getMeasuredHeight() - this.selPaint.getStrokeWidth() / 2.0f, this.contentWidth + (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight() - this.selPaint.getStrokeWidth() / 2.0f, this.selPaint);
        canvas.restore();
    }

    private void drawTexts(Canvas canvas) {
        canvas.save();
        Paint.FontMetrics f = this.selectedSize > this.normalSize ? this.selFont : this.norFont;
        float textCenterY = (float)this.getMeasuredHeight() / 2.0f - (f.ascent + f.descent) / 2.0f;
        if (!this.backgroundUuseSelectedColor) {
            for (int i = 0; i < this.texts.size(); ++i) {
                canvas.drawText(this.texts.get(i), this.textsCenterX.get(i).floatValue(), textCenterY, i == this.selectedId ? this.selPaint : this.norPaint);
            }
        } else {
            for (int i = 0; i < this.texts.size(); ++i) {
                if (i != this.selectedId) {
                    canvas.drawText(this.texts.get(i), this.textsCenterX.get(i).floatValue(), textCenterY, this.norPaint);
                    continue;
                }
                float cx = this.textsCenterX.get(i).floatValue();
                float l = cx - (float)this.textsRects.get(i).width() / 2.0f - this.textPadding / 2.0f;
                float t = Math.max(0.0f, (float)this.getMeasuredHeight() / 2.0f - (float)this.textsRects.get(i).height() / 2.0f - this.textPadding / 2.0f);
                float r = cx + (float)this.textsRects.get(i).width() / 2.0f + this.textPadding / 2.0f;
                float b = Math.min((float)this.getMeasuredHeight(), (float)this.getMeasuredHeight() / 2.0f + (float)this.textsRects.get(i).height() / 2.0f + this.textPadding / 2.0f);
                RectF rectf = new RectF(l, t, r, b);
                canvas.drawRoundRect(rectf, this.dp2pxf(3.0f), this.dp2pxf(3.0f), this.selPaint);
                this.selPaint.setColor(-1);
                canvas.drawText(this.texts.get(i), this.textsCenterX.get(i).floatValue(), textCenterY, this.selPaint);
                this.selPaint.setColor(this.selectedColor);
            }
        }
        canvas.restore();
    }

    private void drawShader(Canvas canvas) {
        canvas.save();
        float rectWidth = (float)this.getMeasuredWidth() * 0.2f;
        int startColor = this.shaderColor & 0xFFFFFF;
        int stopColor = this.shaderColor;
        if ((stopColor & 0xFF000000) == 0) {
            stopColor = this.shaderColor | 0xFF000000;
        }
        LinearGradient leftShader = new LinearGradient((float)this.getScrollX(), 0.0f, (float)this.getScrollX() + rectWidth, 0.0f, stopColor, startColor, Shader.TileMode.CLAMP);
        this.shaderPaint.setShader((Shader)leftShader);
        canvas.drawRect((float)this.getScrollX(), (float)this.getScrollY(), (float)this.getScrollX() + rectWidth, (float)(this.getScrollY() + this.getMeasuredHeight()), this.shaderPaint);
        LinearGradient rightShader = new LinearGradient((float)(this.getScrollX() + this.getMeasuredWidth()) - rectWidth, 0.0f, (float)(this.getScrollX() + this.getMeasuredWidth()), 0.0f, startColor, stopColor, Shader.TileMode.CLAMP);
        this.shaderPaint.setShader((Shader)rightShader);
        canvas.drawRect((float)(this.getScrollX() + this.getMeasuredWidth()) - rectWidth, (float)this.getScrollY(), (float)(this.getScrollX() + this.getMeasuredWidth()), (float)(this.getScrollY() + this.getMeasuredHeight()), this.shaderPaint);
        canvas.restore();
    }

    private int getBackgroundColor() {
        Drawable drawable2 = this.getBackground();
        if (drawable2 instanceof ColorDrawable) {
            return ((ColorDrawable)drawable2).getColor();
        }
        return -1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.isTouching = true;
                if (!this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                }
                this.beginScrollX = this.getScrollX();
                this.lastX = event.getX();
                this.isClickEvent = true;
                return true;
            }
            case 2: {
                this.x = event.getX();
                int deltaX = (int)(this.lastX - this.x);
                if (Math.abs(deltaX) < this.viewConfiguration.getScaledTouchSlop()) {
                    this.isClickEvent = true;
                    break;
                }
                this.isClickEvent = false;
                if (this.contentWidth <= (float)this.getMeasuredWidth()) {
                    return true;
                }
                this.scrollTo((int)(this.beginScrollX + (float)deltaX), 0);
                this.dealOutOfBounds(true);
                break;
            }
            case 1: {
                this.x = event.getX();
                if (this.isClickEvent) {
                    this.setSelectedId(this.calculateNewSelectedId(this.beginScrollX + this.x));
                } else {
                    if (this.contentWidth <= (float)this.getMeasuredWidth()) {
                        return true;
                    }
                    this.velocityTracker.computeCurrentVelocity(1000);
                    int xVelocity = (int)this.velocityTracker.getXVelocity();
                    if (Math.abs(xVelocity) > this.viewConfiguration.getScaledMinimumFlingVelocity()) {
                        this.scroller.fling(this.getScrollX(), this.getScrollY(), -xVelocity, 0, -this.getMeasuredWidth() / 2, (int)(this.contentWidth - (float)this.getMeasuredWidth() / 2.0f), 0, 0);
                        this.invalidate();
                    } else if (this.autoSelected) {
                        this.setSelectedId(this.calculateNewSelectedId());
                    } else {
                        this.dealOutOfBounds(false);
                    }
                }
                this.isTouching = false;
            }
        }
        return super.onTouchEvent(event);
    }

    private void dealOutOfBounds(boolean immediately) {
        if ((float)this.getScrollX() < (float)(-this.getMeasuredWidth()) / 2.0f) {
            float deltaX = (float)(-this.getMeasuredWidth()) / 2.0f - (float)this.getScrollX();
            if (immediately) {
                this.scrollTo((int)((float)(-this.getMeasuredWidth()) / 2.0f), this.getScrollY());
            } else {
                this.scroller.startScroll(this.getScrollX(), this.getScrollY(), (int)deltaX, 0);
            }
            this.invalidate();
        } else if ((float)this.getScrollX() > this.contentWidth - (float)this.getMeasuredWidth() / 2.0f) {
            float deltaX = this.contentWidth - (float)this.getMeasuredWidth() / 2.0f - (float)this.getScrollX();
            if (immediately) {
                this.scrollTo((int)(this.contentWidth - (float)this.getMeasuredWidth() / 2.0f), this.getScrollY());
            } else {
                this.scroller.startScroll(this.getScrollX(), this.getScrollY(), (int)deltaX, 0);
            }
            this.invalidate();
        }
    }

    private int calculateNewSelectedId() {
        float viewCenterX = (float)this.getScrollX() + (float)this.getMeasuredWidth() / 2.0f;
        return this.calculateNewSelectedId(viewCenterX);
    }

    private int calculateNewSelectedId(float viewCenterX) {
        int findSelectedId = 0;
        float lastDeltaX = 0.0f;
        for (int i = 0; i < this.textsCenterX.size(); ++i) {
            if (i == 0) {
                lastDeltaX = Math.abs(this.textsCenterX.get(i).floatValue() - viewCenterX);
                findSelectedId = i;
                continue;
            }
            if (Math.abs(this.textsCenterX.get(i).floatValue() - viewCenterX) < lastDeltaX) {
                findSelectedId = i;
            }
            lastDeltaX = Math.abs(this.textsCenterX.get(i).floatValue() - viewCenterX);
        }
        return findSelectedId;
    }

    private void tryScrollToSelectedItem() {
        float deltaX = this.textsCenterX.get(this.selectedId).floatValue() - ((float)this.getScrollX() + (float)this.getMeasuredWidth() / 2.0f);
        if (deltaX >= -1.0f && deltaX <= 1.0f) {
            return;
        }
        this.scroller.startScroll(this.getScrollX(), this.getScrollY(), (int)deltaX, 0);
        this.invalidate();
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
            this.invalidate();
        } else if (!this.isTouching && this.autoSelected) {
            this.setSelectedId(this.calculateNewSelectedId());
        }
    }

    private void initData() {
        this.textsRects.clear();
        Paint p = this.selectedSize > this.normalSize ? this.selPaint : this.norPaint;
        for (int i = 0; i < this.texts.size(); ++i) {
            Rect rect = new Rect();
            p.getTextBounds(this.texts.get(i), 0, this.texts.get(i).length(), rect);
            this.textsRects.add(rect);
        }
        this.textsCenterX.clear();
        float sumX = 0.0f;
        for (int i = 0; i < this.texts.size(); ++i) {
            this.textsCenterX.add(Float.valueOf((sumX += this.textPadding + (float)this.textsRects.get(i).width()) - (float)this.textsRects.get(i).width() / 2.0f));
        }
        this.contentWidth = sumX + this.textPadding;
    }

    public void setData(List<String> texts, final int selectedId) {
        this.texts = texts;
        this.initData();
        this.requestLayout();
        this.post(new Runnable(){

            @Override
            public void run() {
                RollerRadioGroup.this.setSelectedId(selectedId);
            }
        });
    }

    public void setData(List<String> texts) {
        this.texts = texts;
        this.initData();
        this.requestLayout();
    }

    public List<String> getData() {
        return this.texts;
    }

    public boolean setSelectedId(int selectedId) {
        return this.setSelectedId(selectedId, false);
    }

    public boolean setSelectedId(String itemName) {
        return this.setSelectedId(itemName, false);
    }

    public boolean setSelectedId(int selectedId, boolean noListener) {
        if (this.texts != null && selectedId >= 0 && selectedId < this.texts.size()) {
            if (!noListener && this.listener != null) {
                this.listener.onItemSelected(this, selectedId, this.selectedId);
            }
            this.selectedId = selectedId;
            this.tryScrollToSelectedItem();
            return true;
        }
        return false;
    }

    public boolean setSelectedId(String itemName, boolean noListener) {
        int id2;
        if (itemName != null && (id2 = this.texts.indexOf(itemName)) != -1) {
            if (!noListener && this.listener != null) {
                this.listener.onItemSelected(this, id2, this.selectedId);
            }
            this.selectedId = id2;
            this.tryScrollToSelectedItem();
            return true;
        }
        return false;
    }

    public int getSelectedId() {
        return this.selectedId;
    }

    public void setOnRollerListener(OnRollerListener listener) {
        this.listener = listener;
    }

    public int getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(int normalColor) {
        this.normalColor = normalColor;
        this.initPaint();
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.selectedColor = selectedColor;
        this.initPaint();
        this.invalidate();
    }

    public float getNormalSize() {
        return this.normalSize;
    }

    public void setNormalSize(float normalSize) {
        this.normalSize = normalSize;
        this.initPaint();
        this.initData();
        this.requestLayout();
    }

    public float getSelectedSize() {
        return this.selectedSize;
    }

    public void setSelectedSize(float selectedSize) {
        this.selectedSize = selectedSize;
        this.initPaint();
        this.initData();
        this.requestLayout();
    }

    public float getTextPadding() {
        return this.textPadding;
    }

    public void setTextPadding(float textPadding) {
        this.textPadding = textPadding;
        this.initData();
        this.requestLayout();
    }

    public int getShaderColor() {
        return this.shaderColor;
    }

    public void setShaderColor(int shaderColor) {
        this.shaderColor = shaderColor;
        this.invalidate();
    }

    public boolean isShowEdgeLine() {
        return this.showEdgeLine;
    }

    public void setShowEdgeLine(boolean showEdgeLine) {
        this.showEdgeLine = showEdgeLine;
        this.invalidate();
    }

    public boolean isAutoSelected() {
        return this.autoSelected;
    }

    public void setAutoSelected(boolean autoSelected) {
        this.autoSelected = autoSelected;
        this.invalidate();
    }

    private float dp2pxf(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int dp2px(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public static interface OnRollerListener {
        public void onItemSelected(RollerRadioGroup var1, int var2, int var3);
    }
}

