/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.listselectitem.extra.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.xm.ui.widget.listselectitem.extra.adapter.ExtraSpinnerAdapter;
import com.xm.ui.widget.listselectitem.extra.data.ItemData;
import com.xm.uilibrary.R;
import java.util.ArrayList;

public class ExtraSpinner<T>
extends RelativeLayout {
    private RecyclerView recyclerView;
    private ExtraSpinnerAdapter<T> adapter;
    private ExtraSpinnerAdapter.OnExtraSpinnerItemListener listener;

    public ExtraSpinner(Context context) {
        this(context, null);
    }

    public ExtraSpinner(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExtraSpinner(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_view_extraspinner, (ViewGroup)this, true);
        this.recyclerView = (RecyclerView)layout2.findViewById(R.id.rv_extraspinner);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
    }

    public void initData(@NonNull String[] keys, @NonNull T[] values) {
        this.initData(keys, values, 0);
    }

    public void initData(@NonNull String[] keys, @NonNull T[] values, int adapterLayoutId) {
        if (keys.length != values.length) {
            throw new RuntimeException("initData error: the length of keys is not same as the length of values");
        }
        ArrayList datas = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            datas.add(new ItemData<T>(keys[i], values[i]));
        }
        if (this.adapter == null) {
            this.adapter = new ExtraSpinnerAdapter();
            this.adapter.setAdapterLayoutId(adapterLayoutId);
            this.adapter.setOnExtraSpinnerItemListener(new ExtraSpinnerAdapter.OnExtraSpinnerItemListener(){

                public void onItemClick(int position, String key, Object value) {
                    if (ExtraSpinner.this.listener != null) {
                        ExtraSpinner.this.listener.onItemClick(position, key, value);
                    }
                }
            });
            this.recyclerView.setAdapter(this.adapter);
        }
        this.adapter.setData(datas);
    }

    public void setValue(T value) {
        if (this.adapter != null) {
            this.adapter.setSelectedPos(value);
            this.adapter.notifyDataSetChanged();
        }
    }

    public void setOnExtraSpinnerItemListener(ExtraSpinnerAdapter.OnExtraSpinnerItemListener listener) {
        this.listener = listener;
    }

    public T getSelectedValue() {
        if (this.adapter != null) {
            return this.adapter.getSelectedValue();
        }
        return null;
    }

    public String getSelectedName() {
        if (this.adapter != null) {
            return this.adapter.getSelectedName();
        }
        return "";
    }

    public void setIsDarkMode(boolean isDarkMode) {
        if (this.adapter != null) {
            this.adapter.setIsDarkMode(isDarkMode);
        }
    }
}

