/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.ui.widget.ButtonCheck;
import com.xm.ui.widget.dialog.BaseDlg;
import com.xm.uilibrary.R;
import java.util.Timer;
import java.util.TimerTask;

public class MyAlertDialog
extends BaseDlg
implements ButtonCheck.OnButtonClickListener,
DialogInterface.OnShowListener {
    private Context context;
    private TextView tv_dialog_tip;
    private RelativeLayout rl_dialog_positive;
    private RelativeLayout rl_dialog_negative;
    private RelativeLayout rl_dialog_center;
    private TextView tv_dialog_positive;
    private TextView tv_dialog_negative;
    private TextView tv_cancel_countdown;
    private TextView tv_center;
    private View iv_dialog_divider;
    private ButtonCheck mCbNotAgain;
    private Timer mCountDown;
    private long mCountdownTimes;

    public MyAlertDialog(Context context) {
        this.context = context;
        this.mDlg = new Dialog(context, R.style.custom_dialog);
        this.mDlg.setOnShowListener((DialogInterface.OnShowListener)this);
        this.mDlg.show();
        Window window = this.mDlg.getWindow();
        window.setContentView(R.layout.xm_ui_alert_dialog);
        this.initView(window);
    }

    private void initView(Window window) {
        this.tv_dialog_tip = (TextView)window.findViewById(R.id.tv_dialog_tip);
        this.rl_dialog_positive = (RelativeLayout)window.findViewById(R.id.rl_dialog_positive);
        this.rl_dialog_negative = (RelativeLayout)window.findViewById(R.id.rl_dialog_negative);
        this.tv_dialog_positive = (TextView)window.findViewById(R.id.tv_dialog_positive);
        this.tv_dialog_negative = (TextView)window.findViewById(R.id.tv_dialog_negative);
        this.iv_dialog_divider = window.findViewById(R.id.iv_dialog_divider);
        this.tv_cancel_countdown = (TextView)window.findViewById(R.id.tv_cancel_countdown);
        this.mCbNotAgain = (ButtonCheck)window.findViewById(R.id.cbNotAgain);
        this.rl_dialog_center = (RelativeLayout)window.findViewById(R.id.rl_dialog_center);
        this.tv_center = (TextView)window.findViewById(R.id.tv_dialog_center);
        this.iv_dialog_divider.setVisibility(8);
        this.rl_dialog_positive.setVisibility(8);
        this.rl_dialog_negative.setVisibility(8);
        this.mCbNotAgain.setOnButtonClick(this);
    }

    public MyAlertDialog setTitle(String title) {
        this.tv_dialog_tip.setText((CharSequence)title);
        return this;
    }

    public MyAlertDialog setTitle(Spanned content) {
        this.tv_dialog_tip.setText((CharSequence)content);
        this.tv_dialog_tip.setMovementMethod(LinkMovementMethod.getInstance());
        return this;
    }

    public String getTitle() {
        return this.tv_dialog_tip.getText().toString();
    }

    public void setTitleGravity(int gravity) {
        this.tv_dialog_tip.setGravity(gravity);
    }

    public MyAlertDialog setCancelable(boolean cancelable) {
        this.mDlg.setCancelable(cancelable);
        return this;
    }

    public MyAlertDialog setPositiveButton(String text, View.OnClickListener listener) {
        this.rl_dialog_positive.setVisibility(0);
        if (this.rl_dialog_positive.getVisibility() == 0 && this.rl_dialog_negative.getVisibility() == 0) {
            this.iv_dialog_divider.setVisibility(0);
        }
        this.tv_dialog_positive.setText((CharSequence)text);
        this.rl_dialog_positive.setOnClickListener(listener);
        return this;
    }

    public MyAlertDialog setCenterButton(String text, View.OnClickListener listener) {
        this.rl_dialog_center.setVisibility(0);
        this.tv_center.setText((CharSequence)text);
        this.rl_dialog_center.setOnClickListener(listener);
        return this;
    }

    public MyAlertDialog setOnDismissListener(final DialogInterface.OnDismissListener listener) {
        this.mDlg.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (listener != null) {
                    listener.onDismiss(dialog);
                }
                if (MyAlertDialog.this.mCountDown != null) {
                    MyAlertDialog.this.mCountDown.cancel();
                    MyAlertDialog.this.mCountDown = null;
                }
            }
        });
        return this;
    }

    public void HidePositiveButton() {
        this.rl_dialog_positive.setVisibility(8);
        this.iv_dialog_divider.setVisibility(8);
    }

    public MyAlertDialog setNegativeButton(String text, View.OnClickListener listener) {
        this.rl_dialog_negative.setVisibility(0);
        if (this.rl_dialog_positive.getVisibility() == 0 && this.rl_dialog_negative.getVisibility() == 0) {
            this.iv_dialog_divider.setVisibility(0);
        }
        this.tv_dialog_negative.setText((CharSequence)text);
        this.rl_dialog_negative.setOnClickListener(listener);
        return this;
    }

    public void dismiss() {
        this.mDlg.dismiss();
    }

    public boolean isShowing() {
        if (this.mDlg != null) {
            return this.mDlg.isShowing();
        }
        return false;
    }

    public void show() {
        if (!this.mDlg.isShowing()) {
            this.mDlg.show();
        }
    }

    public void onClick(View v) {
    }

    public void setButtonTextColor(int cancelColor, int okColor) {
        this.tv_dialog_negative.setTextColor(cancelColor);
        this.tv_dialog_positive.setTextColor(okColor);
    }

    public boolean isNotAgainChecked() {
        return this.mCbNotAgain.IsChecked();
    }

    public void setNotAgainVisibility(int visibility, String text) {
        this.mCbNotAgain.setVisibility(visibility);
        this.mCbNotAgain.setRightText(text);
        this.tv_dialog_tip.setPadding(UIUtils.dp2px(this.context, 20.0f), UIUtils.dp2px(this.context, 20.0f), UIUtils.dp2px(this.context, 20.0f), UIUtils.dp2px(this.context, 10.0f));
    }

    public void showCancelCountDown(long countdownTimes) {
        this.mCountdownTimes = countdownTimes;
        this.tv_cancel_countdown.setText((CharSequence)("(" + countdownTimes + "s)"));
        this.tv_cancel_countdown.setVisibility(0);
        if (this.mCountDown != null) {
            this.mCountDown.cancel();
            this.mCountDown = null;
        }
        this.mCountDown = new Timer();
        this.mCountDown.schedule(new TimerTask(){

            @Override
            public void run() {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        MyAlertDialog.this.tv_cancel_countdown.setText((CharSequence)("(" + --MyAlertDialog.this.mCountdownTimes + "s)"));
                        if (MyAlertDialog.this.mCountdownTimes == 0L && MyAlertDialog.this.rl_dialog_negative != null) {
                            MyAlertDialog.this.rl_dialog_negative.performClick();
                        }
                    }
                });
            }
        }, 1000L, 1000L);
    }

    @Override
    public boolean onButtonClick(ButtonCheck bc, boolean bChecked) {
        return bc.getId() == R.id.cbNotAgain;
    }

    public void onShow(DialogInterface dialog) {
        if (this.rl_dialog_negative != null && this.rl_dialog_positive != null) {
            if (this.rl_dialog_negative.getVisibility() == 8 && this.rl_dialog_positive.getVisibility() == 0) {
                this.rl_dialog_positive.setBackgroundResource(R.drawable.btn_dlg_error_center_corner);
            } else {
                this.rl_dialog_positive.setBackgroundResource(R.drawable.btn_dlg_error_right);
            }
        }
    }
}

