/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.dialog.ILoadingDlg;
import com.xm.uilibrary.R;

@SuppressLint(value={"NewApi"})
public class LoadingDialog
implements ILoadingDlg {
    private Dialog mDialog;
    private View contentView;
    private FrameLayout mLoadingLayout;
    private TextView promptTv;
    private DisplayMetrics dm;
    private IAnimController iAnimController;
    private static LoadingDialog mInstance = null;

    public static LoadingDialog getInstance(Context context) {
        return LoadingDialog.getInstance(context, 0.4f);
    }

    public static LoadingDialog getInstance(Context context, float widthScale) {
        if (widthScale <= 0.0f) {
            widthScale = 0.4f;
        }
        try {
            if (mInstance == null) {
                mInstance = new LoadingDialog(context, widthScale);
            } else if (!((ContextWrapper)mInstance.getDialog().getContext()).getBaseContext().equals(context)) {
                mInstance.destroy();
                mInstance = new LoadingDialog(context, widthScale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mInstance = new LoadingDialog(context, widthScale);
        }
        return mInstance;
    }

    public static LoadingDialog getNewInstance(Context context) {
        try {
            LoadingDialog loadingDialog = new LoadingDialog(context, 0.4f);
            return loadingDialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private LoadingDialog(Context context, float widthScale) {
        this.init(context, widthScale);
    }

    private void init(Context context, float widthScale) {
        if (context == null) {
            return;
        }
        this.mDialog = new Dialog(context, R.style.custom_dialog);
        this.contentView = LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_loading_dialog, null);
        this.mLoadingLayout = (FrameLayout)this.contentView.findViewById(R.id.loadingLayout);
        this.promptTv = (TextView)this.contentView.findViewById(R.id.promptTV);
        this.mLoadingLayout.setMinimumHeight(40);
        this.mDialog.setContentView(this.contentView);
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setCancelable(true);
        Window dialogWindow = this.mDialog.getWindow();
        WindowManager.LayoutParams p = dialogWindow.getAttributes();
        this.dm = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(this.dm);
        p.width = (int)((float)this.dm.widthPixels * widthScale);
        dialogWindow.setAttributes(p);
    }

    @Override
    public void show(String str) {
        try {
            if (this.iAnimController != null) {
                Object view = this.iAnimController.getLoadingView();
                if (view != null) {
                    if (this.mLoadingLayout.getChildCount() == 0) {
                        this.mLoadingLayout.addView(view);
                    } else {
                        View oldView = this.mLoadingLayout.getChildAt(0);
                        if (!view.equals(oldView)) {
                            this.mLoadingLayout.removeAllViews();
                            this.mLoadingLayout.addView(view);
                        }
                    }
                }
                this.iAnimController.startAnim();
            }
            if (null != str && str.length() > 0 && !str.trim().equals("") && null != this.promptTv) {
                this.promptTv.setText((CharSequence)str);
            } else {
                this.promptTv.setVisibility(8);
            }
            this.mDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void embedAnimation(IAnimController iAnimController) {
        if (iAnimController == null) {
            return;
        }
        if (this.iAnimController != null) {
            Object newView = iAnimController.getLoadingView();
            Object oldView = this.iAnimController.getLoadingView();
            if (newView != null && oldView != null && UIUtils.contrast(newView.getClass().getSimpleName(), oldView.getClass().getSimpleName())) {
                return;
            }
        }
        this.iAnimController = iAnimController;
    }

    @Override
    public void show() {
        if (this.mDialog == null) {
            return;
        }
        try {
            if (this.iAnimController != null) {
                Object view = this.iAnimController.getLoadingView();
                if (view != null && this.mLoadingLayout.getChildCount() == 0) {
                    this.mLoadingLayout.addView(view);
                }
                this.iAnimController.startAnim();
            }
            this.promptTv.setText(R.string.waiting);
            this.mDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dismiss() {
        if (this.mDialog == null) {
            return;
        }
        try {
            if (this.iAnimController != null) {
                this.iAnimController.stopAnim();
            }
            this.mDialog.dismiss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Dialog getDialog() {
        return this.mDialog;
    }

    @Override
    public void setCanceledOnTouchOutside(boolean cancel) {
        if (this.mDialog == null) {
            return;
        }
        this.mDialog.setCanceledOnTouchOutside(cancel);
    }

    @Override
    public void setCancelable(boolean flag) {
        if (this.mDialog == null) {
            return;
        }
        this.mDialog.setCancelable(flag);
    }

    @Override
    public void destroy() {
        try {
            if (this.mDialog != null) {
                if (this.mDialog.isShowing()) {
                    if (this.iAnimController != null) {
                        this.iAnimController.stopAnim();
                    }
                    this.mDialog.dismiss();
                }
                this.mDialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mInstance = null;
    }

    public static boolean isSameDialog(Context context) {
        if (mInstance != null) {
            return ((ContextWrapper)mInstance.getDialog().getContext()).getBaseContext().equals(context);
        }
        return false;
    }

    public void setPromptTextColor(int colorId) {
        this.promptTv.setTextColor(colorId);
    }

    public boolean isShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }
}

