/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xm.UIUtils;
import com.xm.uilibrary.R;

public class XTitleBar<T>
extends RelativeLayout {
    private static final float TITLE_TEXT_DEFAULT_SIZE = 17.0f;
    private static final float LEFT_TEXT_DEFAULT_SIZE = 14.0f;
    private static final float RIGHT_TEXT_DEFAULT_SIZE = 14.0f;
    private static final float BOTTOM_TEXT_DEFAULT_SIZE = 10.0f;
    private RelativeLayout mItemLayout;
    private RelativeLayout mTitleContent;
    private ImageView mLeftIv;
    private TextView mLeftTv;
    private TextView mTitle;
    private TextView mBottomTip;
    private ImageView mRightIv;
    private TextView mRightTv;
    private ImageView mSecondRightIv;
    private View mBottomLineView;
    private OnLeftClickListener mOnLeftClick;
    private OnRightClickListener mOnRightClick;
    private OnSecondRightClickListener mOnSecondRightClick;
    private String _titleText;
    private int _titleColor = 0;
    private float _titleSize = 0.0f;
    private int[] _leftImageID = new int[2];
    private String _leftText;
    private int _leftTextColor = 0;
    private float _leftTextSize = 0.0f;
    private int[] _rightImageID = new int[2];
    private int[] _secondRightImageID = new int[2];
    private String _rightText;
    private int _rightTextColor = 0;
    private float _rightTextSize = 0.0f;
    private int _btnValue = 0;
    private int _secondRightBtnValue = 0;
    private int rightExViewId;
    private float rightImageWidth;
    private float rightImageHeight;
    private int itemMinHeight = 0;
    private String bottomTipText;
    private boolean isShowBottomLine;
    private boolean isShowBottomTip;
    private FrameLayout rightExtraViewLayout;
    private T rightExView;
    private float bottomTipTextSize;
    private int bottomTipTextColor;
    private int leftImgPadding;
    private int rightImgPadding;
    private boolean isShowUnderLineTextFlag;

    public XTitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.xm_ui_item_title_bar, (ViewGroup)this, true);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.XTitleBar);
        this._titleText = array.getString(R.styleable.XTitleBar_TitleText);
        this._titleColor = array.getColor(R.styleable.XTitleBar_TitleTextColor, 0);
        this._titleSize = array.getDimension(R.styleable.XTitleBar_TitleTextSize, (float)UIUtils.sp2px(this.getContext(), 17.0f));
        this.rightImageWidth = array.getDimension(R.styleable.XTitleBar_XTitleImageRightWidth, 0.0f);
        this.rightImageHeight = array.getDimension(R.styleable.XTitleBar_XTitleImageRightHeight, 0.0f);
        this._btnValue = array.getInteger(R.styleable.XTitleBar_ImageValue, 0);
        this._secondRightBtnValue = array.getInteger(R.styleable.XTitleBar_ImageValue, 0);
        this._leftImageID[0] = array.getResourceId(R.styleable.XTitleBar_LeftBtn_Nor, 0);
        this._leftImageID[1] = array.getResourceId(R.styleable.XTitleBar_LeftBtn_Sel, 0);
        this._leftText = array.getString(R.styleable.XTitleBar_LeftText);
        this._leftTextColor = array.getColor(R.styleable.XTitleBar_LeftTextColor, 0);
        this._leftTextSize = array.getDimension(R.styleable.XTitleBar_LeftTextSize, (float)UIUtils.sp2px(this.getContext(), 14.0f));
        this._rightImageID[0] = array.getResourceId(R.styleable.XTitleBar_RightBtn_Nor, 0);
        this._rightImageID[1] = array.getResourceId(R.styleable.XTitleBar_RightBtn_Sel, 0);
        this._secondRightImageID[0] = array.getResourceId(R.styleable.XTitleBar_SecondRightBtn_Nor, 0);
        this._secondRightImageID[1] = array.getResourceId(R.styleable.XTitleBar_SecondRightBtn_Sel, 0);
        this._rightText = array.getString(R.styleable.XTitleBar_RightText);
        this._rightTextColor = array.getColor(R.styleable.XTitleBar_RightTextColor, 0);
        this._rightTextSize = array.getDimension(R.styleable.XTitleBar_RightTextSize, (float)UIUtils.sp2px(this.getContext(), 14.0f));
        this.rightExViewId = array.getResourceId(R.styleable.XTitleBar_TitleRightExtraViewLayout, 0);
        this.isShowBottomLine = array.getBoolean(R.styleable.XTitleBar_IsShowBottomLine, false);
        this.itemMinHeight = (int)array.getDimension(R.styleable.XTitleBar_ItemMinHeight, 0.0f);
        this.isShowBottomTip = array.getBoolean(R.styleable.XTitleBar_ShowBottomTip, false);
        this.bottomTipText = array.getString(R.styleable.XTitleBar_BottomTipText);
        this.bottomTipTextSize = array.getDimension(R.styleable.XTitleBar_BottomTipSize, (float)UIUtils.sp2px(this.getContext(), 10.0f));
        this.bottomTipTextColor = array.getColor(R.styleable.XTitleBar_BottomTipColor, 0);
        this.leftImgPadding = (int)array.getDimension(R.styleable.XTitleBar_LeftImgPadding, 0.0f);
        this.rightImgPadding = (int)array.getDimension(R.styleable.XTitleBar_RightImgPadding, 0.0f);
        this.isShowUnderLineTextFlag = array.getBoolean(R.styleable.XTitleBar_IsShowUnderLineTextFlag, true);
        array.recycle();
    }

    private void initView() {
        this.mItemLayout = (RelativeLayout)this.findViewById(R.id.item_title_bar);
        this.mTitleContent = (RelativeLayout)this.findViewById(R.id.rl_title_content);
        this.mLeftIv = (ImageView)this.findViewById(R.id.left_ib);
        this.mLeftTv = (TextView)this.findViewById(R.id.left_tv);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mBottomTip = (TextView)this.findViewById(R.id.tv_tip);
        this.mRightIv = (ImageView)this.findViewById(R.id.right_ib);
        this.mRightTv = (TextView)this.findViewById(R.id.right_tv);
        this.mSecondRightIv = (ImageView)this.findViewById(R.id.second_right_Iv);
        this.mBottomLineView = this.findViewById(R.id.view_bottom_line);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initView();
        if (this.mTitle != null) {
            this.mTitle.setText((CharSequence)(this._titleText == null ? "" : this._titleText));
            this.mTitle.setTextColor(this._titleColor);
            this.mTitle.setTextSize(0, this._titleSize);
        }
        if (this.mLeftTv != null) {
            if (this._leftText != null) {
                if (this.mLeftTv.getVisibility() != 0) {
                    this.mLeftTv.setVisibility(0);
                }
                this.mLeftTv.setText((CharSequence)this._leftText);
            }
            this.mLeftTv.setTextColor(this._leftTextColor);
            this.mLeftTv.setTextSize(0, this._leftTextSize);
        }
        if (this._leftImageID[0] != 0 && this.mLeftIv != null) {
            this.mLeftIv.setImageResource(this._leftImageID[this._btnValue]);
        }
        if (this.mRightTv != null) {
            this.mRightTv.setText((CharSequence)(this._rightText == null ? "" : this._rightText));
            this.mRightTv.setTextColor(this._rightTextColor);
            this.mRightTv.setTextSize(0, this._rightTextSize);
            if (this.isShowUnderLineTextFlag) {
                this.mRightTv.getPaint().setFlags(8);
                this.mRightTv.getPaint().setAntiAlias(true);
            }
        }
        if (this._rightImageID[0] != 0 && this.mRightIv != null) {
            this.mRightIv.setImageResource(this._rightImageID[this._btnValue]);
        }
        if (this._secondRightImageID[0] != 0 && this.mSecondRightIv != null) {
            this.mSecondRightIv.setBackgroundResource(this._secondRightImageID[this._secondRightBtnValue]);
        }
        if (this.mLeftIv != null) {
            this.mLeftIv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XTitleBar.this._btnValue = XTitleBar.this._btnValue == 0 ? 1 : 0;
                    XTitleBar.this.mLeftIv.setImageResource(XTitleBar.this._leftImageID[XTitleBar.this._btnValue]);
                    if (XTitleBar.this.mOnLeftClick != null) {
                        XTitleBar.this.mOnLeftClick.onLeftclick();
                    }
                }
            });
            if (this.leftImgPadding != 0) {
                this.mLeftIv.setPadding(this.leftImgPadding, this.leftImgPadding, this.leftImgPadding, this.leftImgPadding);
            }
        }
        if (this.mLeftTv != null) {
            this.mLeftTv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (XTitleBar.this.mOnLeftClick != null) {
                        XTitleBar.this.mOnLeftClick.onLeftclick();
                    }
                }
            });
        }
        if (this.mRightIv != null) {
            ViewGroup.LayoutParams layoutParams;
            this.mRightIv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XTitleBar.this._btnValue = XTitleBar.this._btnValue == 0 ? 1 : 0;
                    XTitleBar.this.mRightIv.setImageResource(XTitleBar.this._rightImageID[XTitleBar.this._btnValue]);
                    if (XTitleBar.this.mOnRightClick != null) {
                        XTitleBar.this.mOnRightClick.onRightClick();
                    }
                }
            });
            if (this.rightImageWidth != 0.0f && (layoutParams = this.mRightIv.getLayoutParams()) != null) {
                layoutParams.width = (int)this.rightImageWidth;
            }
            if (this.rightImageHeight != 0.0f && (layoutParams = this.mRightIv.getLayoutParams()) != null) {
                layoutParams.height = (int)this.rightImageHeight;
            }
            if (this.rightImgPadding != 0) {
                this.mRightIv.setPadding(this.rightImgPadding, this.rightImgPadding, this.rightImgPadding, this.rightImgPadding);
            }
        }
        if (this.mSecondRightIv != null) {
            this.mSecondRightIv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XTitleBar.this._secondRightBtnValue = XTitleBar.this._secondRightBtnValue == 0 ? 1 : 0;
                    XTitleBar.this.mSecondRightIv.setBackgroundResource(XTitleBar.this._secondRightImageID[XTitleBar.this._secondRightBtnValue]);
                    if (XTitleBar.this.mOnSecondRightClick != null) {
                        XTitleBar.this.mOnSecondRightClick.onSecondRightClick();
                    }
                }
            });
        }
        if (this.mRightTv != null) {
            this.mRightTv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (XTitleBar.this.mOnRightClick != null) {
                        XTitleBar.this.mOnRightClick.onRightClick();
                    }
                }
            });
        }
        this.rightExtraViewLayout = (FrameLayout)this.findViewById(R.id.right_ex_view_layout);
        if (this.rightExViewId != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.rightExViewId, (ViewGroup)this.rightExtraViewLayout, true);
            this.rightExView = this.rightExtraViewLayout.getChildAt(0);
            this.rightExtraViewLayout.setVisibility(0);
        }
        if (this.mBottomLineView != null) {
            this.mBottomLineView.setVisibility(this.isShowBottomLine ? 0 : 8);
        }
        if (this.mItemLayout != null) {
            this.mItemLayout.setMinimumHeight(this.itemMinHeight);
        }
        if (this.mBottomTip != null) {
            if (this.bottomTipTextColor != 0) {
                this.mBottomTip.setTextColor(this.bottomTipTextColor);
            }
            if (this.bottomTipTextSize > 0.0f) {
                this.mBottomTip.setTextSize(0, this.bottomTipTextSize);
            }
            this.mBottomTip.setVisibility(this.isShowBottomTip ? 0 : 8);
            this.mBottomTip.setText((CharSequence)this.bottomTipText);
        }
    }

    public void setLeftBtnResource(int norResId, int selResId) {
        this._leftImageID[0] = norResId;
        this._leftImageID[1] = selResId;
        if (null != this.mLeftIv) {
            this.mLeftIv.setImageResource(this._leftImageID[this._btnValue]);
        }
    }

    public void setLeftVisible(int i) {
        this.mLeftIv.setVisibility(i);
    }

    public void setSecondRightIvVisible(int i) {
        this.mSecondRightIv.setVisibility(i);
    }

    public void setSecondRightValue(int value) {
        this._secondRightBtnValue = value;
        this.mSecondRightIv.setBackgroundResource(this._secondRightImageID[this._secondRightBtnValue]);
    }

    public int getSecondRightValue() {
        return this._secondRightBtnValue;
    }

    public void setTitleText(String text) {
        this.setTitleText(text, false);
    }

    public void setTitleText(String text, boolean isNeedMarquee) {
        this.mTitle.setText((CharSequence)text);
        this.mTitle.setEllipsize(isNeedMarquee ? TextUtils.TruncateAt.MARQUEE : TextUtils.TruncateAt.END);
        this.post(() -> this.mTitle.requestLayout());
    }

    public String getTitleText() {
        return this.mTitle.getText().toString();
    }

    public void setLeftTitleText(String text) {
        this.mLeftTv.setText((CharSequence)text);
    }

    public void setRightTitleText(String text) {
        this.mRightTv.setText((CharSequence)text);
    }

    public String getRightTitleText() {
        return this.mRightTv.getText().toString().trim();
    }

    public TextView getRightTextView() {
        return this.mRightTv;
    }

    public void setLeftBtnValue(int value) {
        this._btnValue = value;
        this.mLeftIv.setImageResource(this._leftImageID[this._btnValue]);
    }

    public ImageView getLeftBtn() {
        return this.mLeftIv;
    }

    public void setRightBtnValue(int value) {
        this._btnValue = value;
        this.mRightIv.setImageResource(this._rightImageID[this._btnValue]);
    }

    public ImageView getRightBtn() {
        return this.mRightIv;
    }

    public ImageView getSecondRightBtn() {
        return this.mSecondRightIv;
    }

    public void setRightBtnResource(int norResId, int selResId) {
        this._rightImageID[0] = norResId;
        this._rightImageID[1] = selResId;
        if (null != this.mRightIv) {
            this.mRightIv.setImageResource(this._rightImageID[this._btnValue]);
        }
    }

    public FrameLayout getRightExtraViewLayout() {
        return this.rightExtraViewLayout;
    }

    public void setLeftClick(OnLeftClickListener mOnClick) {
        this.mOnLeftClick = mOnClick;
    }

    public void setLeftTvClick(OnLeftClickListener mOnClick) {
        this.mOnLeftClick = mOnClick;
    }

    public void setRightIvClick(OnRightClickListener mOnClick) {
        this.mOnRightClick = mOnClick;
    }

    public void setRightTvClick(OnRightClickListener mOnClick) {
        this.mOnRightClick = mOnClick;
    }

    public void setSecondRightTvClick(OnSecondRightClickListener SecondRightClickListener) {
        this.mOnSecondRightClick = SecondRightClickListener;
    }

    public void setViewVisibility(ViewName view, int Vis) {
        if (view != null) {
            switch (view) {
                case mLeftIv: {
                    this.mLeftIv.setVisibility(Vis);
                    break;
                }
                case mLeftTv: {
                    this.mLeftTv.setVisibility(Vis);
                    break;
                }
                case mTitle: {
                    this.mTitle.setVisibility(Vis);
                    break;
                }
                case mRightIv: {
                    this.mRightIv.setVisibility(Vis);
                    break;
                }
                case mRightTv: {
                    this.mRightTv.setVisibility(Vis);
                    break;
                }
                case rightExtraViewLayout: {
                    this.rightExtraViewLayout.setVisibility(Vis);
                    break;
                }
            }
        }
    }

    public void setShowBottomLine(boolean show) {
        this.isShowBottomLine = show;
        if (this.mBottomLineView != null) {
            this.mBottomLineView.setVisibility(this.isShowBottomLine ? 0 : 8);
        }
    }

    public boolean isShowBottomLine() {
        return this.isShowBottomLine;
    }

    public void setBottomTip(String tip) {
        this.bottomTipText = tip;
        if (TextUtils.isEmpty((CharSequence)tip)) {
            this.mBottomTip.setVisibility(8);
        } else {
            this.mBottomTip.setVisibility(0);
            if (this.mBottomTip != null) {
                this.mBottomTip.setText((CharSequence)this.bottomTipText);
            }
        }
    }

    public TextView getBottomTipTextView() {
        return this.mBottomTip;
    }

    public void setLeftImgPadding(int padding) {
        this.leftImgPadding = padding;
        if (this.leftImgPadding != 0) {
            this.mLeftIv.setPadding(this.leftImgPadding, this.leftImgPadding, this.leftImgPadding, this.leftImgPadding);
        }
    }

    public void setRightImgPadding(int padding) {
        this.rightImgPadding = padding;
        if (this.rightImgPadding != 0) {
            this.mRightIv.setPadding(this.rightImgPadding, this.rightImgPadding, this.rightImgPadding, this.rightImgPadding);
        }
    }

    public void setRightImg2Padding(int padding, int direcation) {
        this.rightImgPadding = padding;
        if (this.rightImgPadding != 0) {
            switch (direcation) {
                case 1: {
                    this.mSecondRightIv.setPadding(this.rightImgPadding, 0, 0, 0);
                    break;
                }
                case 2: {
                    this.mSecondRightIv.setPadding(0, 0, this.rightImgPadding, 0);
                    break;
                }
                case 3: {
                    this.mSecondRightIv.setPadding(0, this.rightImgPadding, 0, 0);
                    break;
                }
                case 4: {
                    this.mSecondRightIv.setPadding(0, 0, 0, this.rightImgPadding);
                    break;
                }
                case -1: {
                    this.mSecondRightIv.setPadding(this.rightImgPadding, this.rightImgPadding, this.rightImgPadding, this.rightImgPadding);
                    break;
                }
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mSecondRightIv != null) {
            this.mTitleContent.setPadding(this.mSecondRightIv.getWidth(), 0, this.mSecondRightIv.getWidth(), 0);
        }
    }

    public static enum ViewName {
        mLeftIv,
        mLeftTv,
        mTitle,
        mRightIv,
        mRightTv,
        rightExtraViewLayout;

    }

    public static interface OnSecondRightClickListener {
        public void onSecondRightClick();
    }

    public static interface OnRightClickListener {
        public void onRightClick();
    }

    public static interface OnLeftClickListener {
        public void onLeftclick();
    }
}

