/*
 * Decompiled with CFR 0.152.
 */
package com.xmgl.vrsoft;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.view.GestureDetectorCompat;
import com.xmgl.vrsoft.VRSoftDefine;
import com.xmgl.vrsoft.VRSoftEvent;
import com.xmgl.vrsoft.VRSoftGLView;
import com.xmgl.vrsoft.VRSoftJNI;
import java.util.List;

public class VRSoftEventJNI
extends VRSoftEvent {
    private DewarperJNIGestureListener mJniGestureListener = null;
    private GestureDetectorCompat mJniDetector = null;
    private int mShape = 0;
    private int mMount = 0;
    private final int MESSAGE_ADJUST = 257;
    private final int MESSAGE_TOUCHABLE = 258;
    private final int MESSAGE_SWITCH_SHAPE = 259;
    private boolean mDoubleTapEnable = true;
    private GestureDetector.OnGestureListener mOutGestureListener;
    private GestureDetectorCompat mOutDetector = null;
    private GestureDetector.OnDoubleTapListener mDoubleTapListener;
    private boolean isDoorBellWallMode;
    private boolean isSupportVRFollow;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 257: {
                    VRSoftJNI.autoAdjust(VRSoftEventJNI.this.mVRSoftHande);
                    VRSoftEventJNI.this.drawView();
                    break;
                }
                case 258: {
                    if (null == VRSoftEventJNI.this.mGLSurfaceView) break;
                    VRSoftEventJNI.this.mGLSurfaceView.setTouchable(true);
                    break;
                }
                case 259: {
                    if (null == VRSoftEventJNI.this.mGLSurfaceView) break;
                    int cameraType = VRSoftEventJNI.this.mGLSurfaceView.getType();
                    if (0 == cameraType) {
                        if (VRSoftEventJNI.this.mMount == 0) {
                            if (VRSoftDefine.CeilingMode.isEmpty()) break;
                            int index = VRSoftEventJNI.this.indexOf(VRSoftEventJNI.this.mShape, VRSoftDefine.CeilingMode);
                            if (index == VRSoftDefine.CeilingMode.size() - 1) {
                                VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.CeilingMode.get(0));
                                break;
                            }
                            VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.CeilingMode.get(index + 1));
                            break;
                        }
                        if (VRSoftEventJNI.this.mMount != 1) break;
                        if (VRSoftEventJNI.this.isDoorBellWallMode) {
                            if (VRSoftDefine.DoorBellWallMode.isEmpty()) break;
                            int index = VRSoftEventJNI.this.indexOf(VRSoftEventJNI.this.mShape, VRSoftDefine.DoorBellWallMode);
                            if (index == VRSoftDefine.DoorBellWallMode.size() - 1) {
                                VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.DoorBellWallMode.get(0));
                                break;
                            }
                            VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.DoorBellWallMode.get(index + 1));
                            break;
                        }
                        if (VRSoftDefine.WallMode.isEmpty()) break;
                        int index = VRSoftEventJNI.this.indexOf(VRSoftEventJNI.this.mShape, VRSoftDefine.WallMode);
                        if (index == VRSoftDefine.WallMode.size() - 1) {
                            VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.WallMode.get(0));
                            break;
                        }
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(VRSoftDefine.WallMode.get(index + 1));
                        break;
                    }
                    if (1 != cameraType) break;
                    if (VRSoftEventJNI.this.isSupportVRFollow) {
                        if (VRSoftEventJNI.this.mShape == 0) {
                            VRSoftEventJNI.this.mGLSurfaceView.setShape(5);
                            break;
                        }
                        if (VRSoftEventJNI.this.mShape != 5) break;
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(0);
                        break;
                    }
                    if (VRSoftEventJNI.this.mShape == 0) {
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(5);
                        break;
                    }
                    if (VRSoftEventJNI.this.mShape == 5) {
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(3);
                        break;
                    }
                    if (VRSoftEventJNI.this.mShape == 3) {
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(7);
                        break;
                    }
                    if (VRSoftEventJNI.this.mShape == 7) {
                        VRSoftEventJNI.this.mGLSurfaceView.setShape(10);
                        break;
                    }
                    if (VRSoftEventJNI.this.mShape != 10) break;
                    VRSoftEventJNI.this.mGLSurfaceView.setShape(0);
                }
            }
        }
    };

    public VRSoftEventJNI(Context context, VRSoftGLView glView, int vrHandle) {
        super(context, glView, vrHandle);
        this.mJniGestureListener = new DewarperJNIGestureListener();
        this.mJniDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.mJniGestureListener);
    }

    public void setCameraMount(int mount) {
        this.mMount = mount;
    }

    public void setShape(int shape) {
        this.mShape = shape;
    }

    public void setDoubleTap(boolean enable) {
        this.mDoubleTapEnable = enable;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.mHandler) {
            this.mHandler.removeMessages(257);
        }
        if (this.mJniDetector != null) {
            this.mJniDetector.onTouchEvent(event);
        }
        if (this.mOutDetector != null) {
            this.mOutDetector.onTouchEvent(event);
        }
        if (event.getAction() == 1) {
            VRSoftJNI.onTouchUp(this.mVRSoftHande, event.getX(), event.getY());
            this.mHandler.sendEmptyMessageDelayed(257, 120L);
            this.mHandler.sendEmptyMessageDelayed(258, 150L);
        }
        return true;
    }

    public boolean setDrawMode(int drawMode) {
        return true;
    }

    public int getDrawMode() {
        return 0;
    }

    @Override
    public void setPTZs() {
    }

    @Override
    public boolean needContinue() {
        return false;
    }

    @Override
    public void goToDefaultPosition() {
    }

    public GestureDetector.OnGestureListener getGestureListener() {
        return this.mOutGestureListener;
    }

    public void setGestureListener(GestureDetector.OnGestureListener gestureListener) {
        if (gestureListener == null) {
            return;
        }
        this.mOutGestureListener = gestureListener;
        this.mOutDetector = new GestureDetectorCompat(this.mContext, gestureListener);
    }

    public GestureDetector.OnDoubleTapListener getmDoubleTapListener() {
        return this.mDoubleTapListener;
    }

    public void setmDoubleTapListener(GestureDetector.OnDoubleTapListener mDoubleTapListener) {
        this.mDoubleTapListener = mDoubleTapListener;
    }

    public boolean isDoorBellWallMode() {
        return this.isDoorBellWallMode;
    }

    public void setDoorBellWallMode(boolean isDoorBellWallMode) {
        this.isDoorBellWallMode = isDoorBellWallMode;
    }

    private int indexOf(@NonNull Object object, List<Integer> list) {
        int s;
        int n = s = list == null ? 0 : list.size();
        if (object != null) {
            for (int i = 0; i < s; ++i) {
                if (((Integer)object).intValue() != list.get(i).intValue()) continue;
                return i;
            }
        } else {
            for (int i = 0; i < s; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSupportVRFollow(boolean isSupportVRFollow) {
        this.isSupportVRFollow = isSupportVRFollow;
    }

    class DewarperJNIGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        DewarperJNIGestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            VRSoftJNI.onTouchDown(VRSoftEventJNI.this.mVRSoftHande, e.getX(), e.getY());
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            VRSoftJNI.onTouchFling(VRSoftEventJNI.this.mVRSoftHande, velocityX, velocityY);
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (null != e2) {
                switch (e2.getPointerCount()) {
                    case 1: {
                        VRSoftJNI.onTouchMove(VRSoftEventJNI.this.mVRSoftHande, e2.getX(), e2.getY());
                        break;
                    }
                    case 2: {
                        MotionEvent.PointerCoords p0 = new MotionEvent.PointerCoords();
                        MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
                        e2.getPointerCoords(0, p0);
                        e2.getPointerCoords(1, p1);
                        VRSoftJNI.onTouchPinch(VRSoftEventJNI.this.mVRSoftHande, p0.x, p0.y, p1.x, p1.y);
                    }
                }
                return true;
            }
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (VRSoftEventJNI.this.mDoubleTapEnable && VRSoftEventJNI.this.mHandler != null) {
                VRSoftEventJNI.this.mHandler.removeMessages(259);
                VRSoftEventJNI.this.mHandler.sendEmptyMessageDelayed(259, 120L);
            }
            if (null != VRSoftEventJNI.this.mDoubleTapListener) {
                return VRSoftEventJNI.this.mDoubleTapListener.onDoubleTapEvent(e);
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
        }
    }
}

