/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.Context;
import android.text.TextUtils;
import com.lib.FunSDK;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    public static String formatTimes(int seconds) {
        int MM = seconds / 60;
        int HH = MM / 60;
        int SS = seconds % 60;
        if (HH == 0 && MM == 0) {
            return "00:" + String.format("%02d", SS);
        }
        if (HH == 0) {
            return String.format("%02d:%02d", MM, SS);
        }
        return String.format("%02d:%02d:%02d", HH, MM -= HH * 60, SS);
    }

    public static String formatTimesV2(int seconds) {
        int MM = seconds / 60;
        int HH = MM / 60;
        int SS = seconds % 60;
        if (HH == 0 && MM == 0) {
            return String.format("%02d:%02d:%02d", HH, MM, SS);
        }
        if (HH == 0) {
            return String.format("%02d:%02d:%02d", HH, MM, SS);
        }
        return String.format("%02d:%02d:%02d", HH, MM -= HH * 60, SS);
    }

    public static String formatTimesV3(Context context, long seconds) {
        long mm = seconds / 60L;
        long hh = mm / 60L;
        long dd = hh / 24L;
        long MM = dd / 30L;
        long yy = dd / 365L;
        long ss = seconds % 60L;
        if (yy > 0L) {
            int M = (int)(dd % 365L / 30L);
            if (M > 0) {
                return String.valueOf(yy) + FunSDK.TS("TR_Year") + M + FunSDK.TS("TR_Month");
            }
            return String.valueOf(yy) + FunSDK.TS("TR_Year");
        }
        if (MM > 0L) {
            int d = (int)(dd % 30L);
            if (d > 0) {
                return String.valueOf(MM) + FunSDK.TS("TR_Month") + d + FunSDK.TS("TR_Day");
            }
            return String.valueOf(MM) + FunSDK.TS("TR_Month");
        }
        if (dd > 0L) {
            int h = (int)(hh % 24L);
            if (h > 0) {
                return String.valueOf(dd) + FunSDK.TS("TR_Day") + h + FunSDK.TS("TR_Hor");
            }
            return String.valueOf(dd) + FunSDK.TS("TR_Day");
        }
        if (hh > 0L) {
            int m = (int)(mm % 60L);
            if (m > 0) {
                return String.valueOf(hh) + FunSDK.TS("TR_Hor") + m + FunSDK.TS("TR_Min");
            }
            return String.valueOf(hh) + FunSDK.TS("TR_Hor");
        }
        if (mm > 0L) {
            int s = (int)(seconds % 60L);
            if (s > 0) {
                return String.valueOf(mm) + FunSDK.TS("TR_Min") + s + FunSDK.TS("TR_Sec");
            }
            return String.valueOf(mm) + FunSDK.TS("TR_Min");
        }
        return String.valueOf(ss) + FunSDK.TS("TR_Sec");
    }

    public static String formatTimes(int hour, int minute, int second) {
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static String formatTimes(String hour, String minute, String second) {
        return String.format("%02d:%02d:%02d", Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
    }

    public static long getLongTimes(int hour, int minute, int second) {
        long times = hour * 3600 + minute * 60 + second;
        return times;
    }

    public static String formatTimesByYear(long times) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(times));
    }

    public static int[] timeStr2array(String time) {
        if (!TimeUtils.checkTimeFormat(time)) {
            return null;
        }
        int[] times = new int[6];
        String[] t1 = time.split(" ");
        String[] left = t1[0].split("-");
        String[] right = t1[1].split(":");
        times[0] = Integer.parseInt(left[0]);
        times[1] = Integer.parseInt(left[1]);
        times[2] = Integer.parseInt(left[2]);
        times[3] = Integer.parseInt(right[0]);
        times[4] = Integer.parseInt(right[1]);
        times[5] = Integer.parseInt(right[2]);
        return times;
    }

    public static boolean checkTimeFormat(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return false;
        }
        return time.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}");
    }

    public static String timeArray2str(boolean forJson, String ... time) {
        StringBuilder sb = new StringBuilder();
        sb.append(time[0]).append(forJson ? "-" : FunSDK.TS("sYear")).append(time[1]).append(forJson ? "-" : FunSDK.TS("sMonth")).append(time[2]).append(forJson ? " " : FunSDK.TS("sDay")).append(time[3]).append(":").append(time[4]);
        if (forJson) {
            if (time.length == 5) {
                sb.append(":").append("00");
            } else if (time.length == 6) {
                sb.append(":").append(time[5]);
            }
        }
        return sb.toString();
    }

    public static String timeArray2str(boolean forJson, int ... time) {
        StringBuilder sb = new StringBuilder();
        sb.append(time[0] < 10 ? "0" + time[0] : Integer.valueOf(time[0])).append(forJson ? "-" : FunSDK.TS("sYear")).append(time[1] < 10 ? "0" + time[1] : Integer.valueOf(time[1])).append(forJson ? "-" : FunSDK.TS("sMonth")).append(time[2] < 10 ? "0" + time[2] : Integer.valueOf(time[2])).append(forJson ? " " : FunSDK.TS("sDay")).append(time[3] < 10 ? "0" + time[3] : Integer.valueOf(time[3])).append(":").append(time[4] < 10 ? "0" + time[4] : Integer.valueOf(time[4]));
        if (forJson) {
            if (time.length == 5) {
                sb.append(":").append("00");
            } else if (time.length == 6) {
                sb.append(":").append(time[5] < 10 ? "0" + time[5] : Integer.valueOf(time[5]));
            }
        }
        return sb.toString();
    }

    public static String showNormalFormatByDay(Long timeInMillis) {
        if (timeInMillis == null || timeInMillis <= 0L) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return format.format(calendar.getTime());
    }

    public static String showNormalFormat(Long timeInMillis) {
        if (timeInMillis <= 0L) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return format.format(calendar.getTime());
    }

    public static SimpleDateFormat getNormalDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format;
    }

    public static Calendar getNormalFormatCalender(String normalFormatTime) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(normalFormatTime);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return calendar;
        }
    }

    public static Calendar getNormalFormatCalenderByDate(String normalFormatTime) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = format.parse(normalFormatTime);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return calendar;
        }
    }

    public static boolean isSameDay(Calendar calendar1, Calendar calendar2) {
        if (calendar1 == null || calendar2 == null) {
            return false;
        }
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5);
    }
}

