/*
 * Decompiled with CFR 0.152.
 */
package com.lib.decoder;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.lib.decoder.DecoderManaer;
import com.lib.decoder.SFrameInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@SuppressLint(value={"NewApi"})
public class XMediaDec {
    private MediaCodec _dec = null;
    private ByteBuffer[] _inputBuffers = null;
    private ByteBuffer[] _outBuffers = null;
    private MediaCodec.BufferInfo _outBufInfo = new MediaCodec.BufferInfo();
    private int _nWidth = 0;
    private int _nHeight = 0;
    private SFrameInfo _frameInfo = new SFrameInfo();
    private boolean _bFoundIFrame = false;
    byte[] _pOutBuf = null;
    int _nDecType = -1;
    int _nDecFrameCount = 0;
    int _nFrameRate = 25;
    int _nColorFormat = 0;
    int _nKeyWidth = 0;
    int _nKeyHeight = 0;
    private SurfaceTexture _videoTexture = null;
    public static final int E_DEC_OK = 0;
    public static final int E_DEC_ERROR_INIT = -1000;
    public static final int E_DEC_ERROR_START = -1;
    public static final int E_DEC_ERROR_GET_INPUT = -2;
    public static final int E_DEC_ERROR_INPUT = -3;
    public static final int E_DEC_ERROR_OUTPUT = -4;
    static final int N_MAX_DECODER_SIZE = 16;
    static XMediaDec[] s_dec = new XMediaDec[16];
    static final String TAG = "DEC_LOG";

    public XMediaDec() {
        Log.i((String)TAG, (String)"decoder new XMediaDec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int NewDecoder() {
        XMediaDec[] xMediaDecArray = s_dec;
        synchronized (s_dec) {
            block6: {
                if (DecoderManaer.IsEnableHDec()) break block6;
                // ** MonitorExit[var0] (shouldn't be in output)
                return -1;
            }
            int nId = -1;
            int i = 0;
            while (i < 16) {
                if (s_dec[i] == null) {
                    XMediaDec.s_dec[i] = new XMediaDec();
                    nId = i;
                    break;
                }
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return nId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DestoryDecoder(int nId) {
        XMediaDec[] xMediaDecArray = s_dec;
        synchronized (s_dec) {
            if (nId > -1 && nId < 16 && s_dec[nId] != null) {
                s_dec[nId].CloseDec();
                XMediaDec.s_dec[nId] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static byte[] Decode(int nId, int[] nDecRet, int[] pFrameInfo, byte[] pBuffer) {
        return s_dec[nId].Decode(nDecRet, pFrameInfo, pBuffer);
    }

    public int GetWidth() {
        return this._nWidth;
    }

    public int GetHeight() {
        return this._nHeight;
    }

    public void SetSurfacTexture(SurfaceTexture videoTexture) {
        this._videoTexture = videoTexture;
    }

    private int RefreshParams(int[] pFrameInfo) {
        System.arraycopy(pFrameInfo, 0, this._frameInfo.params, 0, this._frameInfo.params.length);
        if (this._frameInfo.params[9] > 0 && this._frameInfo.params[10] > 0 && this._frameInfo.params[1] == 1 && this._frameInfo.params[2] == 0) {
            if (this._nWidth != this._frameInfo.params[9] || this._nHeight != this._frameInfo.params[10]) {
                this.CloseDec();
                this._nWidth = this._frameInfo.params[9];
                this._nHeight = this._frameInfo.params[10];
            }
            if (this._frameInfo.params[11] > 0) {
                this._nFrameRate = this._frameInfo.params[11];
            }
            this._bFoundIFrame = true;
        }
        if (!this._bFoundIFrame) {
            return -1;
        }
        return 0;
    }

    private int InitMediaDec(int[] nDecRet, byte[] pBuffer) {
        int nRet = -1;
        Surface surface = null;
        if (this._videoTexture != null) {
            surface = new Surface(this._videoTexture);
        }
        int[] nColorFormats = new int[]{21, -1, 2135033992, 19};
        int i = 0;
        while (i < nColorFormats.length) {
            block12: {
                try {
                    nRet = -1;
                    if (this.StartDec(surface, this._frameInfo.params[15], nColorFormats[i]) < 0) {
                        this._bFoundIFrame = false;
                        Log.i((String)TAG, (String)"decoder StartDec Error");
                        nRet -= 1000;
                        this.CloseDec();
                        break block12;
                    }
                    long lStart = System.currentTimeMillis();
                    int nInputCount = 0;
                    while (System.currentTimeMillis() - lStart < 1000L) {
                        if (nInputCount < 25) {
                            nRet = -3;
                            int inputIndex = this._dec.dequeueInputBuffer(0L);
                            int nDataLen = pBuffer.length;
                            if (inputIndex >= 0) {
                                ByteBuffer inputBuffer = this._inputBuffers[inputIndex];
                                inputBuffer.clear();
                                inputBuffer.put(pBuffer, 0, nDataLen);
                                ++this._nDecFrameCount;
                                this._dec.queueInputBuffer(inputIndex, 0, nDataLen, 200000L, 0);
                                ++nInputCount;
                            }
                        }
                        nRet = -4;
                        int outIndex = this._dec.dequeueOutputBuffer(this._outBufInfo, 10000L);
                        if (outIndex < 0) {
                            Thread.sleep(1L);
                            continue;
                        }
                        if (nDecRet != null) {
                            ByteBuffer bf = this._dec.getOutputBuffer(outIndex);
                            if (this.setDecResult(nDecRet, bf) <= 0) break;
                            nRet = 0;
                            break;
                        }
                        nRet = 0;
                        break;
                    }
                    if (nRet == 0) break;
                    this.CloseDec();
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("decoder-->hard:" + nRet + "Error:" + e.toString()));
                    this._bFoundIFrame = false;
                    this.CloseDec();
                }
                if (surface != null) {
                    surface.release();
                }
                Log.i((String)TAG, (String)("decoder Rsult:" + nRet));
                if (nRet != 0) {
                    nRet -= 1000;
                }
            }
            ++i;
        }
        return nRet;
    }

    private int DequeueInputData(byte[] pBuffer) {
        int inputIndex = this._dec.dequeueInputBuffer(400000L);
        if (inputIndex < 0) {
            int outIndex;
            while ((outIndex = this._dec.dequeueOutputBuffer(this._outBufInfo, 0L)) >= 0) {
                this._dec.releaseOutputBuffer(outIndex, false);
            }
            this._bFoundIFrame = false;
            return -3;
        }
        int nDataLen = pBuffer.length;
        ByteBuffer inputBuffer = this._inputBuffers[inputIndex];
        inputBuffer.clear();
        inputBuffer.put(pBuffer, 0, nDataLen);
        ++this._nDecFrameCount;
        this._dec.queueInputBuffer(inputIndex, 0, nDataLen, 0L, 0);
        return 0;
    }

    public int InputData(int[] pFrameInfo, byte[] pBuffer) {
        int nRet = this.RefreshParams(pFrameInfo);
        if (nRet != 0) {
            return nRet;
        }
        if (this._dec == null && (nRet = this.InitMediaDec(null, pBuffer)) != 0) {
            return nRet;
        }
        try {
            nRet = this.DequeueInputData(pBuffer);
            if (nRet != 0) {
                return nRet;
            }
            int outIndex = this._dec.dequeueOutputBuffer(this._outBufInfo, 20000L);
            while (outIndex >= 0) {
                this._dec.releaseOutputBuffer(outIndex, true);
                outIndex = this._dec.dequeueOutputBuffer(this._outBufInfo, 0L);
            }
            return 0;
        }
        catch (Exception exception) {
            return -3;
        }
    }

    int setDecResult(int[] nDecRet, ByteBuffer bf) {
        int nRetLen;
        if (bf == null) {
            return 0;
        }
        if (this._nKeyWidth == 0) {
            MediaFormat outFormat = this._dec.getOutputFormat();
            int nColorFormat = outFormat.getInteger("color-format");
            this._nColorFormat = -1;
            switch (nColorFormat) {
                case 21: 
                case 2135033992: {
                    this._nColorFormat = 0;
                    break;
                }
                case 19: {
                    this._nColorFormat = 1;
                }
            }
            this._nKeyWidth = outFormat.getInteger("width");
            this._nKeyHeight = outFormat.getInteger("height");
            String outInfo = String.format("ColorFormate:%d; KeyWidth/Height(%d,%d)", nColorFormat, this._nKeyWidth, this._nKeyHeight);
            Log.i((String)TAG, (String)("decoder-->" + outInfo));
            if (this._nColorFormat == -1) {
                Log.i((String)TAG, (String)("decoder-->No Sup Colorformate:" + nColorFormat));
                return -1;
            }
        }
        if ((nRetLen = bf.remaining()) <= 0) {
            return -2;
        }
        if (this._pOutBuf == null || nRetLen > this._pOutBuf.length) {
            this._pOutBuf = new byte[nRetLen];
        }
        Log.i((String)TAG, (String)("decoder-->Result:" + this._nColorFormat + "  kw/kh:" + this._nKeyWidth + "/" + this._nKeyHeight));
        bf.get(this._pOutBuf);
        nDecRet[1] = this._nWidth;
        nDecRet[2] = this._nHeight;
        nDecRet[3] = this._nColorFormat;
        nDecRet[4] = nRetLen;
        nDecRet[5] = this._nKeyWidth;
        nDecRet[6] = this._nKeyHeight;
        return nRetLen;
    }

    public byte[] Decode(int[] nDecRet, int[] pFrameInfo, byte[] pBuffer) {
        int outIndex;
        block9: {
            block8: {
                nDecRet[0] = this.RefreshParams(pFrameInfo);
                if (nDecRet[0] != 0) {
                    return null;
                }
                if (this._dec == null) {
                    nDecRet[0] = this.InitMediaDec(nDecRet, pBuffer);
                    if (nDecRet[0] != 0) {
                        return null;
                    }
                    return this._pOutBuf;
                }
                try {
                    nDecRet[0] = this.DequeueInputData(pBuffer);
                    if (nDecRet[0] == 0) break block8;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            nDecRet[0] = 0;
            outIndex = this._dec.dequeueOutputBuffer(this._outBufInfo, 3000000L);
            if (outIndex >= 0) break block9;
            return null;
        }
        byte[] pRet = null;
        ByteBuffer bf = this._dec.getOutputBuffer(outIndex);
        if (this.setDecResult(nDecRet, bf) > 0) {
            pRet = this._pOutBuf;
        }
        this._dec.releaseOutputBuffer(outIndex, false);
        return pRet;
    }

    private void showSupportedColorFormat(MediaCodecInfo.CodecCapabilities caps) {
        int[] nArray = caps.colorFormats;
        int n = caps.colorFormats.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            Log.i((String)TAG, (String)("decoder-->supported color format:" + c + "\t"));
            ++n2;
        }
    }

    private boolean isColorFormatSupported(int colorFormat, MediaCodecInfo.CodecCapabilities caps) {
        int[] nArray = caps.colorFormats;
        int n = caps.colorFormats.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            if (c == colorFormat) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int StartDec(Surface surface, int nVideoType, int nColorformat) throws IOException {
        String mime = "";
        switch (nVideoType) {
            case 2: {
                mime = "video/avc";
                break;
            }
            case 3: {
                mime = "video/hevc";
                break;
            }
        }
        Log.i((String)TAG, (String)("Start dec new, width:" + this._nWidth + "height:" + this._nHeight + "mime:" + mime));
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)mime, (int)this._nWidth, (int)this._nHeight);
        this._dec = MediaCodec.createDecoderByType((String)mime);
        if (this._dec == null) {
            return -1;
        }
        if (nColorformat != -1) {
            mediaFormat.setInteger("color-format", nColorformat);
        }
        Log.d((String)TAG, (String)("StartDec decoder:" + this._dec.getName() + "rate:" + this._nFrameRate));
        mediaFormat.setInteger("frame-rate", this._nFrameRate);
        this._dec.configure(mediaFormat, surface, null, 0);
        this._dec.start();
        this._inputBuffers = this._dec.getInputBuffers();
        this._outBuffers = this._dec.getOutputBuffers();
        this._outBufInfo = new MediaCodec.BufferInfo();
        this._nDecType = nVideoType;
        DecoderManaer.AddHDec(this);
        return 0;
    }

    public void CloseDec() {
        if (this._dec == null) {
            return;
        }
        try {
            this._inputBuffers = null;
            this._outBuffers = null;
            this._outBufInfo = null;
            this._dec.flush();
            this._dec.stop();
            this._dec.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._dec = null;
        this._bFoundIFrame = false;
        this._nKeyWidth = 0;
        this._nKeyHeight = 0;
        DecoderManaer.ReleaseHDec(this);
    }

    void PrintfDecInfo() {
        int numCodecs = MediaCodecList.getCodecCount();
        MediaCodecInfo codecInfo = null;
        int i = 0;
        while (i < numCodecs && codecInfo == null) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (info.isEncoder()) {
                String[] types = info.getSupportedTypes();
                boolean found = false;
                int j = 0;
                while (j < types.length && !found) {
                    if (types[j].equals("video/avc")) {
                        System.out.println("found");
                        found = true;
                    }
                    ++j;
                }
                if (found) {
                    codecInfo = info;
                }
            }
            ++i;
        }
        Log.d((String)TAG, (String)("Found " + codecInfo.getName() + " supporting " + "video/avc"));
        int colorFormat = 0;
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType("video/avc");
        Log.d((String)TAG, (String)("decoder length-" + capabilities.colorFormats.length + "==" + Arrays.toString(capabilities.colorFormats)));
        int i2 = 0;
        while (i2 < capabilities.colorFormats.length) {
            int format = capabilities.colorFormats[i2];
            switch (format) {
                case 19: {
                    colorFormat = format;
                    Log.d((String)TAG, (String)"colorformat_sup:COLOR_FormatYUV420Planar");
                    break;
                }
                case 20: {
                    Log.d((String)TAG, (String)"colorformat_sup:COLOR_FormatYUV420PackedPlanar");
                    break;
                }
                case 21: {
                    colorFormat = format;
                    Log.d((String)TAG, (String)"colorformat_sup:COLOR_FormatYUV420SemiPlanar");
                    break;
                }
                case 39: {
                    colorFormat = format;
                    Log.d((String)TAG, (String)"colorformat_sup:COLOR_FormatYUV420PackedSemiPlanar");
                    break;
                }
                case 2130706688: {
                    colorFormat = format;
                    Log.d((String)TAG, (String)"colorformat_sup:COLOR_TI_FormatYUV420PackedSemiPlanar");
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)("Skipping unsupported color format " + format));
                }
            }
            ++i2;
        }
        Log.d((String)TAG, (String)("color format " + colorFormat));
    }
}

