/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.data;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public abstract class Floater<T extends View>
extends FrameLayout {
    protected T mMarker;
    private int mOffset;

    public Floater(Context context, AttributeSet attrs, int defStyleAttr, String maxValue) {
        super(context);
        this.createMarker(context);
    }

    protected abstract void createMarker(Context var1);

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSie = this.mMarker.getMeasuredHeight();
        this.setMeasuredDimension(widthSize, heightSie);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int centerDiffX = (this.mMarker.getMeasuredWidth() - this.mMarker.getPaddingLeft()) / 2;
        int offset = this.mOffset - centerDiffX;
        this.mMarker.layout(offset, 0, offset + this.mMarker.getMeasuredWidth(), this.mMarker.getMeasuredHeight());
    }

    public void setFloatOffset(int x) {
        this.mOffset = x;
        int centerDiffX = (this.mMarker.getMeasuredWidth() - this.mMarker.getPaddingLeft()) / 2;
        int offset = this.mOffset - centerDiffX;
        this.mMarker.offsetLeftAndRight(offset - this.mMarker.getLeft());
    }

    public int getSubViewWidth() {
        if (this.mMarker != null) {
            return this.mMarker.getWidth();
        }
        return 0;
    }

    public int getSubViewHeight() {
        if (this.mMarker != null) {
            return this.mMarker.getHeight();
        }
        return 0;
    }

    public T getMarker() {
        return this.mMarker;
    }
}

