/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.xm.ui.widget.data.Floater;
import com.xm.ui.widget.data.ImageTextViewFloater;
import com.xm.ui.widget.data.ImageViewFloater;
import com.xm.ui.widget.data.TextViewFloater;

public class BubbleIndicator {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private final WindowManager mWindowManager;
    private boolean mShowing;
    private int mDirection = 0;
    private int[] mDrawingLocation = new int[2];
    private Point screenSize = new Point();
    private Floater mPopupView;
    private DisplayMetrics mDisplayMetrics;

    public BubbleIndicator(Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
    }

    public void createTextViewFloater(Context context, AttributeSet attrs, int defStyleAttr, String maxValue) {
        this.mPopupView = new TextViewFloater(context, attrs, defStyleAttr, maxValue);
    }

    public void createImageViewFloater(Context context, AttributeSet attrs, int defStyleAttr, String maxValue) {
        this.mPopupView = new ImageViewFloater(context, attrs, defStyleAttr, maxValue);
    }

    public void createImageTextViewFloater(Context context, AttributeSet attrs, int defStyleAttr, String maxValue) {
        this.mPopupView = new ImageTextViewFloater(context, attrs, defStyleAttr, maxValue);
    }

    public void changeScreenSize(int width, int height) {
        this.screenSize.set(width, height);
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public View showIndicator(View parent, float touchX) {
        if (this.isShowing()) {
            return this.mPopupView.getMarker();
        }
        IBinder windowToken = parent.getWindowToken();
        if (windowToken != null && this.screenSize.x > 0) {
            WindowManager.LayoutParams p = this.createPopupLayout(windowToken);
            p.gravity = 0x800033;
            this.updateLayoutParamsForPosition(parent, p);
            this.mShowing = true;
            this.translateViewIntoPosition((int)touchX);
            this.invokePopup(p);
        }
        return this.mPopupView.getMarker();
    }

    public View showIndicator(View parent, float touchX, int backgroundColor) {
        if (this.isShowing()) {
            return this.mPopupView.getMarker();
        }
        IBinder windowToken = parent.getWindowToken();
        if (windowToken != null && this.screenSize.x > 0) {
            WindowManager.LayoutParams p = this.createPopupLayout(windowToken);
            p.gravity = 0x800033;
            this.updateLayoutParamsForPosition(parent, p);
            this.mShowing = true;
            this.translateViewIntoPosition((int)touchX);
            this.invokePopup(p);
        }
        if (this.mPopupView instanceof TextViewFloater) {
            ((TextViewFloater)this.mPopupView).setBackgroundColor(backgroundColor);
        }
        return this.mPopupView.getMarker();
    }

    public View showIndicator(View parent, Rect touchBounds) {
        if (this.isShowing()) {
            return this.mPopupView.getMarker();
        }
        IBinder windowToken = parent.getWindowToken();
        if (windowToken != null && this.screenSize.x > 0) {
            WindowManager.LayoutParams p = this.createPopupLayout(windowToken);
            p.gravity = 0x800033;
            this.updateLayoutParamsForPosition(parent, p);
            this.mShowing = true;
            this.translateViewIntoPosition(touchBounds.centerX());
            this.invokePopup(p);
        }
        return this.mPopupView.getMarker();
    }

    public View showIndicator(View parent, Rect touchBounds, int backgroundColor) {
        if (this.isShowing()) {
            return this.mPopupView.getMarker();
        }
        IBinder windowToken = parent.getWindowToken();
        if (windowToken != null && this.screenSize.x > 0) {
            WindowManager.LayoutParams p = this.createPopupLayout(windowToken);
            p.gravity = 0x800033;
            this.updateLayoutParamsForPosition(parent, p);
            this.mShowing = true;
            this.translateViewIntoPosition(touchBounds.centerX());
            this.invokePopup(p);
        }
        if (this.mPopupView instanceof TextViewFloater) {
            ((TextViewFloater)this.mPopupView).setBackgroundColor(backgroundColor);
        }
        return this.mPopupView.getMarker();
    }

    private WindowManager.LayoutParams createPopupLayout(IBinder windowToken) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = 0x800033;
        p.width = -2;
        p.height = -1;
        p.format = -3;
        p.flags = this.computeFlags(p.flags);
        p.type = 1000;
        p.token = windowToken;
        p.softInputMode = 3;
        return p;
    }

    private void invokePopup(WindowManager.LayoutParams p) {
        this.mWindowManager.addView((View)this.mPopupView, (ViewGroup.LayoutParams)p);
    }

    public void moveIndicator(int touchX) {
        if (!this.isShowing()) {
            return;
        }
        this.translateViewIntoPosition(touchX);
    }

    public void moveIndicator(int touchX, Bitmap bitmap) {
        if (!this.isShowing()) {
            return;
        }
        this.translateViewIntoPosition(touchX);
        if (this.mPopupView instanceof ImageViewFloater) {
            ((ImageViewFloater)this.mPopupView).setBitmap(bitmap);
        }
    }

    public void moveIndicator(float touchX, int progress) {
        if (!this.isShowing()) {
            return;
        }
        this.translateViewIntoPosition((int)touchX);
        if (this.mPopupView instanceof TextViewFloater) {
            ((TextViewFloater)this.mPopupView).setProgressText(progress);
        }
    }

    public void moveIndicator(float touchX, String content) {
        if (!this.isShowing()) {
            return;
        }
        this.translateViewIntoPosition((int)touchX);
        if (this.mPopupView instanceof TextViewFloater) {
            ((TextViewFloater)this.mPopupView).setOtherContent(content);
        } else if (this.mPopupView instanceof ImageTextViewFloater) {
            ((ImageTextViewFloater)this.mPopupView).setOtherContent(content);
        }
    }

    public void moveIndicator(Rect touchBounds, int progress) {
        if (!this.isShowing()) {
            return;
        }
        this.moveIndicator(touchBounds.centerX());
    }

    public void moveIndicator(Rect touchBounds, String content) {
        this.moveIndicator((float)touchBounds.centerX(), content);
    }

    public void hideIndicator() {
        if (!this.isShowing()) {
            return;
        }
        this.mShowing = false;
        this.mWindowManager.removeView((View)this.mPopupView);
    }

    private void translateViewIntoPosition(int x) {
        if (x + this.mDrawingLocation[0] - this.mPopupView.getSubViewWidth() / 2 < 0) {
            return;
        }
        this.mPopupView.setFloatOffset(x + this.mDrawingLocation[0]);
    }

    private void updateLayoutParamsForPosition(View anchor, WindowManager.LayoutParams p) {
        this.measureFloater();
        int measuredHeight = this.mPopupView.getMeasuredHeight();
        anchor.getLocationInWindow(this.mDrawingLocation);
        p.x = 0;
        if (this.mDirection == 0) {
            p.y = this.mDrawingLocation[1] - measuredHeight;
        } else if (this.mDirection == 1) {
            p.y = this.mDrawingLocation[1] + anchor.getHeight();
        }
        p.width = -1;
        p.height = measuredHeight;
    }

    private void measureFloater() {
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)this.screenSize.x, (int)0x40000000);
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)this.screenSize.y, (int)Integer.MIN_VALUE);
        this.mPopupView.measure(specWidth, specHeight);
    }

    private boolean isShowing() {
        return this.mShowing;
    }

    private int computeFlags(int curFlags) {
        curFlags &= 0xFFF97DE7;
        curFlags |= 0x8000;
        curFlags |= 8;
        curFlags |= 0x10;
        return curFlags |= 0x200;
    }
}

