/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.XImages;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import com.xm.ui.widget.XImages.XImagesListAdapter;
import com.xm.ui.widget.listener.OnSelectedImageListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class XImagesGridViewAdt
extends BaseAdapter {
    int mIndex = 0;
    final int SELECTED_ALPHA = 196;
    OnSelectedImageListener mListener;
    Context mContext;
    int mStartIndex;
    int mCount = 0;
    XImagesListAdapter mAdt;
    GridView mGirView;
    int N_COLUM_COUNT;
    int mItemSize;

    public XImagesGridViewAdt(GridView girView, XImagesListAdapter adt, Context context, int nColumCount, int nItemSize) {
        this.mGirView = girView;
        this.mContext = context;
        this.mAdt = adt;
        this.N_COLUM_COUNT = nColumCount;
        this.mItemSize = nItemSize;
    }

    public int Update(int nStartIndex, int nCount) {
        if (nStartIndex != this.mStartIndex || this.mCount != nCount) {
            int imagesHeight;
            this.mStartIndex = nStartIndex;
            this.mCount = nCount;
            ViewGroup.LayoutParams para = this.mGirView.getLayoutParams();
            para.height = imagesHeight = (nCount + this.N_COLUM_COUNT - 1) / this.N_COLUM_COUNT * this.mItemSize;
            this.mGirView.setLayoutParams(para);
            this.notifyDataSetChanged();
            return 1;
        }
        return 0;
    }

    public void SetSelectedListener(OnSelectedImageListener listener) {
        this.mListener = listener;
    }

    public static Bitmap LoadImage(String url) {
        try {
            FileInputStream fis = new FileInputStream(url);
            return BitmapFactory.decodeStream((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap LoadImage(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        opts.inSampleSize = XImagesGridViewAdt.GetSampleSize(opts.outWidth, opts.outHeight, reqWidth, reqHeight);
        opts.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
    }

    public static int GetSampleSize(int srcWidth, int srcHeight, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (srcHeight > reqHeight || srcWidth > reqWidth) {
            inSampleSize = srcWidth > srcHeight ? Math.round((float)srcHeight / (float)reqHeight) : Math.round((float)srcWidth / (float)reqWidth);
        }
        return inSampleSize;
    }

    public int getCount() {
        return this.mCount;
    }

    public int getStartIndex() {
        return this.mStartIndex;
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int nPosition, View view, ViewGroup viewgroup) {
        View iv = this.mAdt.getView(this.mStartIndex, nPosition, view, viewgroup);
        return iv;
    }
}

