/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import demo.xm.com.libxmfunsdk.R;

public class MoreSelectSwitchV2
extends View
implements View.OnTouchListener {
    private static final int SWITCH_DEFAULT_COUNT = 3;
    private Paint paint;
    private int switchCount = 3;
    private int openColorId;
    private int closeColorId;
    private int switchState = 0;
    private int itemWidth;
    private int height;
    private int width;
    private int xPad;
    private int yPad;
    private float xLeft;
    private float xRight;
    private float moveX;
    private boolean isMoving;
    private OnMoreSelSwitchClickListener onMoreSelSwitchClickListener;

    public MoreSelectSwitchV2(Context context) {
        this(context, null);
    }

    public MoreSelectSwitchV2(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MoreSelectSwitchV2(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.MoreSelectSwitch);
        if (params != null) {
            this.switchCount = params.getInteger(R.styleable.MoreSelectSwitch_SwitchCount, 3);
            this.openColorId = params.getResourceId(R.styleable.MoreSelectSwitch_OpenColor, context.getResources().getColor(R.color.theme_color));
            this.closeColorId = params.getResourceId(R.styleable.MoreSelectSwitch_CloseColor, context.getResources().getColor(R.color.line_color));
            params.recycle();
        }
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.setOnTouchListener(this);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setColor(-16777216);
        canvas.drawRect(new RectF(this.xLeft, (float)(this.height / 2 - 4), (float)(this.width - this.itemWidth / 2), (float)(this.height / 2 + 4)), this.paint);
        canvas.drawRect(new RectF((float)(this.itemWidth / 2 + 8), (float)(this.height / 2 - 16), (float)(this.itemWidth / 2 + 12), (float)(this.height / 2 + 16)), this.paint);
        canvas.drawRect(new RectF((float)(this.width / 2 - 4), (float)(this.height / 2 - 16), (float)(this.width / 2), (float)(this.height / 2 + 16)), this.paint);
        canvas.drawRect(new RectF((float)(this.width - this.itemWidth / 2 - 12), (float)(this.height / 2 - 16), this.xRight, (float)(this.height / 2 + 16)), this.paint);
        this.paint.setColor(this.openColorId);
        int radius = this.itemWidth / 5;
        if (this.isMoving) {
            canvas.drawCircle(this.moveX, (float)(this.height / 2), (float)radius, this.paint);
        } else {
            canvas.drawCircle((float)(this.switchState * this.itemWidth + this.itemWidth / 2), (float)(this.height / 2), (float)radius, this.paint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.xPad = this.getPaddingLeft() + this.getPaddingRight();
        this.yPad = this.getPaddingTop() + this.getPaddingBottom();
        this.height = this.getMeasuredHeight();
        this.width = ((this.height - this.yPad) * this.switchCount + this.xPad) * 2;
        this.itemWidth = this.width / this.switchCount;
        this.xLeft = (float)this.itemWidth / 2.0f;
        this.xRight = (float)this.width - (float)this.itemWidth / 2.0f - 8.0f;
        this.setMeasuredDimension(this.width, this.height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public int getSwitchCount() {
        return this.switchCount;
    }

    public void setSwitchCount(int switchCount) {
        this.switchCount = switchCount;
        this.width = (this.height - this.yPad) * switchCount + this.xPad;
        this.itemWidth = this.width / switchCount;
        if (this.width > 0) {
            this.getLayoutParams().width = this.width;
            this.requestLayout();
        }
        this.postInvalidate();
    }

    public int getSwitchState() {
        return this.switchState;
    }

    public void setSwitchState(int switchState) {
        this.switchState = switchState % this.switchCount;
        this.postInvalidate();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int beforeSwitchState = this.switchState++;
        switch (motionEvent.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                this.isMoving = true;
                this.moveX = Math.max(this.xLeft, motionEvent.getX());
                this.moveX = Math.min(this.moveX, this.xRight);
                this.postInvalidate();
                break;
            }
            case 1: 
            case 3: {
                this.isMoving = false;
                this.switchState = this.switchCount >= 3 ? (int)(this.moveX / (float)this.itemWidth) : (this.switchState %= this.switchCount);
                this.postInvalidate();
                if (this.onMoreSelSwitchClickListener == null) break;
                this.onMoreSelSwitchClickListener.onMoreClick(this, this.switchCount, beforeSwitchState, this.switchState);
                break;
            }
        }
        return true;
    }

    public void setOnMoreSelSwitchClickListener(OnMoreSelSwitchClickListener listener) {
        this.onMoreSelSwitchClickListener = listener;
    }

    public static interface OnMoreSelSwitchClickListener {
        public void onMoreClick(View var1, int var2, int var3, int var4);
    }
}

