/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.lib.FunSDK;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private int mOrientation = 1;
    private int mItemSize = 1;
    private Paint mPaint;

    public DividerItemDecoration(Context context, int orientation) {
        this.mOrientation = orientation;
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException(FunSDK.TS((String)"Please pass in the correct parameters"));
        }
        this.mItemSize = (int)TypedValue.applyDimension((int)this.mItemSize, (float)1.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mPaint = new Paint(1);
        this.mPaint.setColor(Color.parseColor((String)"#e8e9ec"));
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    private void drawVertical(Canvas canvas, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getMeasuredWidth() - parent.getPaddingRight();
        int childSize = parent.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + layoutParams.bottomMargin;
            int bottom = top + this.mItemSize;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    private void drawHorizontal(Canvas canvas, RecyclerView parent) {
        int top = parent.getPaddingTop();
        int bottom = parent.getMeasuredHeight() - parent.getPaddingBottom();
        int childSize = parent.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + layoutParams.rightMargin;
            int right = left + this.mItemSize;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            outRect.set(0, 0, 0, this.mItemSize);
        } else {
            outRect.set(0, 0, this.mItemSize, 0);
        }
    }
}

