/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;

public class AnimationsTextView
extends TextView
implements Animator.AnimatorListener {
    public static final int DIRECTION_LEFT_INTO = 0;
    public static final int DIRECTION_TOP_INTO = 1;
    public static final int DIRECTION_RIGHT_INTO = 2;
    public static final int DIRECTION_BOTTOM_INTO = 3;
    private AnimatorSet mAnimatorSet;
    private ObjectAnimator mAnimator;
    private int mDirection = 3;
    private boolean mIsInit;

    public AnimationsTextView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public AnimationsTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public AnimationsTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.initAttributes(attrs, defStyle);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.AnimationsView, defStyle, 0);
        this.mDirection = typedArray.getInteger(R.styleable.AnimationsView_direction, 3);
        typedArray.recycle();
    }

    private void initAnimation() {
        ViewGroup viewGroup;
        if (null == this.mAnimatorSet) {
            this.mAnimatorSet = new AnimatorSet();
            this.mAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            if (this.mDirection == 3) {
                this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{this.getHeight(), 0.0f});
            } else if (this.mDirection == 2) {
                this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{this.getWidth(), 0.0f});
            } else if (this.mDirection == 1) {
                this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{this.getHeight() * -1, 0.0f});
            } else if (this.mDirection == 0) {
                this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{this.getWidth() * -1, 0.0f});
            }
            this.mAnimator.addListener((Animator.AnimatorListener)this);
            this.mAnimatorSet.play((Animator)this.mAnimator);
        }
        if (null != (viewGroup = (ViewGroup)this.getParent())) {
            int position = this.getViewPosition(viewGroup);
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            viewGroup.removeView((View)this);
            LinearLayout ll = new LinearLayout(this.getContext());
            ll.addView((View)this);
            viewGroup.addView((View)ll, position, lp);
        }
        this.mAnimatorSet.setDuration(800L);
        this.mAnimatorSet.setStartDelay(100L);
        this.mAnimatorSet.start();
        this.mIsInit = true;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public void startAnimation() {
        if (null != this.mAnimatorSet) {
            this.mAnimatorSet.setStartDelay(0L);
            this.mAnimatorSet.start();
        }
    }

    public void stopAnimation() {
        if (null != this.mAnimatorSet) {
            this.mAnimatorSet.cancel();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mIsInit && visibility == 0) {
            this.startAnimation();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && !this.mIsInit) {
            this.initAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void onAnimationStart(Animator animator) {
        this.setVisibility(0);
    }

    public void onAnimationEnd(Animator animator) {
    }

    public void onAnimationCancel(Animator animator) {
    }

    public void onAnimationRepeat(Animator animator) {
    }

    private int getViewPosition(ViewGroup viewGroup) {
        int position;
        for (position = 0; position < viewGroup.getChildCount() && viewGroup.getChildAt(position) != this; ++position) {
        }
        return position;
    }
}

