/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.media.image;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.view.GestureDetectorCompat;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.manager.device.fisheye.FishEyeParams;
import com.manager.device.fisheye.FishEyeVidType;
import com.utils.XUtils;
import com.vatics.dewarp.FecCenter;
import com.vatics.dewarp.GL2JNIView;
import com.xm.ui.widget.SwitchFishEyeView;
import com.xmgl.vrsoft.VRSoftGLView;
import demo.xm.com.libxmfunsdk.R;
import java.io.File;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class XMVrImageView
extends RelativeLayout {
    private static final String TAG = "DisplayImageView";
    public static final int GENERAL_PICTURE = 0;
    public static final int FISH_EYE_PICTURE = 1;
    private String filePath;
    private VRSoftGLView mVRSoftGLView;
    private ImageView mImageView;
    private boolean hasGestureOperate;
    private FishEyeParams fishEyeParams;
    private FecCenter fecCenter = null;
    private int mType = -1;
    private boolean showImageSuccess = false;
    private int mDefaultBackground;
    private boolean isVrSoftInit;
    private SwitchFishEyeView switchFishEyeView;
    private GestureDetectorCompat gestureDetector;
    private ImageViewGestureDetector imageViewGestureDetector;
    private boolean hideSwitchFishEyeView;
    private OnViewSimpleGestureListener simpleGestureLs;

    public XMVrImageView(Context context) {
        this(context, null);
    }

    public XMVrImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMVrImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.DisplayImageView);
        this.mDefaultBackground = array.getResourceId(R.styleable.DisplayImageView_default_background, 17170443);
        this.init(this.getContext());
        array.recycle();
    }

    private void init(Context context) {
        this.imageViewGestureDetector = new ImageViewGestureDetector();
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.imageViewGestureDetector);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(13);
        this.mVRSoftGLView = new VRSoftGLView(context);
        this.mVRSoftGLView.setmGestureListener((GestureDetector.OnGestureListener)this.imageViewGestureDetector);
        this.addView((View)this.mVRSoftGLView, (ViewGroup.LayoutParams)params);
        this.mImageView = new ImageView(context);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)params);
        this.mImageView.setVisibility(8);
        this.mVRSoftGLView.setVisibility(8);
        this.mVRSoftGLView.setRendererCallback(new GLSurfaceView.Renderer(){

            public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            }

            public void onSurfaceChanged(GL10 gl, int width, int height) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        XMVrImageView.this.drawImage();
                    }
                });
                XMVrImageView.this.isVrSoftInit = true;
            }

            public void onDrawFrame(GL10 gl) {
            }
        });
    }

    private void initFishCtrlLayout() {
        if (this.switchFishEyeView == null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(9);
            params.addRule(12);
            this.switchFishEyeView = new SwitchFishEyeView(this.getContext(), this.mVRSoftGLView);
            this.addView((View)this.switchFishEyeView, (ViewGroup.LayoutParams)params);
        }
        if (this.mVRSoftGLView.getType() == 1) {
            this.switchFishEyeView.init180VR(false);
        } else if (this.mVRSoftGLView.getType() == 0) {
            this.switchFishEyeView.init360VR();
        }
        this.switchFishEyeView.setVisibility(this.hideSwitchFishEyeView ? 8 : 0);
    }

    public void hideSwitchFishEyeView(boolean hide) {
        this.hideSwitchFishEyeView = hide;
    }

    public void onResume() {
        if (null != this.mVRSoftGLView) {
            this.mVRSoftGLView.onResume();
        }
    }

    public void onPause() {
        if (null != this.mVRSoftGLView) {
            this.mVRSoftGLView.onPause();
        }
    }

    private void drawImage() {
        File file;
        if (this.filePath != null && !this.filePath.equals("") && (file = new File(this.filePath)).exists()) {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = XUtils.decodeFile(this.getContext(), this.filePath, opts);
            if (null != bitmap) {
                this.setShowImageSuccess(true);
                if (this.mType == 0) {
                    this.mImageView.setImageBitmap(bitmap);
                } else if (this.mType == 1 && this.mVRSoftGLView != null && this.mVRSoftGLView.hasReady()) {
                    int viewSize;
                    if (this.fishEyeParams.hasOffset()) {
                        this.fecCenter = new FecCenter(this.fishEyeParams.imageWidth, this.fishEyeParams.imageHeight, this.fishEyeParams.xCenter, this.fishEyeParams.yCenter, this.fishEyeParams.radius);
                    }
                    if (this.fishEyeParams.getVidType() == FishEyeVidType.GENERAL_180VR) {
                        this.mVRSoftGLView.setType(1);
                        this.mVRSoftGLView.setFecParams(GL2JNIView.FecType.GENERAL_180VR, this.fecCenter);
                    } else if (this.fishEyeParams.getVidType() == FishEyeVidType.GENERAL_360VR) {
                        this.mVRSoftGLView.setType(0);
                        this.mVRSoftGLView.setFecParams(GL2JNIView.FecType.GENERAL_360VR, this.fecCenter);
                    }
                    this.mVRSoftGLView.setNewBitmap(bitmap);
                    this.initFishCtrlLayout();
                    ViewGroup.LayoutParams layoutParams = this.mVRSoftGLView.getLayoutParams();
                    layoutParams.height = viewSize = Math.min(this.getWidth(), this.getHeight());
                    layoutParams.width = viewSize;
                    this.mVRSoftGLView.requestLayout();
                }
                return;
            }
        }
        this.mImageView.setImageResource(this.mDefaultBackground);
        this.setShowImageSuccess(false);
    }

    public void setFishEyeParams(FishEyeParams params) {
        this.fishEyeParams = params;
    }

    public void setImagePath(String filePath) {
        this.showImageSuccess = false;
        this.filePath = filePath;
        SDK_FishEyeFrame fishFrame = FunSDK.JPGHead_Read_Exif((String)filePath);
        if (null == fishFrame) {
            this.mType = 0;
            this.mImageView.setVisibility(0);
            this.mVRSoftGLView.setVisibility(8);
            this.mVRSoftGLView.cleanUp();
            this.drawImage();
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            this.requestLayout();
        } else {
            this.mImageView.setVisibility(8);
            this.mVRSoftGLView.setVisibility(0);
            this.mType = 1;
            this.setFishEyeParams(new FishEyeParams(fishFrame));
            if (this.isVrSoftInit) {
                this.drawImage();
            }
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).setBackgroundColor(-16777216);
            }
        }
    }

    public void updateImagePath(String filePath) {
        SDK_FishEyeFrame fishFrame = FunSDK.JPGHead_Read_Exif((String)filePath);
        if (null == fishFrame) {
            this.mType = 0;
            this.mImageView.setVisibility(0);
            this.mVRSoftGLView.setVisibility(8);
            this.drawImage();
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            this.requestLayout();
        } else {
            this.mImageView.setVisibility(8);
            this.mVRSoftGLView.setVisibility(0);
            this.mType = 1;
            this.setFishEyeParams(new FishEyeParams(fishFrame));
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = this.getHeight();
            layoutParams.width = this.getHeight();
            this.requestLayout();
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).setBackgroundColor(-16777216);
            }
        }
        if (!StringUtils.contrast(this.filePath, filePath)) {
            this.filePath = filePath;
            this.drawImage();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isHasGestureOperate()) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.gestureDetector != null) {
            return this.gestureDetector.onTouchEvent(ev);
        }
        return true;
    }

    public boolean isHasGestureOperate() {
        return this.hasGestureOperate;
    }

    public void setHasGestureOperate(boolean hasGestureOperate) {
        this.hasGestureOperate = hasGestureOperate;
    }

    public ImageView getGeneralImageView() {
        return this.mImageView;
    }

    public boolean isShowImageSuccess() {
        return this.showImageSuccess;
    }

    public void setShowImageSuccess(boolean showImageSuccess) {
        this.showImageSuccess = showImageSuccess;
    }

    public void setDefaultBackground(int resId) {
        if (resId < 0) {
            return;
        }
        this.mDefaultBackground = resId;
        this.mImageView.setImageResource(this.mDefaultBackground);
    }

    public void setResource(Bitmap src) {
        this.mType = 0;
        if (this.mImageView == null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            this.mImageView = new ImageView(this.getContext());
            this.addView((View)this.mImageView, (ViewGroup.LayoutParams)params);
        } else {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mImageView.getLayoutParams();
            params.height = -1;
            params.width = -1;
            this.requestLayout();
        }
        this.mImageView.setVisibility(0);
        this.mImageView.setImageBitmap(src);
        if (this.mVRSoftGLView != null) {
            this.mVRSoftGLView.setVisibility(8);
        }
        if (this.switchFishEyeView != null) {
            this.switchFishEyeView.setVisibility(8);
        }
    }

    public void setResource(int resId) {
        this.mType = 0;
        if (this.mImageView == null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            this.mImageView = new ImageView(this.getContext());
            this.addView((View)this.mImageView, (ViewGroup.LayoutParams)params);
        } else {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mImageView.getLayoutParams();
            params.height = -1;
            params.width = -1;
            this.requestLayout();
        }
        this.mImageView.setVisibility(0);
        this.mImageView.setImageResource(resId);
        this.mType = 0;
        this.mImageView.setVisibility(0);
        if (this.mVRSoftGLView != null) {
            this.mVRSoftGLView.setVisibility(8);
        }
        if (this.switchFishEyeView != null) {
            this.switchFishEyeView.setVisibility(8);
        }
    }

    public void closeFishCtrl() {
        if (this.switchFishEyeView != null) {
            this.switchFishEyeView.touchOutSideHidden();
        }
    }

    public void setVisibility(int visibility) {
        if (visibility != 0) {
            if (this.mImageView != null) {
                this.mImageView.setVisibility(8);
            }
            if (this.mVRSoftGLView != null) {
                this.mVRSoftGLView.setVisibility(8);
            }
            if (this.switchFishEyeView != null) {
                this.switchFishEyeView.setVisibility(8);
                this.switchFishEyeView.touchOutSideHidden();
            }
        }
        super.setVisibility(visibility);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.gestureDetector != null) {
            this.gestureDetector.onTouchEvent(event);
        }
        return true;
    }

    public void setOnViewSimpleGestureListener(OnViewSimpleGestureListener ls) {
        this.simpleGestureLs = ls;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public class ImageViewGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapUp(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onSingleTapUp((View)XMVrImageView.this, e);
            }
            return super.onSingleTapUp(e);
        }

        public void onLongPress(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onLongPress((View)XMVrImageView.this, e);
            }
            super.onLongPress(e);
        }

        public boolean onDown(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onDown((View)XMVrImageView.this, e);
            }
            return super.onDown(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                return XMVrImageView.this.simpleGestureLs.onDoubleTap((View)XMVrImageView.this, e);
            }
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onDoubleTapEvent((View)XMVrImageView.this, e);
            }
            XMVrImageView.this.closeFishCtrl();
            return super.onDoubleTapEvent(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onSingleTapConfirmed((View)XMVrImageView.this, e);
            }
            return super.onSingleTapConfirmed(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onFling((View)XMVrImageView.this, e1, e2, velocityX, velocityY);
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (XMVrImageView.this.simpleGestureLs != null) {
                XMVrImageView.this.simpleGestureLs.onScroll((View)XMVrImageView.this, e1, e2, distanceX, distanceY);
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }

    public static interface OnViewSimpleGestureListener {
        public boolean isNeedInterceptTouchEvent(View var1);

        public boolean onTouchEvent(View var1, MotionEvent var2);

        public boolean onSingleTapUp(View var1, MotionEvent var2);

        public void onLongPress(View var1, MotionEvent var2);

        public boolean onDown(View var1, MotionEvent var2);

        public boolean onDoubleTap(View var1, MotionEvent var2);

        public boolean onDoubleTapEvent(View var1, MotionEvent var2);

        public boolean onSingleTapConfirmed(View var1, MotionEvent var2);

        public boolean onFling(View var1, MotionEvent var2, MotionEvent var3, float var4, float var5);

        public boolean onScroll(View var1, MotionEvent var2, MotionEvent var3, float var4, float var5);
    }
}

