/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import androidx.fragment.app.FragmentActivity;
import com.lib.IFunSDKResult;
import com.utils.StatusBarUtils;
import demo.xm.com.libxmfunsdk.R;

public abstract class BaseDlg
implements View.OnClickListener,
IFunSDKResult {
    protected FragmentActivity mActivity;
    protected View mView;
    protected Dialog mDlg;
    protected LayoutInflater mInflater;
    protected static String sEncrypType = "";
    protected static String sAuth = "";

    public BaseDlg() {
    }

    public BaseDlg(FragmentActivity activity, View mView) {
        this.mActivity = activity;
        this.mView = mView;
        this.mInflater = LayoutInflater.from((Context)activity);
    }

    protected ViewGroup GetRootLayout(View rootView) {
        View v;
        ViewGroup layout2 = (ViewGroup)rootView.findViewById(R.id.layoutRoot);
        if (layout2 == null && null != this.mActivity && (v = this.mActivity.getCurrentFocus()) != null) {
            ViewParent vp = v.getParent();
            if (vp == null) {
                layout2 = (ViewGroup)v;
            } else {
                layout2 = (ViewGroup)vp;
                while ((vp = vp.getParent()) != null) {
                    layout2 = (ViewGroup)vp;
                }
            }
        }
        return layout2;
    }

    public void SetShowPsd(View v, int id2) {
        EditText pwd_et = (EditText)v.findViewById(id2);
        if (pwd_et.getTransformationMethod() == null) {
            pwd_et.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        } else {
            pwd_et.setTransformationMethod(null);
        }
        pwd_et.setSelection(pwd_et.getText().toString().length());
    }

    public static void setEncrype(String capabilities) {
        if (capabilities.contains("WPA2") && capabilities.contains("CCMP")) {
            sEncrypType = "AES";
            sAuth = "WPA2";
        } else if (capabilities.contains("WPA2") && capabilities.contains("TKIP")) {
            sEncrypType = "TKIP";
            sAuth = "WPA2";
        } else if (capabilities.contains("WPA") && capabilities.contains("TKIP")) {
            sEncrypType = "TKIP";
            sAuth = "WPA";
        } else if (capabilities.contains("WPA") && capabilities.contains("CCMP")) {
            sEncrypType = "AES";
            sAuth = "WPA";
        } else if (!capabilities.contains("WEP")) {
            sEncrypType = "NONE";
            sAuth = "OPEN";
        }
    }

    protected void initStatusBar(ViewGroup rootLayout) {
        if (this.mDlg == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                StatusBarUtils.setLightStatusBar(this.mDlg, true);
                StatusBarUtils.transparentStatusBar(this.mDlg);
            } else {
                StatusBarUtils.setStatusBarColor(this.mDlg, R.color.black);
            }
            StatusBarUtils.setRootView(rootLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

