/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.main;

import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.xm.activity.base.XMBaseActivity;
import com.xm.activity.base.XMBasePresenter;
import com.xm.activity.device.router.view.SetDevToRouterByQrCodeActivity;
import com.xm.activity.main.devlist.view.XMDeviceListFragment;
import com.xm.ui.widget.ButtonCheck;
import com.xm.ui.widget.XTitleBar;
import demo.xm.com.libxmfunsdk.R;

public class XMMainActivity
extends XMBaseActivity {
    private static final int BOTTOM_TAB_ONE = 0;
    private static final int BOTTOM_TAB_TWO = 1;
    private static final int BOTTOM_TAB_THREE = 2;
    private static final int BOTTOM_TAB_FOUR = 3;
    private Fragment fragmentDeviceList;
    private ButtonCheck btnDevice;
    private ButtonCheck btnMedia;
    private ButtonCheck btnCloud;
    private ButtonCheck btnLocal;
    private XTitleBar xbTitle;
    private FragmentManager fragmentManager;
    private int curSelItem;

    public XMBasePresenter getPresenter() {
        return null;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.funsdk_xm_activity_main);
        this.initView();
        this.initListener();
        this.initData();
    }

    private void initView() {
        this.btnDevice = (ButtonCheck)this.findViewById(R.id.devicelist);
        this.btnMedia = (ButtonCheck)this.findViewById(R.id.media);
        this.btnCloud = (ButtonCheck)this.findViewById(R.id.cloudserver);
        this.btnLocal = (ButtonCheck)this.findViewById(R.id.personal);
        this.xbTitle = (XTitleBar)this.findViewById(R.id.xb_main_title);
    }

    private void initListener() {
        this.xbTitle.setRightTvClick(new XTitleBar.OnRightClickListener(){

            public void onRightClick() {
                XMMainActivity.this.turnToActivity(SetDevToRouterByQrCodeActivity.class);
            }
        });
    }

    private void initData() {
        this.fragmentManager = this.getSupportFragmentManager();
        this.setSelection(0);
    }

    private void setSelection(int index) {
        if (index == 0 && this.btnDevice.getBtnValue() == 1) {
            return;
        }
        if (index == 1 && this.btnMedia.getBtnValue() == 1) {
            return;
        }
        if (index == 2 && this.btnCloud.getBtnValue() == 1) {
            return;
        }
        if (index == 3 && this.btnLocal.getBtnValue() == 1) {
            return;
        }
        this.clearSelection();
        FragmentTransaction transaction = this.getTransaction(this.curSelItem, index);
        this.hideFragments(transaction);
        this.curSelItem = index;
        switch (index) {
            case 0: {
                this.btnDevice.setBtnValue(1);
                if (this.fragmentDeviceList == null) {
                    this.fragmentDeviceList = new XMDeviceListFragment();
                    transaction.add(R.id.content, this.fragmentDeviceList);
                    break;
                }
                transaction.show(this.fragmentDeviceList);
                break;
            }
            case 1: {
                this.btnMedia.setBtnValue(1);
                break;
            }
            case 2: {
                this.btnCloud.setBtnValue(1);
                break;
            }
            case 3: {
                this.btnLocal.setBtnValue(1);
                break;
            }
        }
        transaction.commit();
    }

    private void clearSelection() {
        this.btnDevice.setBtnValue(0);
        this.btnMedia.setBtnValue(0);
        this.btnCloud.setBtnValue(0);
        this.btnLocal.setBtnValue(0);
    }

    private FragmentTransaction getTransaction(int oldSelItem, int curSelItem) {
        FragmentTransaction transaction = this.fragmentManager.beginTransaction();
        if (oldSelItem < curSelItem) {
            transaction.setCustomAnimations(R.anim.quick_right_in, R.anim.quick_left_out);
        } else {
            transaction.setCustomAnimations(R.anim.quick_left_in, R.anim.quick_right_out);
        }
        return transaction;
    }

    private void hideFragments(FragmentTransaction transaction) {
        if (this.fragmentDeviceList != null) {
            transaction.hide(this.fragmentDeviceList);
        }
    }
}

