/*
 * Decompiled with CFR 0.152.
 */
package com.xm.activity.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.manager.XMFunSDKManager;
import com.manager.base.BaseManager;
import com.utils.StatusBarUtils;
import com.utils.XUtils;
import com.xm.activity.base.XMBasePresenter;
import com.xm.ui.widget.XTitleBar;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.dialog.LoadingDialog;
import com.xm.ui.widget.icseelogoview.animcontroller.ICSeeLogoAnimController;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;
import java.io.Serializable;
import pl.droidsonroids.gif.GifImageView;

public abstract class XMBaseActivity<T extends XMBasePresenter>
extends AppCompatActivity
implements XTitleBar.OnLeftClickListener {
    protected T presenter;
    private LoadingDialog waitDialog = null;
    protected int screenWidth;
    protected int screenHeight;
    private boolean isInit;
    public static String aRouterPath;
    protected boolean isModuleFunction;

    public abstract T getPresenter();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(1);
        this.screenWidth = XUtils.getScreenWidth((Activity)this);
        this.screenHeight = XUtils.getScreenHeight((Activity)this);
        Intent intent = this.getIntent();
        String devId = intent.getStringExtra("devId");
        this.presenter = this.getPresenter();
        if (this.presenter == null) {
            class SimplePresenter
            extends XMBasePresenter {
                SimplePresenter() {
                }

                protected BaseManager getManager() {
                    return null;
                }
            }
            this.presenter = new SimplePresenter();
        }
        ((XMBasePresenter)this.presenter).setDevId(devId);
        ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.CREATE);
    }

    protected void onResume() {
        super.onResume();
        if (this.presenter != null) {
            ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.START);
        }
        if (!this.isInit) {
            if (XMFunSDKManager.getInstance().isXMStatusBar()) {
                this.initStatusBar();
            }
            try {
                boolean isSupport;
                ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
                if (appInfo.metaData != null && appInfo.metaData.containsKey("Support_XM_Language") && (isSupport = appInfo.metaData.getBoolean("Support_XM_Language"))) {
                    this.initXMLanguage(this.getRootLayout());
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            this.isInit = true;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.presenter != null) {
            ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.STOP);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.presenter != null) {
            ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.STOP);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            ((XMBasePresenter)this.presenter).setLifeCycle(XMBasePresenter.LIFE_CYCLE.DESTROY);
        }
    }

    public void onLeftclick() {
        this.finish();
    }

    protected String translation(String content) {
        return FunSDK.TS((String)content);
    }

    public void showToast(String content, int duration) {
        Toast.makeText((Context)this, (CharSequence)content, (int)duration).show();
    }

    public void showWaitDialog() {
        this.showWaitDialog(this.getString(R.string.waiting));
    }

    public void showWaitDialog(String content) {
        this.showWaitDialog(content, true);
    }

    public void showWaitDialog(String content, boolean isCancel) {
        if (this.waitDialog != null && this.waitDialog.isShowing()) {
            this.waitDialog.show(content);
            return;
        }
        try {
            ICSeeLogoAnimController iAnimController = new ICSeeLogoAnimController();
            iAnimController.createAnim((View)new GifImageView((Context)this));
            this.waitDialog = LoadingDialog.getInstance((Context)this);
            this.waitDialog.setPromptTextColor(this.getResources().getColor(R.color.default_normal_text_color));
            this.waitDialog.embedAnimation((IAnimController)iAnimController);
            this.waitDialog.setCancelable(isCancel);
            this.waitDialog.show(content);
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
    }

    public void hideWaitDialog() {
        if (this.waitDialog != null && ((XMBasePresenter)this.presenter).getLifeCycle() != XMBasePresenter.LIFE_CYCLE.DESTROY) {
            this.waitDialog.dismiss();
        }
    }

    public void turnToActivity(Class _class) {
        Intent intent = new Intent((Context)this, _class);
        if (this.presenter != null && !StringUtils.isStringNULL(((XMBasePresenter)this.presenter).getDevId())) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    public void turnToActivity(Class _class, String key, Bundle data) {
        Intent intent = new Intent((Context)this, _class);
        intent.putExtra(key, data);
        if (this.presenter != null && !StringUtils.isStringNULL(((XMBasePresenter)this.presenter).getDevId())) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    public void turnToActivity(Class _class, Object[][] objects) {
        Intent intent = new Intent((Context)this, _class);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i][1] instanceof Integer) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Integer)objects[i][1]));
                    continue;
                }
                if (objects[i][1] instanceof String) {
                    intent.putExtra((String)objects[i][0], (String)objects[i][1]);
                    continue;
                }
                if (objects[i][1] instanceof Boolean) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Boolean)objects[i][1]));
                    continue;
                }
                if (objects[i][1] instanceof Double) {
                    intent.putExtra((String)objects[i][0], (Serializable)((Double)objects[i][1]));
                    continue;
                }
                if (!(objects[i][1] instanceof Float)) continue;
                intent.putExtra((String)objects[i][0], (Serializable)((Float)objects[i][1]));
            }
        }
        if (this.presenter != null && !StringUtils.isStringNULL(((XMBasePresenter)this.presenter).getDevId())) {
            intent.putExtra("devId", ((XMBasePresenter)this.presenter).getDevId());
        }
        this.startActivity(intent);
    }

    private void initStatusBar() {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                StatusBarUtils.setLightStatusBar((Activity)this, true);
                StatusBarUtils.transparentStatusBar((Activity)this);
            } else {
                StatusBarUtils.setStatusBarColor((Activity)this, R.color.black);
            }
            StatusBarUtils.setRootView((Activity)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initXMLanguage(ViewGroup layout2) {
        if (layout2 == null) {
            return;
        }
        int count = layout2.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = layout2.getChildAt(i);
            if (v instanceof ViewGroup) {
                this.initXMLanguage((ViewGroup)v);
                continue;
            }
            if (!(v instanceof TextView)) continue;
            if (((TextView)v).getText() != null) {
                String text = FunSDK.TS((String)((TextView)v).getText().toString());
                ((TextView)v).setText((CharSequence)text);
            }
            if (((TextView)v).getHint() == null) continue;
            ((TextView)v).setHint((CharSequence)FunSDK.TS((String)((TextView)v).getHint().toString()));
        }
    }

    protected ViewGroup getRootLayout() {
        View v;
        ViewGroup layout2 = (ViewGroup)this.findViewById(R.id.xm_root_layout);
        if (layout2 == null && (v = this.getCurrentFocus()) != null) {
            ViewParent vp = v.getParent();
            if (vp == null) {
                layout2 = (ViewGroup)v;
            } else {
                layout2 = (ViewGroup)vp;
                while ((vp = vp.getParent()) != null) {
                    layout2 = (ViewGroup)vp;
                }
            }
        }
        return layout2;
    }

    protected ViewGroup getRootLayout(View base) {
        View v;
        ViewGroup layout2 = (ViewGroup)base.findViewById(R.id.xm_root_layout);
        if (layout2 == null && (v = this.getCurrentFocus()) != null) {
            ViewParent vp = v.getParent();
            if (vp == null) {
                layout2 = (ViewGroup)v;
            } else {
                layout2 = (ViewGroup)vp;
                while ((vp = vp.getParent()) != null) {
                    layout2 = (ViewGroup)vp;
                }
            }
        }
        return layout2;
    }
}

