/*
 * Decompiled with CFR 0.152.
 */
package com.manager.websocket.pool;

import com.manager.websocket.pool.CacheItem;
import com.manager.websocket.pool.ICachePool;
import com.manager.websocket.pool.ICacheTarget;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseCachePool<T extends ICacheTarget<T>>
implements ICachePool<T>,
Comparator<CacheItem<T>> {
    private ConcurrentHashMap<String, LinkedList<CacheItem<T>>> mPool = new ConcurrentHashMap(8);

    @Override
    public T obtain(String cacheKey) {
        LinkedList<Object> cacheChain = !this.mPool.containsKey(cacheKey) ? new LinkedList() : this.mPool.get(cacheKey);
        if (cacheChain == null) {
            throw new NullPointerException("cacheChain \u7f13\u5b58\u94fe\u521b\u5efa\u5931\u8d25");
        }
        if (cacheChain.size() < this.onSetupMaxCacheCount()) {
            Object cache = this.onCreateCache();
            CacheItem cacheItem = new CacheItem(cache, System.currentTimeMillis());
            cacheChain.add(cacheItem);
            this.mPool.put(cacheKey, cacheChain);
            return cache;
        }
        Collections.sort(cacheChain, this);
        CacheItem cacheItem = (CacheItem)cacheChain.getFirst();
        cacheItem.setRecentlyUsedTime(System.currentTimeMillis());
        ICacheTarget cacheTarget = (ICacheTarget)cacheItem.getCacheTarget();
        cacheTarget = this.onObtainCacheAfter(cacheTarget);
        return (T)cacheTarget;
    }

    @Override
    public T onObtainCacheAfter(ICacheTarget<T> cacheTarget) {
        return (T)((ICacheTarget)cacheTarget.reset());
    }

    @Override
    public int compare(CacheItem<T> o1, CacheItem<T> o2) {
        return Long.compare(o1.getRecentlyUsedTime(), o2.getRecentlyUsedTime());
    }
}

