/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.audio;

import android.media.AudioTrack;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;

public class XMAudioPlayManager {
    public static final int BIT_RATE = 320;
    private int dataSize;
    private int sampleRate = 8000;
    private int audioFormat = 2;
    private int channelConfig = 2;
    private int bufferSizeInBytes = 320;
    private boolean threadExitFlag = false;
    private boolean isPlaying;
    private AudioTrack audioTrack = null;
    private ByteBuffer audioDataBuffer;
    private AudioPlayThread audioPlayThread;
    private OnAudioPlayListener listener;

    public XMAudioPlayManager(@NonNull ByteBuffer audioDataBuffer, int dataSize, OnAudioPlayListener listener) {
        this.audioDataBuffer = ByteBuffer.allocate(audioDataBuffer.capacity());
        this.audioDataBuffer.put(audioDataBuffer.array());
        this.audioDataBuffer.flip();
        this.dataSize = dataSize;
        this.listener = listener;
    }

    public void initAudio(int sampleRate, int audioFormat, int channelConfig) {
        if (sampleRate > 0) {
            this.sampleRate = sampleRate;
        }
        this.audioFormat = audioFormat;
        this.channelConfig = channelConfig;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean startPlay() {
        if (this.isPlaying) {
            return false;
        }
        if (this.audioPlayThread == null) {
            this.audioPlayThread = new AudioPlayThread();
            return this.audioPlayThread.startPlay();
        }
        return false;
    }

    public void stopPlay() {
        if (this.audioPlayThread != null) {
            this.audioPlayThread.stopPlay();
            this.audioPlayThread = null;
        }
    }

    public static interface OnAudioPlayListener {
        public void onPlayTime(int var1);

        public void onPlayCompleted();
    }

    class AudioPlayThread
    extends Thread {
        AudioPlayThread() {
        }

        public synchronized boolean startPlay() {
            if (XMAudioPlayManager.this.audioDataBuffer == null || XMAudioPlayManager.this.dataSize <= 0) {
                return false;
            }
            try {
                XMAudioPlayManager.this.threadExitFlag = false;
                int minBufSize = AudioTrack.getMinBufferSize((int)XMAudioPlayManager.this.sampleRate, (int)XMAudioPlayManager.this.channelConfig, (int)XMAudioPlayManager.this.audioFormat);
                XMAudioPlayManager.this.audioTrack = new AudioTrack(3, XMAudioPlayManager.this.sampleRate, XMAudioPlayManager.this.channelConfig, XMAudioPlayManager.this.audioFormat, minBufSize, 1);
                if (XMAudioPlayManager.this.audioTrack.getState() == 0) {
                    return false;
                }
                if (XMAudioPlayManager.this.bufferSizeInBytes == 0) {
                    XMAudioPlayManager.this.bufferSizeInBytes = minBufSize;
                }
                float maxVol = AudioTrack.getMaxVolume();
                XMAudioPlayManager.this.audioTrack.setStereoVolume(maxVol, maxVol);
                XMAudioPlayManager.this.audioTrack.play();
                XMAudioPlayManager.this.isPlaying = true;
                super.start();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public synchronized void stopPlay() {
            XMAudioPlayManager.this.threadExitFlag = true;
            XMAudioPlayManager.this.isPlaying = false;
            if (XMAudioPlayManager.this.audioTrack != null) {
                XMAudioPlayManager.this.audioTrack.stop();
            }
        }

        @Override
        public void run() {
            if (null == XMAudioPlayManager.this.audioTrack) {
                XMAudioPlayManager.this.isPlaying = false;
                return;
            }
            try {
                byte[] audioData = new byte[XMAudioPlayManager.this.bufferSizeInBytes];
                long startPlayTimes = System.currentTimeMillis();
                for (int writeSize = 0; !XMAudioPlayManager.this.threadExitFlag && writeSize < XMAudioPlayManager.this.dataSize && writeSize + XMAudioPlayManager.this.bufferSizeInBytes < XMAudioPlayManager.this.audioDataBuffer.capacity(); writeSize += XMAudioPlayManager.this.bufferSizeInBytes) {
                    XMAudioPlayManager.this.audioDataBuffer.get(audioData, 0, XMAudioPlayManager.this.bufferSizeInBytes);
                    XMAudioPlayManager.this.audioTrack.write(audioData, 0, XMAudioPlayManager.this.bufferSizeInBytes);
                    if (XMAudioPlayManager.this.listener == null) continue;
                    XMAudioPlayManager.this.listener.onPlayTime((int)((System.currentTimeMillis() - startPlayTimes) / 1000L));
                }
                if (XMAudioPlayManager.this.audioTrack != null) {
                    if (XMAudioPlayManager.this.audioTrack.getState() == 3) {
                        XMAudioPlayManager.this.audioTrack.stop();
                    }
                    XMAudioPlayManager.this.audioTrack.release();
                    XMAudioPlayManager.this.audioTrack = null;
                }
                XMAudioPlayManager.this.audioDataBuffer.clear();
                XMAudioPlayManager.this.audioPlayThread = null;
                if (XMAudioPlayManager.this.listener != null) {
                    XMAudioPlayManager.this.listener.onPlayCompleted();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            XMAudioPlayManager.this.isPlaying = false;
        }
    }
}

