/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.OPScaleTimesSwitch;
import com.lib.sdk.bean.OPSensorSwitch;
import com.lib.sdk.bean.SensorInfoBean;
import com.lib.sdk.bean.StringUtils;
import com.manager.device.DeviceManager;
import com.manager.device.config.DevConfigInfo;
import com.manager.device.config.DevConfigManager;
import com.manager.device.config.ISensorManager;
import java.util.ArrayList;
import java.util.HashMap;

public class SensorManager
implements ISensorManager {
    private static SensorManager sensorManager;
    private HashMap<String, DevConfigManager> devConfigManagers;
    private DeviceManager deviceManager = DeviceManager.getInstance();
    private OnSensorChangeListener sensorChangeListener;
    private HashMap<String, ArrayList<Float>> sensorFlMap;
    private HashMap<String, ArrayList<Float>> offsetXMap;
    private HashMap<String, ArrayList<Float>> offsetYMap;

    private SensorManager() {
        this.devConfigManagers = new HashMap();
        this.sensorFlMap = new HashMap();
        this.offsetXMap = new HashMap();
        this.offsetYMap = new HashMap();
    }

    public static synchronized SensorManager getInstance(OnSensorChangeListener listener) {
        if (sensorManager == null) {
            sensorManager = new SensorManager();
        }
        sensorManager.setOnSensorChangeListener(listener);
        return sensorManager;
    }

    private void setOnSensorChangeListener(OnSensorChangeListener listener) {
        this.sensorChangeListener = listener;
    }

    @Override
    public void release() {
        this.sensorChangeListener = null;
    }

    @Override
    public void switchSensor(String devId, int sensorId, int streamType, int chnId) {
        DevConfigManager devConfigManager = !this.devConfigManagers.containsKey(devId) ? this.deviceManager.getDevConfigManager(devId) : this.devConfigManagers.get(devId);
        String configName = this.getFullName("OPSensorSwitch", chnId);
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener(){

            public void onSuccess(String devId, int operationType, Object result) {
                System.out.println("switchSensor:onSuccess");
                if (SensorManager.this.sensorChangeListener != null) {
                    SensorManager.this.sensorChangeListener.onSetSensorResult(devId, true);
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                System.out.println("switchSensor:onFailed:" + errorId);
                if (SensorManager.this.sensorChangeListener != null) {
                    SensorManager.this.sensorChangeListener.onSetSensorResult(devId, false);
                }
            }
        }, new String[0]);
        devConfigInfo2.setJsonName(configName);
        OPSensorSwitch opSensorSwitch = new OPSensorSwitch();
        opSensorSwitch.setSensor(sensorId);
        opSensorSwitch.setStreamType(streamType);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)opSensorSwitch);
        String jsonData = HandleConfigData.getSendData(configName, "0x00000001", jsonArray);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setCmdId(3032);
        devConfigManager.setDevCmd(devConfigInfo2);
    }

    @Override
    public void setScale(String devId, float scale, int chnId) {
        DevConfigManager devConfigManager = !this.devConfigManagers.containsKey(devId) ? this.deviceManager.getDevConfigManager(devId) : this.devConfigManagers.get(devId);
        String configName = this.getFullName("OPSensorSwitch", chnId);
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener(){

            public void onSuccess(String devId, int operationType, Object result) {
                System.out.println("setScale:onSuccess");
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                System.out.println("setScale:onFailed:" + errorId);
            }
        }, new String[0]);
        devConfigInfo2.setJsonName(configName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Times", (Object)Float.valueOf(scale));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        String jsonData = HandleConfigData.getSendData(configName, "0x00000001", jsonArray);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setCmdId(3032);
        devConfigManager.setDevCmd(devConfigInfo2);
    }

    @Override
    public void setScaleTimesSwitch(String devId, int streamType, float scaleOld, final float scale, int chnId, int streamSync) {
        DevConfigManager devConfigManager = !this.devConfigManagers.containsKey(devId) ? this.deviceManager.getDevConfigManager(devId) : this.devConfigManagers.get(devId);
        String configName = this.getFullName("OPScaleTimesSwitch", chnId);
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener(){

            public void onSuccess(String devId, int operationType, Object result) {
                System.out.println("setScaleTimesSwitch:onSuccess");
                if (SensorManager.this.sensorChangeListener != null) {
                    SensorManager.this.sensorChangeListener.onSetScaleResult(devId, scale, true);
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                System.out.println("setScaleTimesSwitch:onFailed:" + errorId);
                if (SensorManager.this.sensorChangeListener != null) {
                    SensorManager.this.sensorChangeListener.onSetScaleResult(devId, scale, false);
                }
            }
        }, new String[0]);
        devConfigInfo2.setJsonName(configName);
        OPScaleTimesSwitch opScaleTimesSwitch = new OPScaleTimesSwitch();
        opScaleTimesSwitch.setStreamType(streamType);
        opScaleTimesSwitch.setTimesOri(scaleOld);
        opScaleTimesSwitch.setTimes(scale);
        opScaleTimesSwitch.setStreamSync(streamSync);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)opScaleTimesSwitch);
        String jsonData = HandleConfigData.getSendData(configName, "0x00000001", jsonArray);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setCmdId(3032);
        devConfigManager.setDevCmd(devConfigInfo2);
    }

    @Override
    public void getSensor(String devId, int streamType, final int chnId) {
        DevConfigManager devConfigManager = !this.devConfigManagers.containsKey(devId) ? this.deviceManager.getDevConfigManager(devId) : this.devConfigManagers.get(devId);
        String configName = this.getFullName("OPSensorGet", chnId);
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener<String>(){

            @Override
            public void onSuccess(String devId, int operationType, String result) {
                SensorInfoBean sensorInfoBean;
                ArrayList sensorInfoBeans;
                HandleConfigData handleConfigData;
                if (!StringUtils.isStringNULL(result) && (handleConfigData = new HandleConfigData()).getDataObj(result, SensorInfoBean.class) && (sensorInfoBeans = (ArrayList)handleConfigData.getObj()) != null && (sensorInfoBean = (SensorInfoBean)sensorInfoBeans.get(0)) != null && SensorManager.this.sensorChangeListener != null) {
                    SensorManager.this.sensorChangeListener.onGetSensorResult(devId, chnId, sensorInfoBean);
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                System.out.println("switchSensor:onFailed:" + errorId);
            }
        }, new String[0]);
        devConfigInfo2.setJsonName(configName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("StreamType", (Object)streamType);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        String jsonData = HandleConfigData.getSendData(configName, "0x00000001", jsonArray);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setCmdId(3034);
        devConfigManager.setDevCmd(devConfigInfo2);
    }

    @Override
    public void getSensorFL(String devId, int chnId) {
        if (this.sensorFlMap != null && this.sensorFlMap.containsKey(devId)) {
            if (this.sensorChangeListener != null) {
                this.sensorChangeListener.onInitSensor(devId, this.sensorFlMap.get(devId));
            }
            return;
        }
        DevConfigManager devConfigManager = !this.devConfigManagers.containsKey(devId) ? this.deviceManager.getDevConfigManager(devId) : this.devConfigManagers.get(devId);
        final String configName = this.getFullName("OPSensorFLGet", chnId);
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(new DeviceManager.OnDevManagerListener<String>(){

            @Override
            public void onSuccess(String devId, int operationType, String result) {
                JSONArray jsonArray;
                JSONObject jsonObject;
                if (!StringUtils.isStringNULL(result) && (jsonObject = JSON.parseObject((String)result)) != null && jsonObject.containsKey((Object)configName) && (jsonArray = jsonObject.getJSONArray(configName)) != null && (jsonObject = jsonArray.getJSONObject(0)) != null && jsonObject.containsKey((Object)"SensorFL")) {
                    String jsonData = jsonObject.getString("SensorFL");
                    ArrayList sensorFLs = (ArrayList)JSON.parseArray((String)jsonData, Float.class);
                    SensorManager.this.sensorFlMap.put(devId, sensorFLs);
                    if (jsonObject.containsKey((Object)"OffsetX")) {
                        String jsonOffsetX = jsonObject.getString("OffsetX");
                        ArrayList offsetX = (ArrayList)JSON.parseArray((String)jsonOffsetX, Float.class);
                        SensorManager.this.offsetXMap.put(devId, offsetX);
                    }
                    if (jsonObject.containsKey((Object)"OffsetY")) {
                        String jsonOffsetY = jsonObject.getString("OffsetY");
                        ArrayList offsetY = (ArrayList)JSON.parseArray((String)jsonOffsetY, Float.class);
                        SensorManager.this.offsetYMap.put(devId, offsetY);
                    }
                    if (SensorManager.this.sensorChangeListener != null) {
                        SensorManager.this.sensorChangeListener.onInitSensor(devId, sensorFLs);
                    }
                }
            }

            @Override
            public void onFailed(String devId, int msgId, String jsonName, int errorId) {
                System.out.println("switchSensor:onFailed:" + errorId);
            }
        }, new String[0]);
        devConfigInfo2.setJsonName(configName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Name", (Object)configName);
        jsonObject.put("SessionID", (Object)"0x00000001");
        devConfigInfo2.setJsonData(jsonObject.toString());
        devConfigInfo2.setCmdId(3034);
        devConfigManager.setDevCmd(devConfigInfo2);
    }

    public String getFullName(String name, int chn) {
        if (chn == -1) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(".").append("[").append(chn).append("]");
        return sb.toString();
    }

    @Override
    public ArrayList<Float> getOffsetX(String devId) {
        if (this.offsetXMap != null && this.offsetXMap.containsKey(devId)) {
            return this.offsetXMap.get(devId);
        }
        return null;
    }

    @Override
    public ArrayList<Float> getOffsetY(String devId) {
        if (this.offsetYMap != null && this.offsetYMap.containsKey(devId)) {
            return this.offsetYMap.get(devId);
        }
        return null;
    }

    public static interface OnSensorChangeListener {
        public void onGetSensorResult(String var1, int var2, SensorInfoBean var3);

        public void onSetSensorResult(String var1, boolean var2);

        public void onInitSensor(String var1, ArrayList<Float> var2);

        public void onSetScaleResult(String var1, float var2, boolean var3);
    }
}

