/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.bind.qrcode.presenter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.DeviceManager;
import com.manager.device.bind.qrcode.contract.QRConfigResultContract;
import com.manager.device.bind.qrcode.serverinteraction.QRConfigServerInteraction;
import com.utils.LogUtils;
import com.utils.MobileInfoUtils;
import com.utils.XUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class QRConfigResultManager
implements QRConfigResultContract.IQRConfigResultPresenter {
    private static final int TIME_OUT = 30;
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String RESULT_CODE = "ret";
    private static final String DEVICE_PID = "pid";
    private static final String DEVICE_TOKEN = "adminToken";
    private static final String DEVICE_IP = "devIp";
    public static final int QR_CONFIG_ERROR_PARSE_DATA = -2;
    public static final int QR_CONFIG_ERROR_NETWORK = -1;
    public static final int QR_CONFIG_SUCCESS = 0;
    private String randomUuid;
    private int timeOut = 30;
    private String serverUrl = "https://pairing.xmcsrv.net/api/";
    private static QRConfigResultManager qrConfigResultManager;
    private DeviceManager.OnDevWiFiSetListener onDevWiFiSetListener;
    private QRConfigServerInteraction serverInteraction;
    private Call<ResponseBody> call;
    private long effectiveTime;

    @Override
    public void initQrConfigServer(String serverUrl) {
        if (serverUrl != null) {
            this.serverUrl = serverUrl;
        }
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        OkHttpClient client = httpBuilder.readTimeout((long)this.timeOut, TimeUnit.SECONDS).connectTimeout((long)this.timeOut, TimeUnit.SECONDS).writeTimeout((long)this.timeOut, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.serverUrl).client(client).build();
        this.serverInteraction = (QRConfigServerInteraction)retrofit.create(QRConfigServerInteraction.class);
    }

    public static synchronized QRConfigResultManager getInstance() {
        if (qrConfigResultManager == null) {
            qrConfigResultManager = new QRConfigResultManager();
        }
        return qrConfigResultManager;
    }

    public void setOnDevWiFiSetListener(DeviceManager.OnDevWiFiSetListener onDevWiFiSetListener) {
        this.onDevWiFiSetListener = onDevWiFiSetListener;
    }

    @Override
    public void getQRConfigDevInfo(String randomUuid) {
        block2: {
            try {
                this.call = this.serverInteraction.getQrAddDevInfo(randomUuid, this.effectiveTime);
                this.call.enqueue(this.createCallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.onDevWiFiSetListener == null) break block2;
                this.onDevWiFiSetListener.onDevWiFiSetState(-2);
            }
        }
    }

    @Override
    public void stopGetQRConfigDevInfo() {
        if (this.call != null && !this.call.isCanceled()) {
            this.call.cancel();
            this.call = null;
        }
    }

    @Override
    public void releaseGetQRConfigDevInfo() {
        this.stopGetQRConfigDevInfo();
        this.randomUuid = null;
        this.onDevWiFiSetListener = null;
    }

    @Override
    public String getQRConfigRandomUuid() {
        if (StringUtils.isStringNULL(this.randomUuid)) {
            this.randomUuid = MobileInfoUtils.getRandomUUID();
            this.effectiveTime = System.currentTimeMillis() / 1000L;
        }
        System.out.println("randomUuid:" + this.randomUuid);
        return this.randomUuid;
    }

    private Callback<ResponseBody> createCallback() {
        return new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                ResponseBody responseBody = (ResponseBody)response.body();
                if (responseBody != null) {
                    try {
                        RequestBody requestBody = call.request().body();
                        String strBody = XUtils.parseParams(requestBody);
                        String requestLog = call.request().url().toString();
                        if (!StringUtils.isStringNULL(strBody)) {
                            requestLog = requestLog + "\nBody----->" + strBody;
                        }
                        String resultData = responseBody.string();
                        LogUtils.debugInfo("[APP_NETWORK_CONFIG->]", "Http-request:" + requestLog);
                        LogUtils.debugInfo("[APP_NETWORK_CONFIG->]", "Http-response:" + resultData);
                        QRConfigResultManager.this.parseResultData(resultData);
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (QRConfigResultManager.this.onDevWiFiSetListener != null) {
                    QRConfigResultManager.this.onDevWiFiSetListener.onDevWiFiSetState(-2);
                }
                QRConfigResultManager.this.stopGetQRConfigDevInfo();
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                if (QRConfigResultManager.this.onDevWiFiSetListener != null) {
                    QRConfigResultManager.this.onDevWiFiSetListener.onDevWiFiSetState(-1);
                }
                QRConfigResultManager.this.stopGetQRConfigDevInfo();
            }
        };
    }

    public boolean parseResultData(String jsonData) throws UnsupportedEncodingException {
        JSONObject jsonObject;
        if (jsonData != null && (jsonObject = JSON.parseObject((String)jsonData)) != null) {
            int ret;
            if (jsonObject.containsKey((Object)RESULT_CODE) && (ret = jsonObject.getIntValue(RESULT_CODE)) != 200) {
                if (this.onDevWiFiSetListener != null) {
                    this.onDevWiFiSetListener.onDevWiFiSetState(ret * -1);
                }
                this.stopGetQRConfigDevInfo();
                return false;
            }
            if (jsonObject.containsKey((Object)SERIAL_NUMBER)) {
                Object devIp;
                Object devToken;
                String devId = jsonObject.getString(SERIAL_NUMBER);
                XMDevInfo xmDevInfo = new XMDevInfo();
                SDBDeviceInfo deviceInfo = new SDBDeviceInfo();
                G.SetValue((byte[])deviceInfo.st_0_Devmac, (String)devId);
                G.SetValue((byte[])deviceInfo.st_4_loginName, (String)"admin");
                if (jsonObject.containsKey((Object)DEVICE_TYPE)) {
                    Object devType = jsonObject.get((Object)DEVICE_TYPE);
                    if (devType instanceof Integer) {
                        deviceInfo.st_7_nType = (Integer)devType;
                    } else if (devType instanceof String) {
                        xmDevInfo.setPid((String)devType);
                    }
                }
                if (jsonObject.containsKey((Object)DEVICE_TOKEN) && (devToken = jsonObject.get((Object)DEVICE_TOKEN)) instanceof String) {
                    deviceInfo.setDevToken((String)devToken);
                }
                if (jsonObject.containsKey((Object)DEVICE_IP) && (devIp = jsonObject.get((Object)DEVICE_IP)) instanceof String) {
                    G.SetValue((byte[])deviceInfo.st_2_Devip, (String)((String)devIp));
                }
                if (jsonObject.containsKey((Object)DEVICE_PID)) {
                    String pid = jsonObject.getString(DEVICE_PID);
                    xmDevInfo.setPid(pid);
                    if (deviceInfo.st_7_nType == 0 && DevDataCenter.getInstance().isLowPowerDevByPid(pid)) {
                        deviceInfo.st_7_nType = 21;
                    }
                }
                xmDevInfo.sdbDevInfoToXMDevInfo(deviceInfo);
                FunSDK.DevSetDevInfoToLocal((String)xmDevInfo.getDevId(), (String)xmDevInfo.getDevUserName(), (String)xmDevInfo.getDevPassword(), (String)xmDevInfo.getDevToken());
                FunSDK.AddLANDevsToCache((byte[])G.ObjToBytes((Object)deviceInfo), (int)1);
                if (this.onDevWiFiSetListener != null) {
                    this.onDevWiFiSetListener.onDevWiFiSetState(0);
                    this.onDevWiFiSetListener.onDevWiFiSetResult(xmDevInfo);
                }
                this.stopGetQRConfigDevInfo();
                return true;
            }
        }
        if (this.onDevWiFiSetListener != null) {
            this.onDevWiFiSetListener.onDevWiFiSetState(-2);
        }
        this.stopGetQRConfigDevInfo();
        return false;
    }
}

