/*
 * Decompiled with CFR 0.152.
 */
package com.manager.account;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.share.OtherShareDevUserBean;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.manager.XMFunSDKManager;
import com.manager.account.AccountInterface;
import com.manager.base.BaseManager;
import com.manager.db.DevDataCenter;
import com.manager.db.DevStateInfo;
import com.manager.db.XMDevInfo;
import com.utils.LogUtils;
import com.utils.XUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseAccountManager
extends BaseManager
implements AccountInterface,
IFunSDKResult {
    private static final int UPDATE_TIME_OUT = 10000;
    private boolean isUpdateCompleted = false;
    protected HashMap<Object, Object> listenerHashMap;
    protected XMFunSDKManager xmFunSDKManager;
    protected int userId;
    protected DevDataCenter devDataCenter;
    private AtomicInteger devStateCallBackNum;
    protected HashMap<Integer, XMDevInfo> tempDevInfoMap;
    protected boolean isLogined = false;
    private List<String> localSortDevList;
    private boolean isSortByLocalDevList;
    private Handler getDevStateTimeOutHandler = new Handler();
    private Runnable getDevStateTimeOut = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicInteger atomicInteger = BaseAccountManager.this.devStateCallBackNum;
            synchronized (atomicInteger) {
                BaseAccountManager.this.devStateCallBackNum.set(0);
                for (Object key : BaseAccountManager.this.listenerHashMap.keySet()) {
                    if (!key.toString().startsWith("5009")) continue;
                    OnDevStateListener listener = (OnDevStateListener)BaseAccountManager.this.listenerHashMap.get(key);
                    if (BaseAccountManager.this.isUpdateCompleted || listener == null) continue;
                    listener.onUpdateCompleted();
                }
            }
        }
    };

    protected BaseAccountManager() {
        this.listenerHashMap = new HashMap();
        this.xmFunSDKManager = XMFunSDKManager.getInstance();
        this.devDataCenter = DevDataCenter.getInstance();
        this.devStateCallBackNum = new AtomicInteger();
        this.tempDevInfoMap = new HashMap();
    }

    protected void parseDevicesInfoFromLocal(byte[] pData) {
        int i;
        this.devDataCenter.getDevList().clear();
        if (null == pData || pData.length <= 0) {
            return;
        }
        SDBDeviceInfo info = new SDBDeviceInfo();
        int nItemLen = G.Sizeof((Object)info);
        int nCount = pData.length / nItemLen;
        Object[] infos = new SDBDeviceInfo[nCount];
        for (i = 0; i < nCount; ++i) {
            infos[i] = new SDBDeviceInfo();
        }
        G.BytesToObj((Object[])infos, (byte[])pData);
        for (i = 0; i < nCount; ++i) {
            String name = G.ToString((byte[])((SDBDeviceInfo)infos[i]).st_1_Devname);
            try {
                G.SetValue((byte[])((SDBDeviceInfo)infos[i]).st_1_Devname, (byte[])name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.devDataCenter.addDev((SDBDeviceInfo)infos[i]);
        }
    }

    protected void parseDevicesInfoFromServer() {
        this.devDataCenter.getDevList().clear();
        String orgJsonData = FunSDK.GetFunStrAttr((int)29);
        try {
            String shareStr;
            JSONObject jsonObject = new JSONObject(orgJsonData);
            LogUtils.debugInfo("orgJsonData", "orgJsonData:" + orgJsonData);
            JSONArray mineArray = jsonObject.optJSONArray("mine");
            if (mineArray != null) {
                this.dealWithMineDevList(mineArray);
            }
            if (!StringUtils.isStringNULL(shareStr = jsonObject.optString("share"))) {
                this.dealWithShareDevList(shareStr);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void dealWithMineDevList(JSONArray jsonArray) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            String port;
            JSONObject tokenObj;
            SDBDeviceInfo sdbDeviceInfo = new SDBDeviceInfo();
            JSONObject itemObj = jsonArray.getJSONObject(i);
            if (itemObj == null) continue;
            String ip = itemObj.optString("ip");
            G.SetValue((byte[])sdbDeviceInfo.st_2_Devip, (String)ip);
            String pid = itemObj.optString("pid");
            sdbDeviceInfo.setPid(pid);
            String type = itemObj.optString("type");
            if (!StringUtils.isStringNULL(type) && XUtils.isInteger(type)) {
                sdbDeviceInfo.st_7_nType = Integer.parseInt(type);
            }
            String sn = itemObj.optString("uuid");
            G.SetValue((byte[])sdbDeviceInfo.st_0_Devmac, (String)sn);
            if (itemObj.has("deviceToken") && (tokenObj = itemObj.optJSONObject("deviceToken")) != null) {
                String adminToken = tokenObj.optString("AdminToken");
                sdbDeviceInfo.setDevToken(adminToken);
            }
            if (!StringUtils.isStringNULL(port = itemObj.optString("port")) && XUtils.isInteger(port)) {
                sdbDeviceInfo.st_6_nDMZTcpPort = Integer.parseInt(port);
            }
            String username = itemObj.optString("username");
            G.SetValue((byte[])sdbDeviceInfo.st_4_loginName, (String)username);
            String devName = itemObj.optString("nickname");
            G.SetValue((byte[])sdbDeviceInfo.st_1_Devname, (String)devName);
            this.devDataCenter.addDev(sdbDeviceInfo);
        }
    }

    private void dealWithShareDevList(String shareStr) {
        List otherShareDevUserBeanList = JSON.parseArray((String)shareStr, OtherShareDevUserBean.class);
        this.devDataCenter.setOtherShareDevUserBeanList(JSON.parseArray((String)shareStr, OtherShareDevUserBean.class));
        for (OtherShareDevUserBean shareDevUserBean : otherShareDevUserBeanList) {
            OtherShareDevUserBean oldShareInfo;
            XMDevInfo xmDevInfo;
            if (!this.devDataCenter.isDevExist(shareDevUserBean.getDevId())) {
                xmDevInfo = new XMDevInfo();
                xmDevInfo.shareDevInfoToXMDevInfo(shareDevUserBean);
                this.devDataCenter.addDev(xmDevInfo);
            } else {
                xmDevInfo = this.devDataCenter.getDevInfo(shareDevUserBean.getDevId());
            }
            if ((oldShareInfo = xmDevInfo.getOtherShareDevUserBean()) == null) continue;
            oldShareInfo.setShareState(shareDevUserBean.getShareState());
        }
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        FunSDK.SysAddDevStateListener((int)this.userId);
        return true;
    }

    @Override
    public void unInit() {
        this.isInit = false;
        FunSDK.SysRemoveDevStateListener((int)this.userId);
        FunSDK.UnRegUser((int)this.userId);
        this.userId = -1;
        if (this.devDataCenter != null) {
            this.devDataCenter.getDevList().clear();
        }
        if (this.listenerHashMap != null) {
            this.listenerHashMap.clear();
        }
        this.xmFunSDKManager.unInit();
        this.devDataCenter.setLoginType(0);
    }

    @Override
    public List<String> getDevList() {
        return this.devDataCenter != null ? this.devDataCenter.getDevList() : null;
    }

    protected void triggeredListener(Message msg, MsgContent ex, boolean bSuccess) {
        OnAccountManagerListener listener;
        if (this.listenerHashMap.size() > 0 && this.listenerHashMap.containsKey(msg.what) && (listener = (OnAccountManagerListener)this.listenerHashMap.get(msg.what)) != null) {
            if (bSuccess) {
                listener.onSuccess(msg.what);
            } else {
                listener.onFailed(msg.what, msg.arg1);
            }
            listener.onFunSDKResult(msg, ex);
        }
    }

    @Override
    public void updateDevStateFromServer(final OnDevStateListener ls, String devId) {
        if (ls != null) {
            this.listenerHashMap.put("5009_" + ls.hashCode(), ls);
            if (devId != null) {
                FunSDK.SysGetDevState((int)this.userId, (String)devId, (int)-1);
                this.isUpdateCompleted = false;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!BaseAccountManager.this.isUpdateCompleted) {
                            ls.onUpdateCompleted();
                        }
                    }
                }, 10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllDevStateFromServer(List<String> devIdList, OnDevStateListener ls) {
        AtomicInteger atomicInteger = this.devStateCallBackNum;
        synchronized (atomicInteger) {
            if (ls != null) {
                this.listenerHashMap.put("5009_" + ls.hashCode(), ls);
                if (devIdList != null && !devIdList.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String devId : devIdList) {
                        if (StringUtils.isStringNULL(devId)) continue;
                        sb.append(devId + ";");
                        this.devStateCallBackNum.incrementAndGet();
                    }
                    FunSDK.SysGetDevState((int)this.userId, (String)sb.toString(), (int)this.devStateCallBackNum.get());
                    this.isUpdateCompleted = false;
                    this.getDevStateTimeOutHandler.removeCallbacks(this.getDevStateTimeOut);
                    this.getDevStateTimeOutHandler.postDelayed(this.getDevStateTimeOut, 10000L);
                } else {
                    ls.onUpdateCompleted();
                }
            }
        }
    }

    @Override
    public int getDevState(String devId) {
        XMDevInfo xmDevInfo = this.devDataCenter.getDevInfo(devId);
        if (xmDevInfo != null) {
            return xmDevInfo.getDevState();
        }
        return 0;
    }

    @Override
    public XMDevInfo getDevInfo(String devId) {
        XMDevInfo xmDevInfo = this.devDataCenter.getDevInfo(devId);
        return xmDevInfo;
    }

    @Override
    public int getOnlineDevCount() {
        return this.devDataCenter.getOnlineDevCount();
    }

    @Override
    public void addDev(XMDevInfo xmDevInfo, OnAccountManagerListener ls) {
        this.addDev(xmDevInfo, false, ls);
    }

    @Override
    public void addDev(XMDevInfo xmDevInfo, boolean isUnbindDevUnderOther, OnAccountManagerListener ls) {
        this.listenerHashMap.put(5004, ls);
        this.init();
        if (xmDevInfo != null) {
            int seq = xmDevInfo.getDevId().hashCode();
            this.tempDevInfoMap.put(seq, xmDevInfo);
            SDBDeviceInfo sdbDeviceInfo = xmDevInfo.getSdbDevInfo();
            if (sdbDeviceInfo != null) {
                if (xmDevInfo.getDevType() == 0 && this.devDataCenter.isLowPowerDevByPid(xmDevInfo.getPid())) {
                    sdbDeviceInfo.st_7_nType = 21;
                }
                String devToken = xmDevInfo.getDevToken();
                String szExInfo = "";
                try {
                    if (!StringUtils.isStringNULL(devToken)) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("AdminToken", (Object)devToken);
                        szExInfo = jsonObject.toString();
                    }
                    String szInfo = "";
                    if (isUnbindDevUnderOther) {
                        szInfo = "ma=true&delOth=true";
                        if (!StringUtils.isStringNULL(xmDevInfo.getPid())) {
                            szInfo = szInfo + "&pid=" + xmDevInfo.getPid();
                        }
                    } else if (!StringUtils.isStringNULL(xmDevInfo.getPid())) {
                        szInfo = "pid=" + xmDevInfo.getPid();
                    }
                    if (!StringUtils.isStringNULL(xmDevInfo.getCloudCryNum())) {
                        szInfo = StringUtils.isStringNULL(szInfo) ? "cryNum=" + xmDevInfo.getCloudCryNum() : szInfo + "&cryNum=" + xmDevInfo.getCloudCryNum();
                    }
                    FunSDK.SysAddDevice((int)this.userId, (byte[])G.ObjToBytes((Object)sdbDeviceInfo), (String)szInfo, (String)szExInfo, (int)seq);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.arg1 < 0) {
            this.triggeredListener(msg, ex, false);
            return 0;
        }
        switch (msg.what) {
            case 5000: 
            case 5077: 
            case 5093: {
                if (DevDataCenter.getInstance().isLoginByAccount()) {
                    this.parseDevicesInfoFromServer();
                } else {
                    this.parseDevicesInfoFromLocal(ex.pData);
                }
                this.isLogined = true;
                break;
            }
            case 5071: {
                break;
            }
            case 5009: {
                boolean isOnline;
                String devId = ex.str;
                XMDevInfo xmDevInfo = this.devDataCenter.getDevInfo(devId);
                int state = 0;
                boolean bl = isOnline = msg.arg1 > 0;
                if (xmDevInfo != null) {
                    if (isOnline) {
                        if (this.devDataCenter.isLowPowerDev(xmDevInfo.getDevType()) || this.devDataCenter.isLowPowerDevByPid(xmDevInfo.getPid())) {
                            state = FunSDK.GetDevState((String)devId, (int)8);
                            if (state == 1) {
                                xmDevInfo.setDevState(4);
                            } else if (state == 2) {
                                xmDevInfo.setDevState(2);
                            } else if (state == 3) {
                                xmDevInfo.setDevState(5);
                            } else {
                                xmDevInfo.setDevState(1);
                            }
                            int masterCtrlState = FunSDK.GetDevMasterControlState((String)devId);
                            if (masterCtrlState == 1) {
                                xmDevInfo.setDevMasterCtrlState(4);
                            } else if (masterCtrlState == 2) {
                                if (xmDevInfo.getDevState() == 5) {
                                    xmDevInfo.setDevMasterCtrlState(5);
                                } else if (xmDevInfo.getDevState() == 0) {
                                    xmDevInfo.setDevMasterCtrlState(0);
                                } else {
                                    xmDevInfo.setDevMasterCtrlState(2);
                                }
                            } else {
                                xmDevInfo.setDevMasterCtrlState(-1);
                            }
                        } else {
                            xmDevInfo.setDevState(1);
                            xmDevInfo.setDevMasterCtrlState(-1);
                        }
                    } else {
                        xmDevInfo.setDevState(0);
                        xmDevInfo.setDevMasterCtrlState(-1);
                    }
                    DevStateInfo devStateInfo = xmDevInfo.getDevStateInfo();
                    if (devStateInfo == null) {
                        devStateInfo = new DevStateInfo();
                    }
                    devStateInfo.setDevStateMask(msg.arg1);
                    for (int i = 0; i < 11; ++i) {
                        if ((msg.arg1 >> i & 1) == 1) {
                            devStateInfo.setDevState(i, true);
                            continue;
                        }
                        devStateInfo.setDevState(i, false);
                    }
                    xmDevInfo.setDevStateInfo(devStateInfo);
                }
                AtomicInteger atomicInteger = this.devStateCallBackNum;
                synchronized (atomicInteger) {
                    if (this.devStateCallBackNum.decrementAndGet() <= 0) {
                        Collections.sort(this.devDataCenter.getDevList(), new DeviceComparator());
                        this.devStateCallBackNum.set(0);
                        this.isUpdateCompleted = true;
                    }
                    this.updateDevStateResponse(devId, ex.seq);
                }
                return 0;
            }
            case 5004: {
                if (!this.tempDevInfoMap.containsKey(ex.seq)) break;
                XMDevInfo xmDevInfo = this.tempDevInfoMap.get(ex.seq);
                if (xmDevInfo != null) {
                    FunSDK.DevSetDevInfoToLocal((String)xmDevInfo.getDevId(), (String)xmDevInfo.getDevUserName(), (String)xmDevInfo.getDevPassword(), (String)xmDevInfo.getDevToken());
                    this.devDataCenter.addDev(xmDevInfo);
                    this.updateDevStateFromServer(null, xmDevInfo.getDevId());
                }
                this.tempDevInfoMap.remove(ex.seq);
                break;
            }
            case 5006: {
                XMDevInfo xmDevInfo;
                if (!this.tempDevInfoMap.containsKey(ex.seq) || (xmDevInfo = this.tempDevInfoMap.get(ex.seq)) == null) break;
                this.devDataCenter.removeDev(xmDevInfo.getDevId());
                break;
            }
        }
        this.triggeredListener(msg, ex, true);
        return 0;
    }

    @Override
    public void setLocalSortDevList(List<String> localSortDevList) {
        this.localSortDevList = localSortDevList;
    }

    @Override
    public void setIsSortByLocalDevList(boolean isSort) {
        this.isSortByLocalDevList = isSort;
    }

    @Override
    public void sortDevList(List<String> localSortDevList) {
        this.localSortDevList = localSortDevList;
        Collections.sort(this.devDataCenter.getDevList(), new DeviceComparator());
    }

    @Override
    public void deleteDev(String devSN, OnAccountManagerListener ls) {
        this.listenerHashMap.put(5006, ls);
        this.init();
        if (!StringUtils.isStringNULL(devSN)) {
            int seq = devSN.hashCode();
            XMDevInfo xmDevInfo = this.devDataCenter.getDevInfo(devSN);
            this.tempDevInfoMap.put(seq, xmDevInfo);
            FunSDK.SysDeleteDev((int)this.userId, (String)devSN, (String)"", (String)"", (int)seq);
        }
    }

    public void removeDevStateListener(OnDevStateListener onDevStateListener) {
        if (this.listenerHashMap != null && onDevStateListener != null && this.listenerHashMap.containsKey("5009_" + onDevStateListener.hashCode())) {
            this.listenerHashMap.remove("5009_" + onDevStateListener.hashCode());
        }
    }

    public void updateDevStateResponse(String devId, int seq) {
        for (Object key : this.listenerHashMap.keySet()) {
            if (!key.toString().startsWith("5009")) continue;
            OnDevStateListener listener = (OnDevStateListener)this.listenerHashMap.get(key);
            if (seq == -1) {
                if (listener == null) continue;
                listener.onUpdateDevState(devId);
                listener.onUpdateCompleted();
                continue;
            }
            if (this.isUpdateCompleted) {
                if (listener == null) continue;
                listener.onUpdateCompleted();
                listener.onUpdateDevState(devId);
                continue;
            }
            if (listener == null) continue;
            listener.onUpdateDevState(devId);
        }
    }

    class DeviceComparator
    implements Comparator<String> {
        DeviceComparator() {
        }

        @Override
        public int compare(String devId1, String devId2) {
            int order1 = this.getSortOrdrNum(devId1);
            int order2 = this.getSortOrdrNum(devId2);
            if (order1 < 0 && order2 < 0) {
                int devState1 = BaseAccountManager.this.getDevState(devId1);
                int devState2 = BaseAccountManager.this.getDevState(devId2);
                if (devState1 != 0 && devState2 == 0) {
                    return -1;
                }
                if (devState1 == 0 && devState2 != 0) {
                    return 1;
                }
                return devId1.compareTo(devId2);
            }
            if (order1 >= 0 && order2 < 0) {
                return -1;
            }
            if (order1 < 0 && order1 >= 0) {
                return 1;
            }
            if (order1 < order2) {
                return -1;
            }
            if (order1 > order2) {
                return 1;
            }
            return 0;
        }

        private int getSortOrdrNum(String devId) {
            XMDevInfo xmDevInfo = BaseAccountManager.this.devDataCenter.getDevInfo(devId);
            if (BaseAccountManager.this.isSortByLocalDevList && BaseAccountManager.this.localSortDevList != null) {
                if (xmDevInfo != null) {
                    xmDevInfo.setTempDevLevel(BaseAccountManager.this.localSortDevList.indexOf(devId));
                }
                return xmDevInfo.getTempDevLevel();
            }
            if (xmDevInfo != null) {
                return xmDevInfo.getTempDevLevel();
            }
            return -1;
        }
    }

    public static interface OnDevStateListener {
        public void onUpdateDevState(String var1);

        public void onUpdateCompleted();
    }

    public static interface OnAccountManagerListener {
        public void onSuccess(int var1);

        public void onFailed(int var1, int var2);

        public void onFunSDKResult(Message var1, MsgContent var2);
    }
}

