/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.utils;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.inuker.bluetooth.library.BluetoothContext;
import com.inuker.bluetooth.library.utils.BluetoothLog;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BluetoothUtils {
    private static BluetoothManager mBluetoothManager;
    private static BluetoothAdapter mBluetoothAdapter;
    private static Handler mHandler;

    public static Context getContext() {
        return BluetoothContext.get();
    }

    private static Handler getHandler() {
        if (mHandler == null) {
            mHandler = new Handler(Looper.getMainLooper());
        }
        return mHandler;
    }

    public static void post(Runnable runnable) {
        BluetoothUtils.getHandler().post(runnable);
    }

    public static void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        BluetoothUtils.registerGlobalReceiver(receiver, filter);
    }

    private static void registerGlobalReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        if (Build.VERSION.SDK_INT >= 33) {
            BluetoothUtils.getContext().registerReceiver(receiver, filter, 2);
        } else {
            BluetoothUtils.getContext().registerReceiver(receiver, filter);
        }
    }

    public static void unregisterReceiver(BroadcastReceiver receiver) {
        BluetoothUtils.unregisterGlobalReceiver(receiver);
    }

    private static void unregisterGlobalReceiver(BroadcastReceiver receiver) {
        BluetoothUtils.getContext().unregisterReceiver(receiver);
    }

    public static void sendBroadcast(Intent intent) {
        BluetoothUtils.sendGlobalBroadcast(intent);
    }

    public static void sendBroadcast(String action) {
        BluetoothUtils.sendGlobalBroadcast(new Intent(action));
    }

    private static void sendGlobalBroadcast(Intent intent) {
        BluetoothUtils.getContext().sendBroadcast(intent);
    }

    public static boolean isBleSupported() {
        return Build.VERSION.SDK_INT >= 18 && BluetoothUtils.getContext() != null && BluetoothUtils.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static boolean isBluetoothEnabled() {
        return BluetoothUtils.getBluetoothState() == 12;
    }

    public static int getBluetoothState() {
        BluetoothAdapter adapter = BluetoothUtils.getBluetoothAdapter();
        return adapter != null ? adapter.getState() : 0;
    }

    public static boolean openBluetooth() {
        BluetoothAdapter adapter = BluetoothUtils.getBluetoothAdapter();
        if (adapter != null) {
            return adapter.enable();
        }
        return false;
    }

    public static boolean closeBluetooth() {
        BluetoothAdapter adapter = BluetoothUtils.getBluetoothAdapter();
        if (adapter != null) {
            return adapter.disable();
        }
        return false;
    }

    public static BluetoothManager getBluetoothManager() {
        if (BluetoothUtils.isBleSupported()) {
            if (mBluetoothManager == null) {
                mBluetoothManager = (BluetoothManager)BluetoothUtils.getContext().getSystemService("bluetooth");
            }
            return mBluetoothManager;
        }
        return null;
    }

    public static BluetoothAdapter getBluetoothAdapter() {
        if (mBluetoothAdapter == null) {
            mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return mBluetoothAdapter;
    }

    public static BluetoothDevice getRemoteDevice(String mac) {
        BluetoothAdapter adapter;
        if (!TextUtils.isEmpty((CharSequence)mac) && (adapter = BluetoothUtils.getBluetoothAdapter()) != null) {
            return adapter.getRemoteDevice(mac);
        }
        return null;
    }

    @TargetApi(value=18)
    public static List<BluetoothDevice> getConnectedBluetoothLeDevices() {
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        BluetoothManager manager = BluetoothUtils.getBluetoothManager();
        if (manager != null) {
            devices.addAll(manager.getConnectedDevices(7));
        }
        return devices;
    }

    @TargetApi(value=18)
    public static int getConnectStatus(String mac) {
        BluetoothManager manager = BluetoothUtils.getBluetoothManager();
        if (manager != null) {
            try {
                BluetoothDevice device = BluetoothUtils.getRemoteDevice(mac);
                return manager.getConnectionState(device, 7);
            }
            catch (Throwable e) {
                BluetoothLog.e(e);
            }
        }
        return -1;
    }

    public static int getBondState(String mac) {
        BluetoothManager manager = BluetoothUtils.getBluetoothManager();
        if (manager != null) {
            try {
                BluetoothDevice device = BluetoothUtils.getRemoteDevice(mac);
                return device.getBondState();
            }
            catch (Throwable e) {
                BluetoothLog.e(e);
            }
        }
        return 10;
    }

    public static List<BluetoothDevice> getBondedBluetoothClassicDevices() {
        Set sets;
        BluetoothAdapter adapter = BluetoothUtils.getBluetoothAdapter();
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        if (adapter != null && (sets = adapter.getBondedDevices()) != null) {
            devices.addAll(sets);
        }
        return devices;
    }

    @TargetApi(value=18)
    public static boolean isDeviceConnected(String mac) {
        if (!TextUtils.isEmpty((CharSequence)mac) && BluetoothUtils.isBleSupported()) {
            BluetoothDevice device = BluetoothUtils.getBluetoothAdapter().getRemoteDevice(mac);
            return BluetoothUtils.getBluetoothManager().getConnectionState(device, 7) == 2;
        }
        return false;
    }

    public static boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean refreshGattCache(BluetoothGatt gatt) {
        boolean result = false;
        try {
            Method refresh;
            if (gatt != null && (refresh = BluetoothGatt.class.getMethod("refresh", new Class[0])) != null) {
                refresh.setAccessible(true);
                result = (Boolean)refresh.invoke((Object)gatt, new Object[0]);
            }
        }
        catch (Exception e) {
            BluetoothLog.e(e);
        }
        BluetoothLog.v(String.format("refreshDeviceCache return %b", result));
        return result;
    }
}

