/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.search;

import android.os.Bundle;
import android.os.Parcelable;
import com.inuker.bluetooth.library.connect.response.BleGeneralResponse;
import com.inuker.bluetooth.library.search.BluetoothSearchHelper;
import com.inuker.bluetooth.library.search.BluetoothSearchRequest;
import com.inuker.bluetooth.library.search.SearchRequest;
import com.inuker.bluetooth.library.search.SearchResult;
import com.inuker.bluetooth.library.search.response.BluetoothSearchResponse;

public class BluetoothSearchManager {
    public static void search(SearchRequest request, final BleGeneralResponse response) {
        BluetoothSearchRequest requestWrapper = new BluetoothSearchRequest(request);
        BluetoothSearchHelper.getInstance().startSearch(requestWrapper, new BluetoothSearchResponse(){

            @Override
            public void onSearchStarted() {
                response.onResponse(1, null);
            }

            @Override
            public void onDeviceFounded(SearchResult device) {
                Bundle bundle = new Bundle();
                bundle.putParcelable("extra.search.result", (Parcelable)device);
                response.onResponse(4, bundle);
            }

            @Override
            public void onSearchStopped() {
                response.onResponse(2, null);
            }

            @Override
            public void onSearchCanceled() {
                response.onResponse(3, null);
            }
        });
    }

    public static void stopSearch() {
        BluetoothSearchHelper.getInstance().stopSearch();
    }
}

