/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.channel.packet;

import com.inuker.bluetooth.library.channel.packet.Packet;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ACKPacket
extends Packet {
    public static final int SUCCESS = 0;
    public static final int READY = 1;
    public static final int BUSY = 2;
    public static final int TIMEOUT = 3;
    public static final int CANCEL = 4;
    public static final int SYNC = 5;
    private int status;
    private int seq;

    public ACKPacket(int status) {
        this(status, 0);
    }

    public ACKPacket(int status, int seq) {
        this.status = status;
        this.seq = seq;
    }

    @Override
    public String getName() {
        return "ack";
    }

    public int getStatus() {
        return this.status;
    }

    public int getSeq() {
        return this.seq;
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.wrap(BUFFER);
        buffer.putShort((short)0);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.putShort((short)this.status);
        buffer.putShort((short)this.seq);
        return buffer.array();
    }

    public String toString() {
        return "ACKPacket{status=" + this.getStatusDesc(this.status) + ", seq=" + this.seq + '}';
    }

    private String getStatusDesc(int status) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if ((field.getModifiers() & 0x18) <= 0) continue;
            try {
                if (field.get(null) != Integer.valueOf(status)) continue;
                return field.getName();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return status + "";
    }
}

