/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiFieldError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiGlobalError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiParameterError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class ApiErrorResponseSerializer
extends JsonSerializer<ApiErrorResponse> {
    private final ErrorHandlingProperties properties;

    public ApiErrorResponseSerializer(ErrorHandlingProperties properties) {
        this.properties = properties;
    }

    public void serialize(ApiErrorResponse errorResponse, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<ApiParameterError> list;
        List<ApiGlobalError> globalErrors;
        jsonGenerator.writeStartObject();
        if (this.properties.isHttpStatusInJsonResponse()) {
            jsonGenerator.writeNumberField("status", errorResponse.getHttpStatus().value());
        }
        ErrorHandlingProperties.JsonFieldNames fieldNames = this.properties.getJsonFieldNames();
        jsonGenerator.writeStringField(fieldNames.getCode(), errorResponse.getCode());
        jsonGenerator.writeStringField(fieldNames.getMessage(), errorResponse.getMessage());
        List<ApiFieldError> fieldErrors = errorResponse.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            jsonGenerator.writeArrayFieldStart(fieldNames.getFieldErrors());
            for (ApiFieldError apiFieldError : fieldErrors) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField(fieldNames.getCode(), apiFieldError.getCode());
                jsonGenerator.writeStringField(fieldNames.getMessage(), apiFieldError.getMessage());
                jsonGenerator.writeStringField("property", apiFieldError.getProperty());
                jsonGenerator.writeObjectField("rejectedValue", apiFieldError.getRejectedValue());
                jsonGenerator.writeObjectField("path", (Object)apiFieldError.getPath());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
        if (!(globalErrors = errorResponse.getGlobalErrors()).isEmpty()) {
            jsonGenerator.writeArrayFieldStart(fieldNames.getGlobalErrors());
            for (ApiGlobalError apiGlobalError : globalErrors) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField(fieldNames.getCode(), apiGlobalError.getCode());
                jsonGenerator.writeStringField(fieldNames.getMessage(), apiGlobalError.getMessage());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
        if (!(list = errorResponse.getParameterErrors()).isEmpty()) {
            jsonGenerator.writeArrayFieldStart(fieldNames.getParameterErrors());
            for (ApiParameterError parameterError : list) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField(fieldNames.getCode(), parameterError.getCode());
                jsonGenerator.writeStringField(fieldNames.getMessage(), parameterError.getMessage());
                jsonGenerator.writeStringField("parameter", parameterError.getParameter());
                jsonGenerator.writeObjectField("rejectedValue", parameterError.getRejectedValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
        Map<String, Object> map = errorResponse.getProperties();
        for (String property : map.keySet()) {
            jsonGenerator.writeObjectField(property, map.get(property));
        }
        jsonGenerator.writeEndObject();
    }
}

