/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class DataPacketCryptor {
    private long nativePtr;

    public long getNativeDataPacketCryptor() {
        return this.nativePtr;
    }

    @CalledByNative
    public DataPacketCryptor(long nativeFrameCryptor) {
        this.nativePtr = nativeFrameCryptor;
    }

    public EncryptedPacket encrypt(String participantId, int keyIndex, byte[] data) {
        this.checkDataPacketCryptorExists();
        return DataPacketCryptor.nativeEncrypt(this.nativePtr, participantId, keyIndex, data);
    }

    public byte[] decrypt(String participantId, EncryptedPacket packet) {
        this.checkDataPacketCryptorExists();
        return DataPacketCryptor.nativeDecrypt(this.nativePtr, participantId, packet.keyIndex, packet.payload, packet.iv);
    }

    public void dispose() {
        this.checkDataPacketCryptorExists();
        JniCommon.nativeReleaseRef(this.nativePtr);
        this.nativePtr = 0L;
    }

    private void checkDataPacketCryptorExists() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("DataPacketCryptor has been disposed.");
        }
    }

    private static native EncryptedPacket nativeEncrypt(long var0, String var2, int var3, byte[] var4);

    private static native byte[] nativeDecrypt(long var0, String var2, int var3, byte[] var4, byte[] var5);

    public static class EncryptedPacket {
        public final byte[] payload;
        public final byte[] iv;
        public final int keyIndex;

        @CalledByNative(value="EncryptedPacket")
        public EncryptedPacket(byte[] payload, byte[] iv, int keyIndex) {
            this.payload = payload;
            this.iv = iv;
            this.keyIndex = keyIndex;
        }
    }
}

