/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.KeyRef;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefToken {
    private final String decodedToken;
    private final Integer index;
    private final KeyRef keyRef;
    private static final Pattern DECODED_TILDA_PATTERN = Pattern.compile("~0");
    private static final Pattern DECODED_SLASH_PATTERN = Pattern.compile("~1");
    private static final Pattern DECODED_EQUALS_PATTERN = Pattern.compile("~2");
    private static final Pattern ENCODED_TILDA_PATTERN = Pattern.compile("~");
    private static final Pattern ENCODED_SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern ENCODED_EQUALS_PATTERN = Pattern.compile("=");
    private static final Pattern VALID_ARRAY_IND = Pattern.compile("-|0|(?:[1-9][0-9]*)");
    private static final Pattern VALID_ARRAY_KEY_REF = Pattern.compile("([^=]+)=([^=]+)");

    public RefToken(String decodedToken, Integer arrayIndex, KeyRef arrayKeyRef) {
        if (decodedToken == null) {
            throw new IllegalArgumentException("Token can't be null");
        }
        this.decodedToken = decodedToken;
        this.index = arrayIndex;
        this.keyRef = arrayKeyRef;
    }

    private static String decodePath(Object object) {
        String path = object.toString();
        path = DECODED_SLASH_PATTERN.matcher(path).replaceAll("/");
        path = DECODED_TILDA_PATTERN.matcher(path).replaceAll("~");
        return DECODED_EQUALS_PATTERN.matcher(path).replaceAll("=");
    }

    private static String encodePath(Object object) {
        String path = object.toString();
        path = ENCODED_TILDA_PATTERN.matcher(path).replaceAll("~0");
        path = ENCODED_SLASH_PATTERN.matcher(path).replaceAll("~1");
        return ENCODED_EQUALS_PATTERN.matcher(path).replaceAll("~2");
    }

    public static RefToken parse(String rawToken) {
        if (rawToken == null) {
            throw new IllegalArgumentException("Token can't be null");
        }
        Integer index = null;
        Matcher indexMatcher = VALID_ARRAY_IND.matcher(rawToken);
        if (indexMatcher.matches()) {
            if (indexMatcher.group().equals("-")) {
                index = Integer.MIN_VALUE;
            } else {
                try {
                    int validInt = Integer.parseInt(indexMatcher.group());
                    index = validInt;
                }
                catch (NumberFormatException validInt) {
                    // empty catch block
                }
            }
        }
        KeyRef keyRef = null;
        Matcher arrayKeyRefMatcher = VALID_ARRAY_KEY_REF.matcher(rawToken);
        if (arrayKeyRefMatcher.matches()) {
            keyRef = new KeyRef(RefToken.decodePath(arrayKeyRefMatcher.group(1)), RefToken.decodePath(arrayKeyRefMatcher.group(2)));
        }
        return new RefToken(RefToken.decodePath(rawToken), index, keyRef);
    }

    public boolean isArrayIndex() {
        return this.index != null;
    }

    public boolean isArrayKeyRef() {
        return this.keyRef != null;
    }

    public int getIndex() {
        if (!this.isArrayIndex()) {
            throw new IllegalStateException("Object operation on array index target");
        }
        return this.index;
    }

    public KeyRef getKeyRef() {
        if (!this.isArrayKeyRef()) {
            throw new IllegalStateException("Object operation on array key ref target");
        }
        return this.keyRef;
    }

    public String getField() {
        return this.decodedToken;
    }

    public String toString() {
        if (this.isArrayKeyRef()) {
            return RefToken.encodePath(this.keyRef.key) + "=" + RefToken.encodePath(this.keyRef.value);
        }
        return RefToken.encodePath(this.decodedToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefToken refToken = (RefToken)o;
        return this.decodedToken.equals(refToken.decodedToken);
    }

    public int hashCode() {
        return this.decodedToken.hashCode();
    }
}

