/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.AbstractJsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JacksonVersionException;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.util.Arrays;
import java.util.List;

public final class JsonPointer
extends AbstractJsonPointer {
    public static final JsonPointer ROOT = new JsonPointer(new RefToken[0]);

    private JsonPointer(RefToken[] tokens) {
        super(tokens);
    }

    public JsonPointer(List<RefToken> tokens) {
        super(tokens);
    }

    public static JsonPointer parse(String path) throws IllegalArgumentException {
        List<RefToken> tokens = JsonPointer.parseTokens(path);
        return tokens.isEmpty() ? ROOT : new JsonPointer(tokens);
    }

    public JsonPointer getParent() {
        return this.isRoot() ? this : new JsonPointer(Arrays.copyOf(this.getTokens(), this.getTokens().length - 1));
    }

    public JsonNode evaluate(JsonNode document) throws JsonPointerEvaluationException {
        try {
            JsonNodeWrapper wrappedDocument = JacksonVersionBridge.wrap(document);
            JsonNodeWrapper result = this.evaluate(wrappedDocument);
            return (JsonNode)JacksonVersionBridge.unwrap(result);
        }
        catch (JsonPointerEvaluationException e) {
            throw e;
        }
        catch (JacksonVersionException | IllegalArgumentException e) {
            throw new JsonPointerEvaluationException("Failed to evaluate pointer: " + e.getMessage(), e);
        }
    }

    @Override
    protected AbstractJsonPointer createInstance(RefToken[] tokens) {
        return new JsonPointer(tokens);
    }
}

