/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.AbstractJsonDiff;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JsonNodeFactoryWrapper;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson2.Jackson2NodeFactory;
import java.util.EnumSet;
import java.util.List;

public final class JsonDiff
extends AbstractJsonDiff {
    private static final JsonNodeFactoryWrapper FACTORY = new Jackson2NodeFactory();

    private JsonDiff(EnumSet<DiffFlags> flags) {
        super(flags);
    }

    @Override
    protected JsonPointer getJsonPointerRoot() {
        return JsonPointer.ROOT;
    }

    @Override
    protected JsonPointer createJsonPointerInstance(List<RefToken> tokens) {
        return new JsonPointer(tokens);
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) {
        return JsonDiff.asJson(source, target, DiffFlags.defaults());
    }

    public static JsonNode asJson(JsonNode source, JsonNode target, EnumSet<DiffFlags> flags) {
        JsonNodeWrapper sourceWrapper = JacksonVersionBridge.wrap(source);
        JsonNodeWrapper targetWrapper = JacksonVersionBridge.wrap(target);
        return (JsonNode)JacksonVersionBridge.unwrap(JsonDiff.getJsonNode(sourceWrapper, targetWrapper, new JsonDiff(flags), FACTORY));
    }
}

