/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.AbstractJsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JacksonVersionException;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.util.Arrays;
import java.util.List;
import tools.jackson.databind.JsonNode;

public final class Jackson3JsonPointer
extends AbstractJsonPointer {
    public static final Jackson3JsonPointer ROOT = new Jackson3JsonPointer(new RefToken[0]);

    private Jackson3JsonPointer(RefToken[] tokens) {
        super(tokens);
    }

    public Jackson3JsonPointer(List<RefToken> tokens) {
        super(tokens);
    }

    public static Jackson3JsonPointer parse(String path) throws IllegalArgumentException {
        List<RefToken> tokens = Jackson3JsonPointer.parseTokens(path);
        return tokens.isEmpty() ? ROOT : new Jackson3JsonPointer(tokens);
    }

    public Jackson3JsonPointer getParent() {
        return this.isRoot() ? this : new Jackson3JsonPointer(Arrays.copyOf(this.getTokens(), this.getTokens().length - 1));
    }

    public JsonNode evaluate(JsonNode document) throws JsonPointerEvaluationException {
        try {
            JsonNodeWrapper wrappedDocument = JacksonVersionBridge.wrap(document);
            JsonNodeWrapper result = this.evaluate(wrappedDocument);
            return (JsonNode)JacksonVersionBridge.unwrap(result);
        }
        catch (JsonPointerEvaluationException e) {
            throw e;
        }
        catch (JacksonVersionException | IllegalArgumentException e) {
            throw new JsonPointerEvaluationException("Failed to evaluate pointer: " + e.getMessage(), e);
        }
    }

    @Override
    protected Jackson3JsonPointer createInstance(RefToken[] tokens) {
        return new Jackson3JsonPointer(tokens);
    }
}

