/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.KeyRef;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractJsonPointer {
    private final RefToken[] tokens;
    static final int LAST_INDEX = Integer.MIN_VALUE;

    protected AbstractJsonPointer(RefToken[] tokens) {
        this.tokens = tokens;
    }

    protected AbstractJsonPointer(List<RefToken> tokens) {
        this.tokens = tokens.toArray(new RefToken[0]);
    }

    protected abstract AbstractJsonPointer createInstance(RefToken[] var1);

    public boolean isRoot() {
        return this.tokens.length == 0;
    }

    protected RefToken[] getTokens() {
        return this.tokens;
    }

    protected static List<RefToken> parseTokens(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        StringBuilder reftoken = null;
        ArrayList<RefToken> result = new ArrayList<RefToken>();
        block7: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (i == 0) {
                if (c != '/') {
                    throw new IllegalArgumentException("Missing leading slash");
                }
                reftoken = new StringBuilder();
                continue;
            }
            switch (c) {
                case '~': {
                    if (i + 1 >= path.length()) {
                        throw new IllegalArgumentException("Incomplete escape sequence '~' at end of path");
                    }
                    switch (path.charAt(++i)) {
                        case '0': 
                        case '1': 
                        case '2': {
                            reftoken.append('~');
                            reftoken.append(path.charAt(i));
                            continue block7;
                        }
                    }
                    throw new IllegalArgumentException("Invalid escape sequence ~" + path.charAt(i) + " at index " + i);
                }
                case '/': {
                    result.add(RefToken.parse(reftoken.toString()));
                    reftoken.setLength(0);
                    continue block7;
                }
                default: {
                    reftoken.append(c);
                }
            }
        }
        if (reftoken != null) {
            result.add(RefToken.parse(reftoken.toString()));
        }
        return result;
    }

    AbstractJsonPointer append(String field) {
        RefToken[] newTokens = Arrays.copyOf(this.tokens, this.tokens.length + 1);
        newTokens[this.tokens.length] = new RefToken(field, null, null);
        return this.createInstance(newTokens);
    }

    AbstractJsonPointer append(int index) {
        RefToken[] newTokens = Arrays.copyOf(this.tokens, this.tokens.length + 1);
        newTokens[this.tokens.length] = new RefToken(Integer.toString(index), index, null);
        return this.createInstance(newTokens);
    }

    int size() {
        return this.tokens.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RefToken token : this.tokens) {
            sb.append('/');
            sb.append(token);
        }
        return sb.toString();
    }

    public List<RefToken> decompose() {
        return Arrays.asList((RefToken[])this.tokens.clone());
    }

    public RefToken get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.tokens.length) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        return this.tokens[index];
    }

    public RefToken last() {
        if (this.isRoot()) {
            throw new IllegalStateException("Root pointers contain no reference tokens");
        }
        return this.tokens[this.tokens.length - 1];
    }

    private void error(int atToken, String message, JsonNodeWrapper document) throws JsonPointerEvaluationException {
        throw new JsonPointerEvaluationException(message, this.createInstance(Arrays.copyOf(this.tokens, atToken)), document);
    }

    JsonNodeWrapper evaluate(JsonNodeWrapper document) throws JsonPointerEvaluationException {
        JsonNodeWrapper current = document;
        for (int idx = 0; idx < this.tokens.length; ++idx) {
            RefToken token = this.tokens[idx];
            if (current.isArray()) {
                if (token.isArrayIndex()) {
                    if (token.getIndex() == Integer.MIN_VALUE || token.getIndex() >= current.size()) {
                        this.error(idx, "Array index " + String.valueOf(token) + " is out of bounds", document);
                    }
                    current = current.get(token.getIndex());
                    continue;
                }
                if (token.isArrayKeyRef()) {
                    KeyRef keyRef = token.getKeyRef();
                    JsonNodeWrapper foundArrayNode = null;
                    for (int arrayIdx = 0; arrayIdx < current.size(); ++arrayIdx) {
                        JsonNodeWrapper arrayNode = current.get(arrayIdx);
                        if (!this.matches(keyRef, arrayNode)) continue;
                        foundArrayNode = arrayNode;
                        break;
                    }
                    if (foundArrayNode == null) {
                        this.error(idx, "Array has no matching object for key reference " + String.valueOf(token), document);
                    }
                    current = foundArrayNode;
                    continue;
                }
                this.error(idx, "Can't reference field \"" + token.getField() + "\" on array", document);
                continue;
            }
            if (current.isObject()) {
                if (!current.has(token.getField())) {
                    this.error(idx, "Missing field \"" + token.getField() + "\"", document);
                }
                current = current.get(token.getField());
                continue;
            }
            this.error(idx, "Can't reference past scalar value", document);
        }
        return current;
    }

    private boolean matches(KeyRef keyRef, JsonNodeWrapper arrayNode) {
        boolean matches = false;
        if (arrayNode.has(keyRef.key)) {
            JsonNodeWrapper valueNode = arrayNode.get(keyRef.key);
            if (valueNode.isTextual()) {
                matches = Objects.equals(keyRef.value, valueNode.textValue());
            } else if (valueNode.isNumber() || valueNode.isBoolean()) {
                matches = Objects.equals(keyRef.value, valueNode.toString());
            }
        }
        return matches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJsonPointer that = (AbstractJsonPointer)o;
        return Arrays.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }
}

