/*
 * Decompiled with CFR 0.152.
 */
package com.vicmikhailau.maskededittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.util.AttributeSet;
import android.widget.EditText;
import androidx.appcompat.widget.AppCompatEditText;
import com.vicmikhailau.maskededittext.IFormattedString;
import com.vicmikhailau.maskededittext.MaskedFormatter;
import com.vicmikhailau.maskededittext.MaskedWatcher;
import com.vicmikhailau.maskededittext.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/vicmikhailau/maskededittext/MaskedEditText;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "maskedFormatter", "Lcom/vicmikhailau/maskededittext/MaskedFormatter;", "maskedWatcher", "Lcom/vicmikhailau/maskededittext/MaskedWatcher;", "getMaskedWatcher", "()Lcom/vicmikhailau/maskededittext/MaskedWatcher;", "setMaskedWatcher", "(Lcom/vicmikhailau/maskededittext/MaskedWatcher;)V", "maskString", "", "getMaskString", "()Ljava/lang/String;", "unMaskedText", "getUnMaskedText", "setMask", "", "mMaskStr", "MaskedEditText_release"})
@SourceDebugExtension(value={"SMAP\nMaskedEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaskedEditText.kt\ncom/vicmikhailau/maskededittext/MaskedEditText\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class MaskedEditText
extends AppCompatEditText {
    @Nullable
    private MaskedFormatter maskedFormatter;
    @Nullable
    private MaskedWatcher maskedWatcher;

    public MaskedEditText(@NotNull Context context, @NotNull AttributeSet attrs) {
        String maskStr;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaskedEditText);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        if (typedArray2.hasValue(R.styleable.MaskedEditText_mask) && !((charSequence = (CharSequence)(maskStr = typedArray2.getString(R.styleable.MaskedEditText_mask))) == null || charSequence.length() == 0)) {
            this.setMask(maskStr);
        }
        typedArray2.recycle();
    }

    @Nullable
    public final MaskedWatcher getMaskedWatcher() {
        return this.maskedWatcher;
    }

    public final void setMaskedWatcher(@Nullable MaskedWatcher maskedWatcher) {
        this.maskedWatcher = maskedWatcher;
    }

    @Nullable
    public final String getMaskString() {
        MaskedFormatter maskedFormatter = this.maskedFormatter;
        return maskedFormatter != null ? maskedFormatter.getMaskString() : null;
    }

    @Nullable
    public final String getUnMaskedText() {
        IFormattedString formattedString;
        IFormattedString iFormattedString;
        String currentText;
        Editable editable = this.getText();
        String string = currentText = editable != null ? editable.toString() : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            MaskedFormatter maskedFormatter = this.maskedFormatter;
            iFormattedString = maskedFormatter != null ? maskedFormatter.formatString(it) : null;
        } else {
            iFormattedString = null;
        }
        IFormattedString iFormattedString2 = formattedString = iFormattedString;
        return iFormattedString2 != null ? iFormattedString2.getUnMaskedString() : null;
    }

    public final void setMask(@NotNull String mMaskStr) {
        Intrinsics.checkNotNullParameter((Object)mMaskStr, (String)"mMaskStr");
        this.maskedFormatter = new MaskedFormatter(mMaskStr);
        if (this.maskedWatcher != null) {
            this.removeTextChangedListener(this.maskedWatcher);
        }
        MaskedFormatter maskedFormatter = this.maskedFormatter;
        if (maskedFormatter != null) {
            MaskedFormatter it = maskedFormatter;
            boolean bl = false;
            this.maskedWatcher = new MaskedWatcher(it, (EditText)this);
        }
        this.addTextChangedListener(this.maskedWatcher);
    }
}

