/*
 * Decompiled with CFR 0.152.
 */
package com.vicmikhailau.maskededittext;

import com.vicmikhailau.maskededittext.AbstractFormattedString;
import com.vicmikhailau.maskededittext.Mask;
import com.vicmikhailau.maskededittext.MaskCharacter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/vicmikhailau/maskededittext/FormattedString;", "Lcom/vicmikhailau/maskededittext/AbstractFormattedString;", "mask", "Lcom/vicmikhailau/maskededittext/Mask;", "rawString", "", "<init>", "(Lcom/vicmikhailau/maskededittext/Mask;Ljava/lang/String;)V", "buildRawString", "str", "buildRawString$MaskedEditText_release", "formatString", "formatString$MaskedEditText_release", "MaskedEditText_release"})
public final class FormattedString
extends AbstractFormattedString {
    public FormattedString(@NotNull Mask mask, @NotNull String rawString) {
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
        super(mask, rawString);
    }

    @Override
    @NotNull
    public String buildRawString$MaskedEditText_release(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringBuilder builder = new StringBuilder();
        int inputLen = RangesKt.coerceAtMost((int)this.getMMask().size(), (int)str.length());
        for (int i = 0; i < inputLen; ++i) {
            char ch = str.charAt(i);
            if (this.getMMask().isValidPrepopulateCharacter(ch, i)) continue;
            builder.append(ch);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String formatString$MaskedEditText_release() {
        StringBuilder builder = new StringBuilder();
        int strIndex = 0;
        int maskCharIndex = 0;
        char stringCharacter = '\u0000';
        while (strIndex < this.getInputString().length() && maskCharIndex < this.getMMask().size()) {
            MaskCharacter maskChar = this.getMMask().get(maskCharIndex);
            stringCharacter = this.getInputString().charAt(strIndex);
            if (maskChar.isValidCharacter(stringCharacter)) {
                builder.append(maskChar.processCharacter(stringCharacter));
                ++strIndex;
                ++maskCharIndex;
                continue;
            }
            if (maskChar.isPrepopulate()) {
                builder.append(maskChar.processCharacter(stringCharacter));
                ++maskCharIndex;
                continue;
            }
            ++strIndex;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

