/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.util.Resources;
import io.github.toolfactory.jvm.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Properties {
    public static Map<BigDecimal, java.util.Properties> loadFromResources(String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException, ParseException {
        Map<URL, InputStream> resources = Resources.getAsInputStreams(resRelPath, classLoaders);
        TreeMap<BigDecimal, java.util.Properties> orderedProperties = new TreeMap<BigDecimal, java.util.Properties>();
        if (resources.isEmpty()) {
            return orderedProperties;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(',');
        symbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.#", symbols);
        decimalFormat.setParseBigDecimal(true);
        ArrayList<java.util.Properties> propertiesWithoutPriority = new ArrayList<java.util.Properties>();
        for (Map.Entry<URL, InputStream> entry : resources.entrySet()) {
            java.util.Properties props = new java.util.Properties();
            InputStream inputStream = entry.getValue();
            try {
                props.load(entry.getValue());
                String propValue = props.getProperty(propertyName);
                if (propValue != null && !propValue.trim().isEmpty()) {
                    try {
                        orderedProperties.put(Properties.stringToBigDecimal(propValue, decimalFormat), props);
                        continue;
                    }
                    catch (ParseException exc) {
                        throw new IllegalArgumentException(Strings.compile("The value '{}' of property named '{}' inside the file {} is incorrect", propValue, propertyName, entry.getKey().getPath()), exc);
                    }
                }
                propertiesWithoutPriority.add(props);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (!propertiesWithoutPriority.isEmpty()) {
            BigDecimal currentMinPriority = Properties.stringToBigDecimal("1", decimalFormat);
            if (!orderedProperties.isEmpty()) {
                currentMinPriority = orderedProperties.firstKey();
            }
            for (java.util.Properties props : propertiesWithoutPriority) {
                orderedProperties.put(currentMinPriority.subtract(new BigDecimal(1)), props);
            }
        }
        return orderedProperties;
    }

    private static BigDecimal stringToBigDecimal(String value, DecimalFormat decimalFormat) throws ParseException {
        if ((value = value.trim()).contains(".")) {
            String wholeNumber = value.substring(0, value.indexOf("."));
            String fractionalPart = value.substring(value.indexOf(".") + 1, value.length());
            fractionalPart = fractionalPart.replace(".", "");
            value = wholeNumber + "." + fractionalPart;
        }
        return (BigDecimal)decimalFormat.parse(value);
    }

    public static java.util.Properties loadFromResourceWithHigherPropertyValue(ClassLoader resourceClassLoader, String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException, ParseException {
        NavigableMap orderedProperties = ((TreeMap)Properties.loadFromResources(resRelPath, propertyName, classLoaders)).descendingMap();
        return (java.util.Properties)orderedProperties.entrySet().iterator().next().getValue();
    }

    public static java.util.Properties loadFromResourcesAndMerge(String resRelPath, String propertyName, ClassLoader ... classLoaders) throws IOException, ParseException {
        Map<BigDecimal, java.util.Properties> orderedProperties = Properties.loadFromResources(resRelPath, propertyName, classLoaders);
        java.util.Properties properties = new java.util.Properties();
        for (Map.Entry<BigDecimal, java.util.Properties> entry : orderedProperties.entrySet()) {
            properties.putAll((Map<?, ?>)entry.getValue());
        }
        properties.remove(propertyName);
        return properties;
    }
}

