/*
 * Decompiled with CFR 0.152.
 */
package io.github.thingersoft.pm.mojo;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import io.github.thingersoft.pm.api.annotations.Properties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EnhanceMojo
extends AbstractMojo {
    public static final String GOAL = "enhance";
    @Parameter(property="project", defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="true", property="javassist.includeTestClasses", required=true)
    private Boolean includeTestClasses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<URL> classPath = new ArrayList<URL>();
            for (Object runtimeResource : this.project.getRuntimeClasspathElements()) {
                classPath.add(this.resolveUrl((String)runtimeResource));
            }
            String targetClassesDirectory = this.project.getBuild().getOutputDirectory();
            classPath.add(this.resolveUrl(targetClassesDirectory));
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader pluginClassLoader = URLClassLoader.newInstance(classPath.toArray(new URL[classPath.size()]), contextClassLoader);
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            ArrayList<String> mappedClassesNames = new ArrayList<String>();
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
                ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(Properties.class.getName());
                for (ClassInfo mappedClassInfo : classInfoList) {
                    mappedClassesNames.add(mappedClassInfo.getName());
                }
            }
            for (String mappedClassName : mappedClassesNames) {
                ClassPool classPool = new ClassPool(ClassPool.getDefault());
                classPool.childFirstLookup = true;
                classPool.appendClassPath(targetClassesDirectory);
                classPool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
                classPool.appendSystemPath();
                CtClass ctMappedClass = classPool.get(mappedClassName);
                CtConstructor initializer = ctMappedClass.makeClassInitializer();
                initializer.setBody("io.github.thingersoft.pm.api.PropertiesStore.checkInitByAnnotatedClass(" + mappedClassName + ".class);");
                ctMappedClass.writeFile(targetClassesDirectory);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    private URL resolveUrl(String resource) {
        try {
            return new File(resource).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

