/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Attribute;
import org.jetbrains.coverage.org.objectweb.asm.ConstantDynamic;
import org.jetbrains.coverage.org.objectweb.asm.Constants;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;

public abstract class MethodVisitor {
    private static final String REQUIRES_ASM5 = "This feature requires ASM5";
    protected final int api;
    protected MethodVisitor mv;

    /*
     * WARNING - void declaration
     */
    protected MethodVisitor(int api) {
        this((int)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MethodVisitor(int api, MethodVisitor methodVisitor) {
        void var2_2;
        void var1_1;
        if (api != 589824 && api != 524288 && api != 458752 && api != 393216 && api != 327680 && api != 262144 && api != 0x10A0000) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == 0x10A0000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = var1_1;
        this.mv = var2_2;
    }

    public MethodVisitor getDelegate() {
        return this.mv;
    }

    /*
     * WARNING - void declaration
     */
    public void visitParameter(String name, int access) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitParameter((String)var1_1, (int)var2_2);
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        if (this.mv != null) {
            return this.mv.visitAnnotationDefault();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            return this.mv.visitAnnotation((String)var1_1, (boolean)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.mv.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitAnnotableParameterCount((int)var1_1, (boolean)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.mv.visitParameterAnnotation((int)var1_1, (String)var2_2, (boolean)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAttribute(Attribute attribute) {
        if (this.mv != null) {
            void var1_1;
            this.mv.visitAttribute((Attribute)var1_1);
        }
    }

    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitFrame((int)var1_1, (int)var2_2, (Object[])var3_3, numStack, stack);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        if (this.mv != null) {
            void var1_1;
            this.mv.visitInsn((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitIntInsn((int)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitVarInsn((int)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitTypeInsn((int)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        void var1_1;
        void var3_3;
        void var2_2;
        int opcodeAndSource = opcode | (this.api < 327680 ? 256 : 0);
        this.visitMethodInsn(opcodeAndSource, (String)var2_2, (String)var3_3, descriptor, var1_1 == 185);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (this.api < 327680 && (opcode & 0x100) == 0) {
            if (isInterface != (opcode == 185)) {
                throw new UnsupportedOperationException("INVOKESPECIAL/STATIC on interfaces requires ASM5");
            }
            this.visitMethodInsn(opcode, owner, name, descriptor);
            return;
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitMethodInsn((int)(var1_1 & 0xFFFFFEFF), (String)var2_2, (String)var3_3, descriptor, isInterface);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitJumpInsn((int)var1_1, (Label)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        if (this.mv != null) {
            void var1_1;
            this.mv.visitLabel((Label)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        if (this.api < 327680 && (value instanceof Handle || value instanceof Type && ((Type)value).getSort() == 11)) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.api < 458752 && value instanceof ConstantDynamic) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.mv != null) {
            void var1_1;
            this.mv.visitLdcInsn(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitIincInsn((int)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.mv.visitInsnAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitTryCatchBlock((Label)var1_1, (Label)var2_2, (Label)var3_3, type);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.mv.visitTryCatchAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mv.visitLocalVariable((String)var1_1, (String)var2_2, (String)var3_3, start, end, index);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException(REQUIRES_ASM5);
        }
        if (this.mv != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.mv.visitLocalVariableAnnotation((int)var1_1, (TypePath)var2_2, (Label[])var3_3, end, index, descriptor, visible);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line2, Label start) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitLineNumber((int)var1_1, (Label)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.mv != null) {
            void var2_2;
            void var1_1;
            this.mv.visitMaxs((int)var1_1, (int)var2_2);
        }
    }

    public void visitEnd() {
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }
}

