/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public final class KotlinInlineFilter
implements IFilter {
    private int firstGeneratedLineNumber = -1;
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]++)(#[0-9]++)?+(,[0-9]++)?+:([0-9]++)(,[0-9]++)?+");
    private static final Pattern FILE_INFO_PATTERN = Pattern.compile("\\+ ([0-9]++) (.++)");

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceDebugExtension() == null) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        if (this.firstGeneratedLineNumber == -1) {
            this.firstGeneratedLineNumber = KotlinInlineFilter.getFirstGeneratedLineNumber(context.getSourceFileName(), context.getSourceDebugExtension());
        }
        int line2 = 0;
        for (AbstractInsnNode i : methodNode.instructions) {
            if (15 == i.getType()) {
                line2 = ((LineNumberNode)i).line;
            }
            if (line2 < this.firstGeneratedLineNumber) continue;
            output.ignore(i, i);
        }
    }

    private static int getFirstGeneratedLineNumber(String sourceFileName, String smap) {
        try {
            String line2;
            BufferedReader br = new BufferedReader(new StringReader(smap));
            KotlinInlineFilter.expectLine(br, "SMAP");
            KotlinInlineFilter.expectLine(br, sourceFileName);
            KotlinInlineFilter.expectLine(br, "Kotlin");
            KotlinInlineFilter.expectLine(br, "*S Kotlin");
            KotlinInlineFilter.expectLine(br, "*F");
            BitSet sourceFileIds = new BitSet();
            while (!"*L".equals(line2 = br.readLine())) {
                br.readLine();
                Matcher m = FILE_INFO_PATTERN.matcher(line2);
                if (!m.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line2);
                }
                String fileName = m.group(2);
                if (!fileName.equals(sourceFileName)) continue;
                sourceFileIds.set(Integer.parseInt(m.group(1)));
            }
            if (sourceFileIds.isEmpty()) {
                throw new IllegalStateException("Unexpected SMAP FileSection");
            }
            int min = Integer.MAX_VALUE;
            while (!(line2 = br.readLine()).equals("*E") && !line2.equals("*S KotlinDebug")) {
                Matcher m = LINE_INFO_PATTERN.matcher(line2);
                if (!m.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line2);
                }
                int inputStartLine = Integer.parseInt(m.group(1));
                int lineFileID = Integer.parseInt(m.group(2).substring(1));
                int outputStartLine = Integer.parseInt(m.group(4));
                if (sourceFileIds.get(lineFileID) && inputStartLine == outputStartLine) continue;
                min = Math.min(outputStartLine, min);
            }
            return min;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void expectLine(BufferedReader br, String expected) throws IOException {
        String line2 = br.readLine();
        if (!expected.equals(line2)) {
            throw new IllegalStateException("Unexpected SMAP line: " + line2);
        }
    }
}

