/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.LeadingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.NameMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.ignore.internal.TrailingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.WildCardMatcher;
import org.eclipse.jgit.ignore.internal.WildMatcher;

public class PathMatcher
extends AbstractMatcher {
    private static final WildMatcher WILD_NO_DIRECTORY = new WildMatcher(false);
    private static final WildMatcher WILD_ONLY_DIRECTORY = new WildMatcher(true);
    private final List<IMatcher> matchers;
    private final char slash;
    private final boolean beginning;

    private PathMatcher(String pattern, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        super(pattern, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        this.beginning = pattern.indexOf(this.slash) == 0;
        this.matchers = this.isSimplePathWithSegments(pattern) ? null : PathMatcher.createMatchers(Strings.split(pattern, this.slash), pathSeparator, dirOnly);
    }

    private boolean isSimplePathWithSegments(String path2) {
        return !Strings.isWildCard(path2) && path2.indexOf(92) < 0 && Strings.count(path2, this.slash, true) > 0;
    }

    private static List<IMatcher> createMatchers(List<String> segments, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        ArrayList<IMatcher> matchers = new ArrayList<IMatcher>(segments.size());
        int i = 0;
        while (i < segments.size()) {
            String segment = segments.get(i);
            IMatcher matcher = PathMatcher.createNameMatcher0(segment, pathSeparator, dirOnly, i == segments.size() - 1);
            if (i > 0) {
                IMatcher last = (IMatcher)matchers.get(matchers.size() - 1);
                if (PathMatcher.isWild(matcher) && PathMatcher.isWild(last)) {
                    matchers.remove(matchers.size() - 1);
                }
            }
            matchers.add(matcher);
            ++i;
        }
        return matchers;
    }

    public static IMatcher createPathMatcher(String pattern, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        char slash;
        int slashIdx = (pattern = PathMatcher.trim(pattern)).indexOf(slash = Strings.getPathSeparator(pathSeparator), 1);
        if (slashIdx > 0 && slashIdx < pattern.length() - 1) {
            return new PathMatcher(pattern, pathSeparator, dirOnly);
        }
        return PathMatcher.createNameMatcher0(pattern, pathSeparator, dirOnly, true);
    }

    private static String trim(String pattern) {
        while (pattern.length() > 0 && pattern.charAt(pattern.length() - 1) == ' ') {
            if (pattern.length() > 1 && pattern.charAt(pattern.length() - 2) == '\\') {
                pattern = String.valueOf(pattern.substring(0, pattern.length() - 2)) + " ";
                return pattern;
            }
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    private static IMatcher createNameMatcher0(String segment, Character pathSeparator, boolean dirOnly, boolean lastSegment) throws InvalidPatternException {
        if ("**".equals(segment) || "/**".equals(segment)) {
            return dirOnly && lastSegment ? WILD_ONLY_DIRECTORY : WILD_NO_DIRECTORY;
        }
        Strings.PatternState state = Strings.checkWildCards(segment);
        switch (state) {
            case LEADING_ASTERISK_ONLY: {
                return new LeadingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case TRAILING_ASTERISK_ONLY: {
                return new TrailingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case COMPLEX: {
                return new WildCardMatcher(segment, pathSeparator, dirOnly);
            }
        }
        return new NameMatcher(segment, pathSeparator, dirOnly, true);
    }

    @Override
    public boolean matches(String path2, boolean assumeDirectory, boolean pathMatch) {
        if (this.matchers == null) {
            return this.simpleMatch(path2, assumeDirectory, pathMatch);
        }
        return this.iterate(path2, 0, path2.length(), assumeDirectory, pathMatch);
    }

    private boolean simpleMatch(String path2, boolean assumeDirectory, boolean pathMatch) {
        boolean hasSlash;
        boolean bl = hasSlash = path2.indexOf(this.slash) == 0;
        if (this.beginning && !hasSlash) {
            path2 = String.valueOf(this.slash) + path2;
        }
        if (!this.beginning && hasSlash) {
            path2 = path2.substring(1);
        }
        if (path2.equals(this.pattern)) {
            return !this.dirOnly || assumeDirectory;
        }
        String prefix = String.valueOf(this.pattern) + this.slash;
        if (pathMatch) {
            return path2.equals(prefix) && (!this.dirOnly || assumeDirectory);
        }
        return path2.startsWith(prefix);
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl) {
        throw new UnsupportedOperationException("Path matcher works only on entire paths");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean iterate(String path2, int startIncl, int endExcl, boolean assumeDirectory, boolean pathMatch) {
        int matcher = 0;
        int right = startIncl;
        boolean match = false;
        int lastWildmatch = -1;
        int wildmatchBacktrackPos = -1;
        while (true) {
            int left = ++right;
            if ((right = path2.indexOf(this.slash, right)) == -1) {
                if (left < endExcl) {
                    match = this.matches(matcher, path2, left, endExcl, assumeDirectory, pathMatch);
                } else {
                    if (!match) return false;
                    if (PathMatcher.isWild(this.matchers.get(matcher))) return false;
                    boolean bl = true;
                    match = bl;
                }
                if (match) {
                    if (matcher < this.matchers.size() - 1 && PathMatcher.isWild(this.matchers.get(matcher))) {
                        match = this.matches(++matcher, path2, left, endExcl, assumeDirectory, pathMatch);
                    } else if (this.dirOnly && !assumeDirectory) {
                        return false;
                    }
                }
                if (!match) return false;
                if (matcher + 1 != this.matchers.size()) return false;
                return true;
            }
            if (wildmatchBacktrackPos < 0) {
                wildmatchBacktrackPos = right;
            }
            if (right - left <= 0) continue;
            match = this.matches(matcher, path2, left, right, assumeDirectory, pathMatch);
            if (match) {
                boolean wasWild = PathMatcher.isWild(this.matchers.get(matcher));
                if (wasWild) {
                    lastWildmatch = matcher;
                    wildmatchBacktrackPos = -1;
                    right = left - 1;
                }
                if (++matcher == this.matchers.size()) {
                    if (!pathMatch) {
                        return true;
                    }
                    if (right == endExcl - 1) {
                        if (!this.dirOnly) return true;
                        if (assumeDirectory) return true;
                        return false;
                    }
                    if (wasWild) {
                        return true;
                    }
                    if (lastWildmatch < 0) return false;
                    matcher = lastWildmatch + 1;
                    right = wildmatchBacktrackPos;
                    wildmatchBacktrackPos = -1;
                }
            } else {
                if (lastWildmatch == -1) return false;
                matcher = lastWildmatch + 1;
                right = wildmatchBacktrackPos;
                wildmatchBacktrackPos = -1;
            }
            ++right;
        }
    }

    private boolean matches(int matcherIdx, String path2, int startIncl, int endExcl, boolean assumeDirectory, boolean pathMatch) {
        IMatcher matcher = this.matchers.get(matcherIdx);
        boolean matches = matcher.matches(path2, startIncl, endExcl);
        if (!(matches && pathMatch && matcherIdx >= this.matchers.size() - 1 && matcher instanceof AbstractMatcher)) {
            return matches;
        }
        return assumeDirectory || !((AbstractMatcher)matcher).dirOnly;
    }

    private static boolean isWild(IMatcher matcher) {
        return matcher == WILD_NO_DIRECTORY || matcher == WILD_ONLY_DIRECTORY;
    }
}

