/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.api.KoverMergedConfig;
import kotlinx.kover.gradle.plugin.KoverGradlePlugin;
import kotlinx.kover.gradle.plugin.appliers.ProjectApplier;
import kotlinx.kover.gradle.plugin.util.SemVer;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lkotlinx/kover/gradle/plugin/KoverGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "addDeprecations", "checkVersion", "Lorg/gradle/api/invocation/Gradle;", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKoverGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverGradlePlugin.kt\nkotlinx/kover/gradle/plugin/KoverGradlePlugin\n+ 2 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 3 TaskCollectionExtensions.kt\norg/gradle/kotlin/dsl/TaskCollectionExtensionsKt\n*L\n1#1,58:1\n96#2:59\n34#3:60\n*S KotlinDebug\n*F\n+ 1 KoverGradlePlugin.kt\nkotlinx/kover/gradle/plugin/KoverGradlePlugin\n*L\n52#1:59\n53#1:60\n*E\n"})
public final class KoverGradlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Gradle gradle = target.getGradle();
        Intrinsics.checkNotNullExpressionValue(gradle, "target.gradle");
        this.checkVersion(gradle);
        ProjectApplier applier = new ProjectApplier(target);
        applier.onApply();
        this.addDeprecations(target);
    }

    private final void checkVersion(Gradle $this$checkVersion) {
        String string = $this$checkVersion.getGradleVersion();
        Intrinsics.checkNotNullExpressionValue(string, "gradleVersion");
        SemVer semVer = SemVer.Companion.ofVariableOrNull(string);
        Intrinsics.checkNotNull(semVer);
        SemVer current = semVer;
        SemVer semVer2 = SemVer.Companion.ofVariableOrNull("6.8");
        Intrinsics.checkNotNull(semVer2);
        SemVer min = semVer2;
        if (current.compareTo(min) < 0) {
            throw new GradleException("Gradle version '" + $this$checkVersion.getGradleVersion() + "' is not supported by Kover Plugin. Minimal supported version is '6.8'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addDeprecations(Project $this$addDeprecations) {
        void name$iv;
        void $this$create$iv;
        ExtensionContainer extensionContainer = $this$addDeprecations.getExtensions();
        Intrinsics.checkNotNullExpressionValue(extensionContainer, "extensions");
        ExtensionContainer extensionContainer2 = extensionContainer;
        String string = "koverMerged";
        Object[] constructionArguments$iv = new Object[]{};
        boolean $i$f$create = false;
        Intrinsics.checkNotNullExpressionValue($this$create$iv.create((String)name$iv, KoverMergedConfig.class, Arrays.copyOf(constructionArguments$iv, constructionArguments$iv.length)), "create(name, T::class.ja\u2026, *constructionArguments)");
        TaskContainer taskContainer = $this$addDeprecations.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer, "tasks");
        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
        boolean $i$f$withType = false;
        TaskCollection taskCollection = $this$withType$iv.withType(Test.class);
        Intrinsics.checkNotNullExpressionValue(taskCollection, "withType(S::class.java)");
        taskCollection.configureEach((Action)addDeprecations.1.INSTANCE);
    }
}

